/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.ide.LibraryImpl;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public final class JavaLibraryImpl
extends LibraryImpl
implements JavaLibrary,
Serializable {
    private static final long serialVersionUID = 1L;
    private final File jarFile;
    private final List<JavaLibrary> dependencies;

    public JavaLibraryImpl(File jarFile, String project, List<JavaLibrary> dependencies, MavenCoordinates requestedCoordinates, MavenCoordinates resolvedCoordinates, boolean isSkipped, boolean isProvided) {
        super(project, requestedCoordinates, resolvedCoordinates, isSkipped, isProvided);
        this.jarFile = jarFile;
        this.dependencies = ImmutableList.copyOf(dependencies);
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public List<? extends JavaLibrary> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaLibraryImpl that = (JavaLibraryImpl)o;
        return Objects.equals(this.jarFile, that.jarFile) && Objects.equals(this.dependencies, that.dependencies);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.jarFile, this.dependencies);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("super", (Object)super.toString()).add("jarFile", (Object)this.jarFile).add("dependencies", this.dependencies).toString();
    }
}

