/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InnerClassNode;

public class AsmUtils {
    @VisibleForTesting
    public static List<AnnotationNode> getInvisibleAnnotationsOnClassOrOuterClasses(ClassReaderProvider classReader, ClassNode classNode, ILogger logger) throws IOException {
        String outerClassName;
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        do {
            List invisibleAnnotations;
            if ((invisibleAnnotations = classNode.invisibleAnnotations) == null) continue;
            listBuilder.addAll((Iterable)invisibleAnnotations);
        } while ((classNode = (outerClassName = AsmUtils.getOuterClassName(classNode)) != null ? AsmUtils.readClass(classReader, outerClassName, logger) : null) != null);
        return listBuilder.build();
    }

    public static ClassNode readClass(ClassReaderProvider classReaderProvider, String className, ILogger logger) throws IOException {
        ClassReader classReader = classReaderProvider.loadClassBytes(className, logger);
        return classReader != null ? AsmUtils.readClass(classReader) : null;
    }

    public static ClassNode readClass(ClassReader classReader) {
        ClassNode node = new ClassNode();
        classReader.accept((ClassVisitor)node, 8);
        return node;
    }

    public static List<ClassNode> parseParents(ILogger logger, ClassReaderProvider classBytesReader, ClassNode classNode, int targetApi) throws IOException {
        ArrayList<ClassNode> parentNodes = new ArrayList<ClassNode>();
        String currentParentName = classNode.superName;
        while (currentParentName != null) {
            ClassNode parentNode = AsmUtils.readClass(classBytesReader, currentParentName, logger);
            if (parentNode != null) {
                parentNodes.add(parentNode);
                currentParentName = parentNode.superName;
                continue;
            }
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                parentNode = AsmUtils.readClass(contextClassLoader, currentParentName);
                parentNodes.add(parentNode);
                currentParentName = parentNode.superName;
            }
            catch (IOException e) {
                logger.warning(e.getMessage(), new Object[0]);
                logger.warning("IncrementalVisitor parseParents could not locate %1$s which is an ancestor of project class %2$s.\n%2$s is not eligible for hot swap. \nIf the class targets a more recent platform than %3$d, add a @TargetApi annotation to silence this warning.", new Object[]{currentParentName, classNode.name, targetApi});
                return ImmutableList.of();
            }
        }
        return parentNodes;
    }

    public static ClassNode readClass(ClassLoader classLoader, String className) throws IOException {
        try (InputStream is = classLoader.getResourceAsStream(className + ".class");){
            if (is == null) {
                throw new IOException("Failed to find byte code for " + className);
            }
            ClassReader parentClassReader = new ClassReader(is);
            ClassNode node = new ClassNode();
            parentClassReader.accept((ClassVisitor)node, 8);
            ClassNode classNode = node;
            return classNode;
        }
    }

    public static ClassNode parsePackageInfo(File inputFile) throws IOException {
        File packageFolder = inputFile.getParentFile();
        File packageInfoClass = new File(packageFolder, "package-info.class");
        if (packageInfoClass.exists()) {
            try (BufferedInputStream reader = new BufferedInputStream(new FileInputStream(packageInfoClass));){
                ClassReader classReader = new ClassReader((InputStream)reader);
                ClassNode classNode = AsmUtils.readClass(classReader);
                return classNode;
            }
        }
        return null;
    }

    public static String getOuterClassName(ClassNode classNode) {
        if (classNode.outerClass != null) {
            return classNode.outerClass;
        }
        if (classNode.innerClasses != null) {
            List innerClassNodes = classNode.innerClasses;
            for (InnerClassNode innerClassNode : innerClassNodes) {
                if (!innerClassNode.name.equals(classNode.name)) continue;
                return innerClassNode.outerName;
            }
        }
        return null;
    }

    public static class JarBasedClassReader
    implements ClassReaderProvider {
        private final File file;

        public JarBasedClassReader(File file) {
            this.file = file;
        }

        /*
         * Loose catch block
         */
        @Override
        public ClassReader loadClassBytes(String className, ILogger logger) throws IOException {
            block28: {
                Throwable throwable = null;
                try (JarFile jarFile = new JarFile(this.file);){
                    ZipEntry entry = jarFile.getEntry(className.replace(".", "/") + ".class");
                    if (entry != null) {
                        try (InputStream is = jarFile.getInputStream(entry);){
                            ClassReader classReader = new ClassReader(is);
                            return classReader;
                        }
                    }
                    break block28;
                    {
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
            }
            return null;
        }
    }

    public static class DirectoryBasedClassReader
    implements ClassReaderProvider {
        private final File binaryFolder;

        public DirectoryBasedClassReader(File binaryFolder) {
            this.binaryFolder = binaryFolder;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ClassReader loadClassBytes(String className, ILogger logger) {
            File outerClassFile = new File(this.binaryFolder, className + ".class");
            if (!outerClassFile.exists()) return null;
            logger.verbose("Parsing %s", new Object[]{outerClassFile});
            try (BufferedInputStream outerClassInputStream = new BufferedInputStream(new FileInputStream(outerClassFile));){
                ClassReader classReader = new ClassReader((InputStream)outerClassInputStream);
                return classReader;
            }
            catch (IOException e) {
                logger.error((Throwable)e, "Cannot parse %s", new Object[]{className});
            }
            return null;
        }
    }

    public static interface ClassReaderProvider {
        public ClassReader loadClassBytes(String var1, ILogger var2) throws IOException;
    }
}

