/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.AsmUtils;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.commons.SerialVersionUIDAdder;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class IncrementalVisitor
extends ClassVisitor {
    public static final String PACKAGE = "com/android/tools/fd/runtime";
    public static final String ABSTRACT_PATCHES_LOADER_IMPL = "com/android/tools/fd/runtime/AbstractPatchesLoaderImpl";
    public static final String APP_PATCHES_LOADER_IMPL = "com/android/tools/fd/runtime/AppPatchesLoaderImpl";
    protected static final Type INSTANT_RELOAD_EXCEPTION = Type.getObjectType((String)"com/android/tools/fd/runtime/InstantReloadException");
    protected static final Type RUNTIME_TYPE = Type.getObjectType((String)"com/android/tools/fd/runtime/AndroidInstantRuntime");
    public static final Type DISABLE_ANNOTATION_TYPE = Type.getObjectType((String)"com/android/tools/ir/api/DisableInstantRun");
    public static final Type TARGET_API_TYPE = Type.getObjectType((String)"android/annotation/TargetApi");
    protected static final boolean TRACING_ENABLED = Boolean.getBoolean("FDR_TRACING");
    public static final Type CHANGE_TYPE = Type.getObjectType((String)"com/android/tools/fd/runtime/IncrementalChange");
    protected String visitedClassName;
    protected String visitedSuperName;
    protected final ClassNode classNode;
    protected final List<ClassNode> parentNodes;
    protected final ILogger logger;

    public IncrementalVisitor(ClassNode classNode, List<ClassNode> parentNodes, ClassVisitor classVisitor, ILogger logger) {
        super(327680, classVisitor);
        this.classNode = classNode;
        this.parentNodes = parentNodes;
        this.logger = logger;
        this.logger.verbose("%s: Visiting %s", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), classNode.name});
    }

    protected static String getRuntimeTypeName(Type type) {
        return "L" + type.getInternalName() + ";";
    }

    FieldNode getFieldByName(String fieldName) {
        FieldNode fieldNode = IncrementalVisitor.getFieldByNameInClass(fieldName, this.classNode);
        Iterator<ClassNode> iterator = this.parentNodes.iterator();
        while (fieldNode == null && iterator.hasNext()) {
            ClassNode parentNode = iterator.next();
            fieldNode = IncrementalVisitor.getFieldByNameInClass(fieldName, parentNode);
        }
        return fieldNode;
    }

    protected static FieldNode getFieldByNameInClass(String fieldName, ClassNode classNode) {
        List fields = classNode.fields;
        for (FieldNode field : fields) {
            if (!field.name.equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    protected MethodNode getMethodByName(String methodName, String desc) {
        MethodNode methodNode = IncrementalVisitor.getMethodByNameInClass(methodName, desc, this.classNode);
        Iterator<ClassNode> iterator = this.parentNodes.iterator();
        while (methodNode == null && iterator.hasNext()) {
            ClassNode parentNode = iterator.next();
            methodNode = IncrementalVisitor.getMethodByNameInClass(methodName, desc, parentNode);
        }
        return methodNode;
    }

    protected static MethodNode getMethodByNameInClass(String methodName, String desc, ClassNode classNode) {
        List methods = classNode.methods;
        for (MethodNode method : methods) {
            if (!method.name.equals(methodName) || !method.desc.equals(desc)) continue;
            return method;
        }
        return null;
    }

    protected static void trace(GeneratorAdapter mv, String s) {
        mv.push(s);
        mv.invokeStatic(Type.getObjectType((String)"com/android/tools/fd/runtime/AndroidInstantRuntime"), Method.getMethod((String)"void trace(String)"));
    }

    protected static void trace(GeneratorAdapter mv, String s1, String s2) {
        mv.push(s1);
        mv.push(s2);
        mv.invokeStatic(Type.getObjectType((String)"com/android/tools/fd/runtime/AndroidInstantRuntime"), Method.getMethod((String)"void trace(String, String)"));
    }

    protected static void trace(GeneratorAdapter mv, String s1, String s2, String s3) {
        mv.push(s1);
        mv.push(s2);
        mv.push(s3);
        mv.invokeStatic(Type.getObjectType((String)"com/android/tools/fd/runtime/AndroidInstantRuntime"), Method.getMethod((String)"void trace(String, String, String)"));
    }

    protected static void trace(GeneratorAdapter mv, String s1, String s2, String s3, String s4) {
        mv.push(s1);
        mv.push(s2);
        mv.push(s3);
        mv.push(s4);
        mv.invokeStatic(Type.getObjectType((String)"com/android/tools/fd/runtime/AndroidInstantRuntime"), Method.getMethod((String)"void trace(String, String, String, String)"));
    }

    protected static void trace(GeneratorAdapter mv, int argsNumber) {
        StringBuilder methodSignature = new StringBuilder("void trace(String");
        for (int i = 0; i < argsNumber - 1; ++i) {
            methodSignature.append(", String");
        }
        methodSignature.append(")");
        mv.invokeStatic(Type.getObjectType((String)"com/android/tools/fd/runtime/AndroidInstantRuntime"), Method.getMethod((String)methodSignature.toString()));
    }

    protected static boolean isAccessCompatibleWithInstantRun(int access) {
        return (access & 0x540) == 0;
    }

    public static File instrumentClass(int targetApiLevel, File inputRootDirectory, File inputFile, File outputDirectory, VisitorBuilder visitorBuilder, ILogger logger) throws IOException {
        ImmutableList parentsNodes;
        String path = FileUtils.relativePath((File)inputFile, (File)inputRootDirectory);
        if (!IncrementalVisitor.isClassEligibleForInstantRun(inputFile)) {
            if (visitorBuilder.getOutputType() == OutputType.INSTRUMENT) {
                File outputFile = new File(outputDirectory, path);
                Files.createParentDirs((File)outputFile);
                Files.copy((File)inputFile, (File)outputFile);
                return outputFile;
            }
            return null;
        }
        byte[] classBytes = Files.toByteArray((File)inputFile);
        ClassReader classReader = new ClassReader(classBytes);
        ClassWriter classWriter = new ClassWriter(classReader, 2){

            protected String getCommonSuperClass(String type1, String type2) {
                Class<?> d;
                Class<?> c;
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                try {
                    c = Class.forName(type1.replace('/', '.'), false, classLoader);
                    d = Class.forName(type2.replace('/', '.'), false, classLoader);
                }
                catch (ClassNotFoundException e) {
                    return "instant/run/NoCommonSuperClass";
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (c.isAssignableFrom(d)) {
                    return type1;
                }
                if (d.isAssignableFrom(c)) {
                    return type2;
                }
                if (c.isInterface() || d.isInterface()) {
                    return "java/lang/Object";
                }
                while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
                }
                return c.getName().replace('.', '/');
            }
        };
        ClassNode classNode = AsmUtils.readClass(classReader);
        AccessRight accessRight = AccessRight.fromNodeAccess(classNode.access);
        File outputFile = new File(outputDirectory, path);
        if ((classNode.access & 0x200) != 0) {
            if (visitorBuilder.getOutputType() == OutputType.INSTRUMENT) {
                Files.createParentDirs((File)outputFile);
                if (accessRight == AccessRight.PACKAGE_PRIVATE) {
                    classNode.access |= 1;
                    classNode.accept((ClassVisitor)classWriter);
                    Files.write((byte[])classWriter.toByteArray(), (File)outputFile);
                } else {
                    Files.write((byte[])classBytes, (File)outputFile);
                }
                return outputFile;
            }
            return null;
        }
        AsmUtils.DirectoryBasedClassReader directoryClassReader = new AsmUtils.DirectoryBasedClassReader(IncrementalVisitor.getBinaryFolder(inputFile, classNode));
        Object object = parentsNodes = IncrementalVisitor.isClassTargetingNewerPlatform(targetApiLevel, TARGET_API_TYPE, directoryClassReader, classNode, logger) ? ImmutableList.of() : AsmUtils.parseParents(logger, directoryClassReader, classNode, targetApiLevel);
        if (parentsNodes.isEmpty() || IncrementalVisitor.isPackageInstantRunDisabled(inputFile)) {
            if (visitorBuilder.getOutputType() == OutputType.INSTRUMENT) {
                Files.createParentDirs((File)outputFile);
                Files.write((byte[])classBytes, (File)outputFile);
                return outputFile;
            }
            return null;
        }
        outputFile = new File(outputDirectory, visitorBuilder.getMangledRelativeClassFilePath(path));
        Files.createParentDirs((File)outputFile);
        IncrementalVisitor visitor = visitorBuilder.build(classNode, (List<ClassNode>)parentsNodes, (ClassVisitor)classWriter, logger);
        if (visitorBuilder.getOutputType() == OutputType.INSTRUMENT) {
            classNode.accept((ClassVisitor)new SerialVersionUIDAdder((ClassVisitor)visitor));
        } else {
            classNode.accept((ClassVisitor)visitor);
        }
        Files.write((byte[])classWriter.toByteArray(), (File)outputFile);
        return outputFile;
    }

    private static File getBinaryFolder(File inputFile, ClassNode classNode) {
        return new File(inputFile.getAbsolutePath().substring(0, inputFile.getAbsolutePath().length() - (classNode.name.length() + ".class".length())));
    }

    static boolean isClassTargetingNewerPlatform(int targetApiLevel, Type targetApiAnnotationType, AsmUtils.ClassReaderProvider locator, ClassNode classNode, ILogger logger) throws IOException {
        List<AnnotationNode> invisibleAnnotations = AsmUtils.getInvisibleAnnotationsOnClassOrOuterClasses(locator, classNode, logger);
        for (AnnotationNode classAnnotation : invisibleAnnotations) {
            if (!classAnnotation.desc.equals(targetApiAnnotationType.getDescriptor())) continue;
            List values = classAnnotation.values;
            for (int valueIndex = 0; valueIndex < values.size(); valueIndex += 2) {
                String name = (String)values.get(valueIndex);
                if (!name.equals("value")) continue;
                Object value = values.get(valueIndex + 1);
                return (Integer)Integer.class.cast(value) > targetApiLevel;
            }
        }
        return false;
    }

    private static boolean isPackageInstantRunDisabled(File inputFile) throws IOException {
        ClassNode packageInfoClass = AsmUtils.parsePackageInfo(inputFile);
        if (packageInfoClass != null) {
            List annotations = packageInfoClass.invisibleAnnotations;
            if (annotations == null) {
                return false;
            }
            for (AnnotationNode annotation : annotations) {
                if (!annotation.desc.equals(DISABLE_ANNOTATION_TYPE.getDescriptor())) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isClassEligibleForInstantRun(File inputFile) {
        if (inputFile.getPath().endsWith(".class")) {
            String fileName = inputFile.getName();
            return !fileName.equals("R.class") && !fileName.startsWith("R$");
        }
        return false;
    }

    public static interface VisitorBuilder {
        public IncrementalVisitor build(ClassNode var1, List<ClassNode> var2, ClassVisitor var3, ILogger var4);

        public String getMangledRelativeClassFilePath(String var1);

        public OutputType getOutputType();
    }

    protected static enum AccessRight {
        PRIVATE,
        PACKAGE_PRIVATE,
        PROTECTED,
        PUBLIC;


        static AccessRight fromNodeAccess(int nodeAccess) {
            if ((nodeAccess & 2) != 0) {
                return PRIVATE;
            }
            if ((nodeAccess & 4) != 0) {
                return PROTECTED;
            }
            if ((nodeAccess & 1) != 0) {
                return PUBLIC;
            }
            return PACKAGE_PRIVATE;
        }
    }

    public static enum OutputType {
        INSTRUMENT,
        OVERRIDE;

    }
}

