/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.DexPackagingPolicy;
import com.android.sdklib.AndroidVersion;

public enum InstantRunPatchingPolicy {
    PRE_LOLLIPOP(DexPackagingPolicy.STANDARD, false),
    MULTI_APK(DexPackagingPolicy.INSTANT_RUN_MULTI_APK, true),
    MULTI_APK_SEPARATE_RESOURCES(DexPackagingPolicy.INSTANT_RUN_MULTI_APK, true);

    private final DexPackagingPolicy dexPatchingPolicy;
    private final boolean useMultiDex;

    private InstantRunPatchingPolicy(DexPackagingPolicy dexPatchingPolicy, boolean useMultiDex) {
        this.dexPatchingPolicy = dexPatchingPolicy;
        this.useMultiDex = useMultiDex;
    }

    public boolean useMultiDex() {
        return this.useMultiDex;
    }

    public static boolean useMultiApk(InstantRunPatchingPolicy subject) {
        return subject != null && subject.useMultiApk();
    }

    public boolean useMultiApk() {
        return this == MULTI_APK_SEPARATE_RESOURCES || this == MULTI_APK;
    }

    public DexPackagingPolicy getDexPatchingPolicy() {
        return this.dexPatchingPolicy;
    }

    public static InstantRunPatchingPolicy getPatchingPolicy(AndroidVersion androidVersion, boolean useAapt2OrAbove, boolean createSeparateApkForResources) {
        if (androidVersion.getFeatureLevel() < AndroidVersion.ART_RUNTIME.getFeatureLevel()) {
            return PRE_LOLLIPOP;
        }
        return androidVersion.getFeatureLevel() >= 26 && useAapt2OrAbove && createSeparateApkForResources ? MULTI_APK_SEPARATE_RESOURCES : MULTI_APK;
    }
}

