/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.api.transform.Transform;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.dsl.Splits;
import com.android.resources.Density;
import com.android.sdklib.AndroidVersion;
import com.android.tools.build.gradle.internal.profile.GradleTaskExecutionType;
import com.android.tools.build.gradle.internal.profile.GradleTransformExecutionType;
import com.google.common.base.CaseFormat;
import com.google.wireless.android.sdk.stats.ApiVersion;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.google.wireless.android.sdk.stats.GradleBuildSplits;
import java.util.Locale;

public class AnalyticsUtil {
    public static GradleTransformExecutionType getTransformType(Class<? extends Transform> taskClass) {
        try {
            return GradleTransformExecutionType.valueOf((String)AnalyticsUtil.getPotentialTransformTypeName(taskClass));
        }
        catch (IllegalArgumentException ignored) {
            return GradleTransformExecutionType.UNKNOWN_TRANSFORM_TYPE;
        }
    }

    static String getPotentialTransformTypeName(Class<?> taskClass) {
        String taskImpl = taskClass.getSimpleName();
        if (taskImpl.endsWith("Transform")) {
            taskImpl = taskImpl.substring(0, taskImpl.length() - "Transform".length());
        }
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, taskImpl);
    }

    public static GradleTaskExecutionType getTaskExecutionType(Class<?> taskClass) {
        try {
            return GradleTaskExecutionType.valueOf((String)AnalyticsUtil.getPotentialTaskExecutionTypeName(taskClass));
        }
        catch (IllegalArgumentException ignored) {
            return GradleTaskExecutionType.UNKNOWN_TASK_TYPE;
        }
    }

    static String getPotentialTaskExecutionTypeName(Class<?> taskClass) {
        String taskImpl = taskClass.getSimpleName();
        if (taskImpl.endsWith("_Decorated")) {
            taskImpl = taskImpl.substring(0, taskImpl.length() - "_Decorated".length());
        }
        if (taskImpl.endsWith("Task")) {
            taskImpl = taskImpl.substring(0, taskImpl.length() - "Task".length());
        }
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, taskImpl);
    }

    public static ApiVersion toProto(AndroidVersion apiVersion) {
        ApiVersion.Builder builder = ApiVersion.newBuilder().setApiLevel((long)apiVersion.getApiLevel());
        if (apiVersion.getCodename() != null) {
            builder.setCodename(apiVersion.getCodename());
        }
        return builder.build();
    }

    public static ApiVersion toProto(com.android.builder.model.ApiVersion apiVersion) {
        ApiVersion.Builder builder = ApiVersion.newBuilder().setApiLevel((long)apiVersion.getApiLevel());
        if (apiVersion.getCodename() != null) {
            builder.setCodename(apiVersion.getCodename());
        }
        return builder.build();
    }

    public static GradleBuildSplits toProto(Splits splits) {
        GradleBuildSplits.Builder builder = GradleBuildSplits.newBuilder();
        if (splits.getDensity().isEnable()) {
            builder.setDensityEnabled(true);
            builder.setDensityAuto(splits.getDensity().isAuto());
            for (String compatibleScreen : splits.getDensity().getCompatibleScreens()) {
                builder.addDensityCompatibleScreens(AnalyticsUtil.getCompatibleScreen(compatibleScreen));
            }
            for (String filter : splits.getDensity().getApplicableFilters()) {
                Density density = Density.getEnum((String)filter);
                builder.addDensityValues(density == null ? -1 : density.getDpiValue());
            }
        }
        if (splits.getLanguage().isEnable()) {
            builder.setLanguageEnabled(true);
            builder.setLanguageAuto(splits.getLanguage().isAuto());
            builder.addAllLanguageIncludes(splits.getLanguage().getInclude());
        }
        if (splits.getAbi().isEnable()) {
            builder.setAbiEnabled(true);
            builder.setAbiEnableUniversalApk(splits.getAbi().isUniversalApk());
            for (String filter : splits.getAbi().getApplicableFilters()) {
                builder.addAbiFilters(AnalyticsUtil.getAbi(filter));
            }
        }
        return builder.build();
    }

    private static DeviceInfo.ApplicationBinaryInterface getAbi(String name) {
        Abi abi = Abi.getByName(name);
        if (abi == null) {
            return DeviceInfo.ApplicationBinaryInterface.UNKNOWN_ABI;
        }
        switch (abi) {
            case ARMEABI: {
                return DeviceInfo.ApplicationBinaryInterface.ARME_ABI;
            }
            case ARMEABI_V7A: {
                return DeviceInfo.ApplicationBinaryInterface.ARME_ABI_V7A;
            }
            case ARM64_V8A: {
                return DeviceInfo.ApplicationBinaryInterface.ARM64_V8A_ABI;
            }
            case X86: {
                return DeviceInfo.ApplicationBinaryInterface.X86_ABI;
            }
            case X86_64: {
                return DeviceInfo.ApplicationBinaryInterface.X86_64_ABI;
            }
            case MIPS: {
                return DeviceInfo.ApplicationBinaryInterface.MIPS_ABI;
            }
            case MIPS64: {
                return DeviceInfo.ApplicationBinaryInterface.MIPS_R2_ABI;
            }
        }
        return DeviceInfo.ApplicationBinaryInterface.UNKNOWN_ABI;
    }

    private static GradleBuildSplits.CompatibleScreenSize getCompatibleScreen(String compatibleScreen) {
        switch (compatibleScreen.toLowerCase(Locale.US)) {
            case "small": {
                return GradleBuildSplits.CompatibleScreenSize.SMALL;
            }
            case "normal": {
                return GradleBuildSplits.CompatibleScreenSize.NORMAL;
            }
            case "large": {
                return GradleBuildSplits.CompatibleScreenSize.LARGE;
            }
            case "xlarge": {
                return GradleBuildSplits.CompatibleScreenSize.XLARGE;
            }
        }
        return GradleBuildSplits.CompatibleScreenSize.UNKNOWN_SCREEN_SIZE;
    }
}

