/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class TaskInputHelper {
    private static AtomicBoolean bypassSupplier = new AtomicBoolean(true);

    public static void disableBypass() {
        bypassSupplier.set(false);
    }

    public static void enableBypass() {
        bypassSupplier.set(true);
    }

    public static Supplier<Collection<File>> bypassFileSupplier(Supplier<Collection<File>> supplier) {
        return new BypassFileSupplier(supplier);
    }

    public static Callable<Collection<File>> bypassFileCallable(Supplier<Collection<File>> supplier) {
        return new BypassFileCallable(supplier);
    }

    public static <T> Supplier<T> memoize(Supplier<T> supplier) {
        return new MemoizedSupplier(supplier);
    }

    private static class BypassFileCallable
    extends BypassFileSupplier
    implements Callable<Collection<File>> {
        private BypassFileCallable(Supplier<Collection<File>> supplier) {
            super(supplier);
        }

        @Override
        public Collection<File> call() throws Exception {
            return this.get();
        }
    }

    private static class MemoizedSupplier<T>
    implements Supplier<T> {
        private final Supplier<T> supplier;
        private T lastValue;

        @Override
        public T get() {
            if (this.lastValue == null) {
                this.lastValue = this.supplier.get();
            }
            return this.lastValue;
        }

        private MemoizedSupplier(Supplier<T> supplier) {
            this.supplier = supplier;
        }
    }

    private static class BypassFileSupplier
    extends MemoizedSupplier<Collection<File>> {
        @Override
        public Collection<File> get() {
            if (bypassSupplier.get()) {
                return ImmutableList.of();
            }
            return (Collection)super.get();
        }

        private BypassFileSupplier(Supplier<Collection<File>> supplier) {
            super(supplier);
        }
    }
}

