/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.google.common.collect.ImmutableList;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerConfiguration;

public class DesugarWorkerItem {
    private static final String DESUGAR_MAIN = "com.google.devtools.build.android.desugar.Desugar";
    private static final Logger LOGGER = Logging.getLogger(DesugarWorkerItem.class);
    private final Path java8LangSupportJar;
    private final Path tmpFolder;
    private final boolean verbose;
    private final Path input;
    private final Path output;
    private final List<Path> classpath;
    private final List<Path> bootClasspath;
    private final int minSdkVersion;

    public DesugarWorkerItem(Path java8LangSupportJar, Path tmpFolder, boolean verbose, Path input, Path output, List<Path> classpath, List<Path> bootClasspath, int minSdkVersion) {
        this.java8LangSupportJar = java8LangSupportJar;
        this.tmpFolder = tmpFolder;
        this.verbose = verbose;
        this.input = input;
        this.output = output;
        this.classpath = classpath;
        this.bootClasspath = bootClasspath;
        this.minSdkVersion = minSdkVersion;
    }

    public void configure(WorkerConfiguration workerConfiguration) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("desugar configuring in {}", (Object)ManagementFactory.getRuntimeMXBean().getName());
        }
        workerConfiguration.setIsolationMode(IsolationMode.PROCESS);
        workerConfiguration.classpath((Iterable)ImmutableList.of((Object)this.java8LangSupportJar.toFile()));
        workerConfiguration.forkOptions(javaForkOptions -> javaForkOptions.setJvmArgs((List)ImmutableList.of((Object)"-Xmx64m", (Object)("-Djdk.internal.lambda.dumpProxyClasses=" + this.tmpFolder.toString()))));
        workerConfiguration.setParams(new Object[]{this.input.toString(), this.output.toString(), this.classpath.stream().map(Path::toString).collect(Collectors.toList()), this.bootClasspath.stream().map(Path::toString).collect(Collectors.toList()), this.minSdkVersion, this.verbose});
    }

    public static class DesugarAction
    implements Runnable {
        private final boolean verbose;
        private final String input;
        private final String output;
        private final List<String> classpath;
        private final List<String> bootClasspath;
        private final int minSdkVersion;

        @Inject
        public DesugarAction(String input, String output, List<String> classpath, List<String> bootClassPath, Integer minSdkVersion, Boolean verbose) {
            this.input = input;
            this.output = output;
            this.classpath = classpath;
            this.bootClasspath = bootClassPath;
            this.minSdkVersion = minSdkVersion;
            this.verbose = verbose;
        }

        @Override
        public void run() {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("New desugar in {}", (Object)ManagementFactory.getRuntimeMXBean().getName());
                }
                Class<?> clazz = Class.forName(DesugarWorkerItem.DESUGAR_MAIN);
                Method mainMethod = clazz.getMethod("main", String[].class);
                mainMethod.setAccessible(true);
                ImmutableList.Builder builder = ImmutableList.builder();
                if (this.verbose) {
                    builder.add((Object)"--verbose");
                }
                builder.add((Object[])new String[]{"--input", this.input});
                builder.add((Object[])new String[]{"--output", this.output});
                for (String s : this.classpath) {
                    builder.add((Object[])new String[]{"--classpath_entry", s});
                }
                for (String s : this.bootClasspath) {
                    builder.add((Object[])new String[]{"--bootclasspath_entry", s});
                }
                builder.add((Object[])new String[]{"--min_sdk_version", Integer.toString(this.minSdkVersion)});
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("desugar parameters for {} are {}", (Object)ManagementFactory.getRuntimeMXBean().getName(), (Object)builder.build());
                }
                ImmutableList parameters = builder.build();
                mainMethod.invoke(null, new Object[]{parameters.toArray((Object[])new String[parameters.size()])});
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error("Error while running desugar ", (Throwable)e);
            }
        }
    }
}

