/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.transforms.JarMerger;
import com.android.builder.packaging.ZipEntryFilter;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Set;

public class JarMergingTransform
extends Transform {
    private final ImmutableSet<QualifiedContent.Scope> scopes;

    public JarMergingTransform(Set<QualifiedContent.Scope> scopes) {
        this.scopes = ImmutableSet.copyOf(scopes);
    }

    public String getName() {
        return "jarMerging";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return this.scopes;
    }

    public boolean isIncremental() {
        return false;
    }

    public void transform(TransformInvocation invocation) throws TransformException, IOException {
        TransformOutputProvider outputProvider = invocation.getOutputProvider();
        Preconditions.checkNotNull((Object)outputProvider, (Object)("Missing output object for transform " + this.getName()));
        File jarFile = outputProvider.getContentLocation("combined_classes", this.getOutputTypes(), this.getScopes(), Format.JAR);
        FileUtils.mkdirs((File)jarFile.getParentFile());
        FileUtils.deleteIfExists((File)jarFile);
        try (JarMerger jarMerger = new JarMerger(jarFile);){
            jarMerger.setFilter(new ZipEntryFilter(){

                public boolean checkEntry(String archivePath) {
                    return archivePath.endsWith(".class");
                }
            });
            for (TransformInput input : invocation.getInputs()) {
                for (JarInput jarInput : input.getJarInputs()) {
                    jarMerger.addJar(jarInput.getFile());
                }
                for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                    jarMerger.addFolder(directoryInput.getFile());
                }
            }
        }
    }
}

