/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantModel;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.api.LibraryVariantImpl;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantFactory;
import com.android.build.gradle.internal.variant.LibraryVariantData;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.ErrorReporter;
import com.android.builder.core.VariantType;
import com.android.builder.profile.Recorder;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.internal.reflect.Instantiator;

public class LibraryVariantFactory
extends BaseVariantFactory {
    public LibraryVariantFactory(GlobalScope globalScope, AndroidBuilder androidBuilder, Instantiator instantiator, AndroidConfig extension) {
        super(globalScope, androidBuilder, instantiator, extension);
    }

    @Override
    public BaseVariantData createVariantData(GradleVariantConfiguration variantConfiguration, TaskManager taskManager, Recorder recorder) {
        return new LibraryVariantData(this.globalScope, this.extension, taskManager, variantConfiguration, this.androidBuilder.getErrorReporter(), recorder);
    }

    @Override
    public Class<? extends BaseVariantImpl> getVariantImplementationClass(BaseVariantData variantData) {
        return LibraryVariantImpl.class;
    }

    @Override
    public Collection<VariantType> getVariantConfigurationTypes() {
        return ImmutableList.of((Object)VariantType.LIBRARY);
    }

    @Override
    public boolean hasTestScope() {
        return true;
    }

    @Override
    public void validateModel(VariantModel model) {
        String applicationIdSuffix;
        ErrorReporter errorReporter = this.androidBuilder.getErrorReporter();
        if (model.getDefaultConfig().getProductFlavor().getApplicationId() != null) {
            String applicationId = model.getDefaultConfig().getProductFlavor().getApplicationId();
            errorReporter.handleSyncError(applicationId, 0, "Library projects cannot set applicationId. applicationId is set to '" + applicationId + "' in default config.");
        }
        if (model.getDefaultConfig().getProductFlavor().getApplicationIdSuffix() != null) {
            String applicationIdSuffix2 = model.getDefaultConfig().getProductFlavor().getApplicationIdSuffix();
            errorReporter.handleSyncError(applicationIdSuffix2, 0, "Library projects cannot set applicationIdSuffix. applicationIdSuffix is set to '" + applicationIdSuffix2 + "' in default config.");
        }
        for (BuildTypeData buildTypeData : model.getBuildTypes().values()) {
            if (buildTypeData.getBuildType().getApplicationIdSuffix() == null) continue;
            applicationIdSuffix = buildTypeData.getBuildType().getApplicationIdSuffix();
            errorReporter.handleSyncError(applicationIdSuffix, 0, "Library projects cannot set applicationIdSuffix. applicationIdSuffix is set to '" + applicationIdSuffix + "' in build type '" + buildTypeData.getBuildType().getName() + "'.");
        }
        for (ProductFlavorData productFlavorData : model.getProductFlavors().values()) {
            if (productFlavorData.getProductFlavor().getApplicationId() != null) {
                String applicationId = productFlavorData.getProductFlavor().getApplicationId();
                errorReporter.handleSyncError(applicationId, 0, "Library projects cannot set applicationId. applicationId is set to '" + applicationId + "' in flavor '" + productFlavorData.getProductFlavor().getName() + "'.");
            }
            if (productFlavorData.getProductFlavor().getApplicationIdSuffix() == null) continue;
            applicationIdSuffix = productFlavorData.getProductFlavor().getApplicationIdSuffix();
            errorReporter.handleSyncError(applicationIdSuffix, 0, "Library projects cannot set applicationIdSuffix. applicationIdSuffix is set to '" + applicationIdSuffix + "' in flavor '" + productFlavorData.getProductFlavor().getName() + "'.");
        }
    }

    @Override
    public void createDefaultComponents(NamedDomainObjectContainer<BuildType> buildTypes, NamedDomainObjectContainer<ProductFlavor> productFlavors, NamedDomainObjectContainer<SigningConfig> signingConfigs) {
        signingConfigs.create("debug");
        buildTypes.create("debug");
        buildTypes.create("release");
    }
}

