/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.builder.core.ErrorReporter;
import com.android.builder.core.VariantType;
import com.android.builder.profile.Recorder;
import com.google.common.collect.Lists;
import java.util.List;

public class TestVariantData
extends ApkVariantData {
    public DeviceProviderInstrumentTestTask connectedTestTask;
    public final List<DeviceProviderInstrumentTestTask> providerTestTaskList = Lists.newArrayList();
    private final TestedVariantData testedVariantData;

    public TestVariantData(GlobalScope globalScope, AndroidConfig androidConfig, TaskManager taskManager, GradleVariantConfiguration config, TestedVariantData testedVariantData, ErrorReporter errorReporter, Recorder recorder) {
        super(globalScope, androidConfig, taskManager, config, errorReporter, recorder);
        this.testedVariantData = testedVariantData;
        this.getOutputFactory().addMainApk();
    }

    public TestedVariantData getTestedVariantData() {
        return this.testedVariantData;
    }

    @Override
    public String getDescription() {
        String prefix;
        switch (this.getType()) {
            case ANDROID_TEST: {
                prefix = "android (on device) tests";
                break;
            }
            case UNIT_TEST: {
                prefix = "unit tests";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown test variant type.");
            }
        }
        if (this.getVariantConfiguration().hasFlavors()) {
            return String.format("%s for the %s%s build", prefix, this.getCapitalizedFlavorName(), this.getCapitalizedBuildTypeName());
        }
        return String.format("%s for the %s build", prefix, this.getCapitalizedBuildTypeName());
    }

    @Override
    public String getTaskName(String prefix, String suffix) {
        if (this.testedVariantData.getVariantConfiguration().getType() == VariantType.FEATURE) {
            return super.getTaskName(prefix, "Feature" + suffix);
        }
        return super.getTaskName(prefix, suffix);
    }
}

