/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.shrinker;

import com.android.build.gradle.shrinker.ClassLookupException;
import com.android.build.gradle.shrinker.ShrinkerGraph;
import com.android.build.gradle.shrinker.ShrinkerLogger;
import com.google.common.collect.Lists;
import com.google.common.collect.TreeTraverser;
import java.util.ArrayList;
import java.util.Collections;

public class TypeHierarchyTraverser<T>
extends TreeTraverser<T> {
    private final ShrinkerGraph<T> mGraph;
    private final ShrinkerLogger mShrinkerLogger;
    private final boolean mIncludeInterfaces;
    private final boolean mIncludeSuperclasses;

    private TypeHierarchyTraverser(ShrinkerGraph<T> graph, ShrinkerLogger shrinkerLogger, boolean includeSuperclasses, boolean includeInterfaces) {
        this.mGraph = graph;
        this.mShrinkerLogger = shrinkerLogger;
        this.mIncludeSuperclasses = includeSuperclasses;
        this.mIncludeInterfaces = includeInterfaces;
    }

    public static <T> TypeHierarchyTraverser<T> superclassesAndInterfaces(ShrinkerGraph<T> graph, ShrinkerLogger shrinkerLogger) {
        return new TypeHierarchyTraverser<T>(graph, shrinkerLogger, true, true);
    }

    public static <T> TypeHierarchyTraverser<T> superclasses(ShrinkerGraph<T> graph, ShrinkerLogger shrinkerLogger) {
        return new TypeHierarchyTraverser<T>(graph, shrinkerLogger, true, false);
    }

    public static <T> TypeHierarchyTraverser<T> interfaces(ShrinkerGraph<T> graph, ShrinkerLogger shrinkerLogger) {
        return new TypeHierarchyTraverser<T>(graph, shrinkerLogger, false, true);
    }

    public Iterable<T> children(T klass) {
        ArrayList result = Lists.newArrayList();
        if (this.mIncludeSuperclasses) {
            try {
                T superclass = this.mGraph.getSuperclass(klass);
                if (superclass != null) {
                    if (!this.mGraph.isClassKnown(superclass)) {
                        throw new ClassLookupException(this.mGraph.getClassName(superclass));
                    }
                    result.add(superclass);
                }
            }
            catch (ClassLookupException e) {
                this.mShrinkerLogger.invalidClassReference(this.mGraph.getClassName(klass), e.getClassName());
                return Collections.emptyList();
            }
        }
        if (this.mIncludeInterfaces) {
            try {
                T[] interfaces;
                for (T iface : interfaces = this.mGraph.getInterfaces(klass)) {
                    if (!this.mGraph.isClassKnown(iface)) {
                        this.mShrinkerLogger.invalidClassReference(this.mGraph.getClassName(klass), this.mGraph.getClassName(iface));
                        continue;
                    }
                    result.add(iface);
                }
            }
            catch (ClassLookupException e) {
                this.mShrinkerLogger.invalidClassReference(this.mGraph.getClassName(klass), e.getClassName());
            }
        }
        return result;
    }
}

