/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.builder.compiling.ResValueGenerator;
import com.android.builder.model.ClassField;
import com.android.utils.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class GenerateResValues
extends BaseTask {
    private File resOutputDir;
    private Supplier<List<Object>> items;

    @OutputDirectory
    public File getResOutputDir() {
        return this.resOutputDir;
    }

    public void setResOutputDir(File resOutputDir) {
        this.resOutputDir = resOutputDir;
    }

    @Internal
    public List<Object> getItems() {
        return this.items.get();
    }

    public void setItems(List<Object> items) {
        this.items = () -> items;
    }

    @Input
    public List<String> getItemValues() {
        List<Object> resolvedItems = this.getItems();
        ArrayList list = Lists.newArrayListWithCapacity((int)(resolvedItems.size() * 3));
        for (Object object : resolvedItems) {
            if (object instanceof String) {
                list.add((String)object);
                continue;
            }
            if (!(object instanceof ClassField)) continue;
            ClassField field = (ClassField)object;
            list.add(field.getType());
            list.add(field.getName());
            list.add(field.getValue());
        }
        return list;
    }

    @TaskAction
    void generate() throws IOException, ParserConfigurationException {
        File folder = this.getResOutputDir();
        List<Object> resolvedItems = this.getItems();
        if (resolvedItems.isEmpty()) {
            FileUtils.cleanOutputDir((File)folder);
        } else {
            ResValueGenerator generator = new ResValueGenerator(folder);
            generator.addItems(this.getItems());
            generator.generate();
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<GenerateResValues> {
        private final VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("generate", "ResValues");
        }

        @Override
        public Class<GenerateResValues> getType() {
            return GenerateResValues.class;
        }

        @Override
        public void execute(GenerateResValues generateResValuesTask) {
            this.scope.getVariantData().generateResValuesTask = generateResValuesTask;
            GradleVariantConfiguration variantConfiguration = this.scope.getVariantData().getVariantConfiguration();
            generateResValuesTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            generateResValuesTask.setVariantName(variantConfiguration.getFullName());
            generateResValuesTask.items = TaskInputHelper.memoize(() -> ((GradleVariantConfiguration)variantConfiguration).getResValues());
            generateResValuesTask.setResOutputDir(this.scope.getGeneratedResOutputDir());
        }
    }
}

