/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.incremental.FileType;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.packaging.ApkCreatorFactories;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.PackagingScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.PackagerException;
import com.android.ide.common.build.ApkData;
import com.android.ide.common.signing.KeytoolException;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class InstantRunResourcesApkBuilder
extends BaseTask {
    private static final String APK_FILE_NAME = "resources";
    private AndroidBuilder androidBuilder;
    private InstantRunBuildContext instantRunBuildContext;
    private File outputDirectory;
    private CoreSigningConfig signingConf;
    private File supportDirectory;
    private FileCollection resources;
    private OutputScope outputScope;
    private TaskOutputHolder.TaskOutputType resInputType;

    @Nested
    @Optional
    CoreSigningConfig getSigningConf() {
        return this.signingConf;
    }

    @Input
    String getResInputType() {
        return this.resInputType.name();
    }

    @InputFiles
    public FileCollection getResourcesFile() {
        return this.resources;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @TaskAction
    protected void doFullTaskAction() throws IOException {
        Collection<BuildOutput> buildOutputs = BuildOutputs.load((TaskOutputHolder.OutputType)this.resInputType, this.resources);
        this.outputScope.parallelForEachOutput(buildOutputs, this.resInputType, TaskOutputHolder.TaskOutputType.INSTANT_RUN_PACKAGED_RESOURCES, (apkData, input) -> {
            try {
                if (input == null) {
                    return null;
                }
                File outputFile = new File(this.outputDirectory, InstantRunResourcesApkBuilder.mangleApkName(apkData) + ".apk");
                Files.createParentDirs((File)outputFile);
                File tempDir = new File(this.supportDirectory, "package_" + InstantRunResourcesApkBuilder.mangleApkName(apkData));
                FileUtils.cleanOutputDir((File)tempDir);
                this.androidBuilder.packageCodeSplitApk(input, (Set)ImmutableSet.of(), (SigningConfig)this.signingConf, outputFile, tempDir, ApkCreatorFactories.fromProjectProperties(this.getProject(), true));
                this.instantRunBuildContext.addChangedFile(FileType.RESOURCES, outputFile);
                return outputFile;
            }
            catch (PackagerException | KeytoolException e) {
                throw new IOException("Exception while creating resources split APK", e);
            }
        });
    }

    static String mangleApkName(ApkData apkData) {
        return "resources-" + apkData.getBaseName();
    }

    public static class ConfigAction
    implements TaskConfigAction<InstantRunResourcesApkBuilder> {
        protected final PackagingScope packagingScope;
        private final FileCollection resources;
        private final TaskOutputHolder.TaskOutputType resInputType;

        public ConfigAction(TaskOutputHolder.TaskOutputType resInputType, FileCollection resources, PackagingScope scope) {
            this.resInputType = resInputType;
            this.resources = resources;
            this.packagingScope = scope;
        }

        @Override
        public String getName() {
            return this.packagingScope.getTaskName("processInstantRun", "ResourcesApk");
        }

        @Override
        public Class<InstantRunResourcesApkBuilder> getType() {
            return InstantRunResourcesApkBuilder.class;
        }

        @Override
        public void execute(InstantRunResourcesApkBuilder resourcesApkBuilder) {
            resourcesApkBuilder.setVariantName(this.packagingScope.getFullVariantName());
            resourcesApkBuilder.resInputType = this.resInputType;
            resourcesApkBuilder.outputScope = this.packagingScope.getOutputScope();
            resourcesApkBuilder.supportDirectory = this.packagingScope.getIncrementalDir("instant-run-resources");
            resourcesApkBuilder.androidBuilder = this.packagingScope.getAndroidBuilder();
            resourcesApkBuilder.signingConf = this.packagingScope.getSigningConfig();
            resourcesApkBuilder.instantRunBuildContext = this.packagingScope.getInstantRunBuildContext();
            resourcesApkBuilder.resources = this.resources;
            resourcesApkBuilder.outputDirectory = this.packagingScope.getInstantRunResourceApkFolder();
        }
    }
}

