/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.VariantOutput;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.aapt.AaptGradleFactory;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.DslAdaptersKt;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.OutputFactory;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.SplitList;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitPackageIds;
import com.android.build.gradle.internal.transforms.InstantRunSliceSplitApkBuilder;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.build.gradle.internal.variant.TaskContainer;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.internal.aapt.Aapt;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.symbols.IdProvider;
import com.android.builder.symbols.ResourceDirectoryParser;
import com.android.builder.symbols.SymbolIo;
import com.android.builder.symbols.SymbolTable;
import com.android.builder.symbols.SymbolUtils;
import com.android.builder.utils.FileCache;
import com.android.ide.common.blame.MergingLog;
import com.android.ide.common.blame.MergingLogRewriter;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.blame.parser.aapt.Aapt2OutputParser;
import com.android.ide.common.blame.parser.aapt.AaptOutputParser;
import com.android.ide.common.build.ApkData;
import com.android.ide.common.build.ApkInfo;
import com.android.ide.common.build.SplitOutputMatcher;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.resources.Density;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.tooling.BuildException;

@CacheableTask
public class ProcessAndroidResources
extends IncrementalTask {
    private static final String IR_APK_FILE_NAME = "resources";
    private static final Logger LOG = Logging.getLogger(ProcessAndroidResources.class);
    private String buildTargetAbi;
    private Set<String> supportedAbis;
    private File sourceOutputDir;
    private Supplier<File> textSymbolOutputDir = () -> null;
    private File symbolsWithPackageNameOutputFile;
    private File proguardOutputFile;
    private File mainDexListProguardOutputFile;
    private FileCollection symbolListsWithPackageNames;
    private ArtifactCollection packageIdsFiles;
    private Supplier<String> packageForR;
    private MultiOutputPolicy multiOutputPolicy;
    private VariantType type;
    private AaptGeneration aaptGeneration;
    private boolean debuggable;
    private boolean pseudoLocalesEnabled;
    private AaptOptions aaptOptions;
    private File mergeBlameLogFolder;
    private InstantRunBuildContext buildContext;
    private FileCollection featureResourcePackages;
    private String originalApplicationId;
    private String buildTargetDensity;
    private File resPackageOutputFolder;
    private String projectBaseName;
    private TaskOutputHolder.TaskOutputType taskInputType;
    private FileCache fileCache;
    private VariantScope variantScope;
    FileCollection splitListInput;
    private OutputScope outputScope;
    private OutputFactory outputFactory;
    private boolean bypassAapt;
    private boolean disableResMergeInLib;
    private FileCollection platformAttrRTxt;
    private boolean enableAapt2;
    private String applicationId;
    private String versionName;
    private int versionCode;
    private File supportDirectory;
    FileCollection manifestFiles;
    private FileCollection inputResourcesDir;
    boolean isLibrary;

    @Input
    public TaskOutputHolder.TaskOutputType getTaskInputType() {
        return this.taskInputType;
    }

    @Input
    public String getProjectBaseName() {
        return this.projectBaseName;
    }

    @Input
    @Optional
    public String getBuildTargetAbi() {
        return this.buildTargetAbi;
    }

    @Input
    @Optional
    Set<String> getSupportedAbis() {
        return this.supportedAbis;
    }

    @Internal
    private Set<String> getSplits(SplitList splitList) throws IOException {
        return SplitList.getSplits(splitList, this.multiOutputPolicy);
    }

    @Input
    public String getApplicationId() {
        return this.applicationId;
    }

    @Input
    @Optional
    public String getVersionName() {
        return this.versionName;
    }

    @Input
    public int getVersionCode() {
        return this.versionCode;
    }

    @Override
    protected void doFullTaskAction() throws IOException, ExecutionException {
        WaitableExecutor executor = WaitableExecutor.useGlobalSharedThreadPool();
        List<ApkData> splitsToGenerate = ProcessAndroidResources.getApksToGenerate(this.outputScope, this.supportedAbis, this.buildTargetAbi, this.buildTargetDensity);
        for (ApkData apkData : this.outputScope.getApkDatas()) {
            if (splitsToGenerate.contains(apkData)) continue;
            this.getLogger().log(LogLevel.DEBUG, "With ABI " + this.buildTargetAbi + ", disabled " + apkData);
            apkData.disable();
        }
        Collection<BuildOutput> manifestsOutputs = BuildOutputs.load((TaskOutputHolder.OutputType)this.taskInputType, this.manifestFiles);
        Set packageIdFileSet = this.packageIdsFiles != null ? this.packageIdsFiles.getArtifactFiles().getAsFileTree().getFiles() : null;
        Set featureResourcePackages = this.featureResourcePackages.getFiles();
        SplitList splitList = this.isLibrary ? SplitList.EMPTY : SplitList.load(this.splitListInput);
        Set libraryInfoList = this.symbolListsWithPackageNames.getFiles();
        ArrayList<ApkData> apkDataList = new ArrayList<ApkData>(splitsToGenerate);
        for (ApkData apkData : splitsToGenerate) {
            boolean codeGen;
            if (!apkData.requiresAapt() || !(codeGen = apkData.getType() == VariantOutput.OutputType.MAIN || apkData.getFilter(VariantOutput.FilterType.DENSITY) == null)) continue;
            apkDataList.remove(apkData);
            this.invokeAaptForSplit(manifestsOutputs, libraryInfoList, packageIdFileSet, splitList, featureResourcePackages, apkData, codeGen);
            break;
        }
        for (ApkData apkData : apkDataList) {
            if (!apkData.requiresAapt()) continue;
            executor.execute(() -> {
                this.invokeAaptForSplit(manifestsOutputs, libraryInfoList, packageIdFileSet, splitList, featureResourcePackages, apkData, false);
                return null;
            });
        }
        try {
            List taskResults = executor.waitForAllTasks();
            taskResults.forEach(taskResult -> {
                if (taskResult.getException() != null) {
                    throw new BuildException(taskResult.getException().getMessage(), taskResult.getException());
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        if (this.multiOutputPolicy == MultiOutputPolicy.SPLITS) {
            this.outputScope.deleteAllEntries(TaskOutputHolder.TaskOutputType.DENSITY_OR_LANGUAGE_SPLIT_PROCESSED_RES);
            splitList.forEach((filterType, filterValues) -> {
                if (filterType != VariantOutput.FilterType.DENSITY && filterType != VariantOutput.FilterType.LANGUAGE) {
                    return;
                }
                filterValues.forEach(filterValue -> {
                    ApkData configurationApkData = this.outputFactory.addConfigurationSplit(filterType, (String)filterValue, "");
                    configurationApkData.setVersionCode(this.variantScope.getVariantConfiguration().getVersionCode());
                    configurationApkData.setVersionName(this.variantScope.getVariantConfiguration().getVersionName());
                    this.variantScope.getVariantData().variantOutputFactory.create(configurationApkData);
                    File packagedResForSplit = ProcessAndroidResources.findPackagedResForSplit(this.resPackageOutputFolder, configurationApkData);
                    if (packagedResForSplit != null) {
                        configurationApkData.setOutputFileName(packagedResForSplit.getName());
                        this.outputScope.addOutputForSplit(TaskOutputHolder.TaskOutputType.DENSITY_OR_LANGUAGE_SPLIT_PROCESSED_RES, configurationApkData, packagedResForSplit);
                    } else {
                        this.getLogger().warn("Cannot find output for " + configurationApkData);
                    }
                });
            });
        }
        this.outputScope.save((ImmutableList<TaskOutputHolder.OutputType>)ImmutableList.of((Object)TaskOutputHolder.TaskOutputType.DENSITY_OR_LANGUAGE_SPLIT_PROCESSED_RES, (Object)TaskOutputHolder.TaskOutputType.PROCESSED_RES), this.resPackageOutputFolder);
    }

    void invokeAaptForSplit(Collection<BuildOutput> manifestsOutputs, Set<File> dependencySymbolTableFiles, Set<File> packageIdFileSet, SplitList splitList, Set<File> featureResourcePackages, ApkData apkData, boolean generateCode) throws IOException {
        String splitFilter;
        AndroidBuilder builder = this.getBuilder();
        MergingLog mergingLog = new MergingLog(this.getMergeBlameLogFolder());
        MergingLogRewriter mergingLogRewriter = new MergingLogRewriter(arg_0 -> ((MergingLog)mergingLog).find(arg_0), (MessageReceiver)builder.getErrorReporter());
        ParsingProcessOutputHandler processOutputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)(this.aaptGeneration == AaptGeneration.AAPT_V1 ? new AaptOutputParser() : new Aapt2OutputParser()), this.getILogger()), new MessageReceiver[]{mergingLogRewriter});
        ImmutableList.Builder featurePackagesBuilder = ImmutableList.builder();
        for (File featurePackage : featureResourcePackages) {
            Collection<BuildOutput> splitOutputs = BuildOutputs.load((TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.PROCESSED_RES, featurePackage);
            if (splitOutputs.isEmpty()) continue;
            featurePackagesBuilder.add((Object)((BuildOutput)Iterables.getOnlyElement(splitOutputs)).getOutputFile());
        }
        File resOutBaseNameFile = new File(this.resPackageOutputFolder, "resources-" + apkData.getFullName() + ".ap_");
        BuildOutput manifestOutput = OutputScope.getOutput(manifestsOutputs, (TaskOutputHolder.OutputType)this.taskInputType, (ApkInfo)apkData);
        if (manifestOutput == null) {
            throw new RuntimeException("Cannot find merged manifest file");
        }
        File manifestFile = manifestOutput.getOutputFile();
        String packageForR = null;
        File srcOut = null;
        File symbolOutputDir = null;
        File proguardOutputFile = null;
        File mainDexListProguardOutputFile = null;
        if (generateCode) {
            packageForR = this.originalApplicationId;
            srcOut = this.getSourceOutputDir();
            if (srcOut != null) {
                FileUtils.cleanOutputDir((File)srcOut);
            }
            symbolOutputDir = this.textSymbolOutputDir.get();
            proguardOutputFile = this.getProguardOutputFile();
            mainDexListProguardOutputFile = this.getMainDexListProguardOutputFile();
        }
        String preferredDensity = (splitFilter = apkData.getFilter(VariantOutput.FilterType.DENSITY)) != null ? splitFilter : (splitList.getFilters("ResConfigs").isEmpty() ? this.buildTargetDensity : null);
        Integer packageId = null;
        if (packageIdFileSet != null && FeatureSplitPackageIds.getOutputFile(packageIdFileSet) != null) {
            FeatureSplitPackageIds featurePackageIds = FeatureSplitPackageIds.load(packageIdFileSet);
            packageId = featurePackageIds.getIdFor(this.getProject().getPath());
        }
        try {
            if (this.buildContext.isInInstantRunMode() && this.buildContext.getPatchingPolicy() == InstantRunPatchingPolicy.MULTI_APK_SEPARATE_RESOURCES) {
                this.supportDirectory.mkdirs();
                manifestFile = InstantRunSliceSplitApkBuilder.generateSplitApkManifest(this.supportDirectory, IR_APK_FILE_NAME, this.applicationId, this.versionName, this.versionCode);
            }
            if (this.bypassAapt) {
                File androidJar = this.platformAttrRTxt.getSingleFile();
                SymbolTable androidAttrSymbol = androidJar != null && androidJar.exists() ? SymbolIo.read((File)androidJar, (String)"android") : SymbolTable.builder().tablePackage("android").build();
                SymbolTable symbolTable = ResourceDirectoryParser.parseDirectory((File)this.getInputResourcesDir().getSingleFile(), (IdProvider)IdProvider.sequential(), (SymbolTable)androidAttrSymbol);
                SymbolUtils.processLibraryMainSymbolTable((SymbolTable)symbolTable, (Set)(generateCode ? dependencySymbolTableFiles : ImmutableSet.of()), (String)packageForR, (File)manifestFile, (File)((File)Preconditions.checkNotNull((Object)srcOut)), (File)((File)Preconditions.checkNotNull((Object)symbolOutputDir)), (File)proguardOutputFile, (File)this.getInputResourcesDir().getSingleFile(), (SymbolTable)androidAttrSymbol, (boolean)this.disableResMergeInLib);
            } else {
                Aapt aapt = AaptGradleFactory.make(this.aaptGeneration, builder, (ProcessOutputHandler)processOutputHandler, this.fileCache, true, FileUtils.mkdirs((File)new File(this.getIncrementalFolder(), "aapt-temp")), this.aaptOptions.getCruncherProcesses());
                AaptPackageConfig.Builder config = new AaptPackageConfig.Builder().setManifestFile(manifestFile).setOptions(DslAdaptersKt.convert(this.aaptOptions)).setResourceDir(this.getInputResourcesDir().getSingleFile()).setLibrarySymbolTableFiles((Set)(generateCode ? dependencySymbolTableFiles : ImmutableSet.of())).setCustomPackageForR(packageForR).setSymbolOutputDir(symbolOutputDir).setSourceOutputDir(srcOut).setResourceOutputApk(resOutBaseNameFile).setProguardOutputFile(proguardOutputFile).setMainDexListProguardOutputFile(mainDexListProguardOutputFile).setVariantType(this.getType()).setDebuggable(this.getDebuggable()).setPseudoLocalize(this.getPseudoLocalesEnabled()).setResourceConfigs(splitList.getFilters("ResConfigs")).setSplits(this.getSplits(splitList)).setPreferredDensity(preferredDensity).setPackageId(packageId).setDependentFeatures((Collection)featurePackagesBuilder.build()).setListResourceFiles(this.aaptGeneration == AaptGeneration.AAPT_V2);
                builder.processResources(aapt, config);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Aapt output file {}", (Object)resOutBaseNameFile.getAbsolutePath());
                }
            }
            if (generateCode && (this.isLibrary || !dependencySymbolTableFiles.isEmpty()) && this.symbolsWithPackageNameOutputFile != null) {
                SymbolIo.writeSymbolTableWithPackage((Path)((File)Preconditions.checkNotNull((Object)this.getTextSymbolOutputFile())).toPath(), (Path)manifestFile.toPath(), (Path)this.symbolsWithPackageNameOutputFile.toPath());
            }
            this.outputScope.addOutputForSplit(TaskOutputHolder.TaskOutputType.PROCESSED_RES, apkData, resOutBaseNameFile, manifestOutput.getProperties());
        }
        catch (ProcessException | InterruptedException e) {
            this.getLogger().error(e.getMessage(), e);
            throw new BuildException(e.getMessage(), e);
        }
    }

    private static File findPackagedResForSplit(File outputFolder, ApkData apkData) {
        Pattern resourcePattern = Pattern.compile("resources-" + apkData.getFullName() + ".ap__(.*)");
        if (outputFolder == null) {
            return null;
        }
        File[] files = outputFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                Matcher match = resourcePattern.matcher(file.getName());
                if (!match.matches() || match.group(1).isEmpty() || !ProcessAndroidResources.isValidSplit(apkData, match.group(1))) continue;
                return file;
            }
        }
        return null;
    }

    private static boolean isValidSplit(ApkData apkData, String splitWithOptionalSuffix) {
        String splitFilter = apkData.getFilter(VariantOutput.FilterType.DENSITY);
        if (splitFilter != null && splitWithOptionalSuffix.startsWith(splitFilter)) {
            return true;
        }
        String mangledName = ProcessAndroidResources.unMangleSplitName(splitWithOptionalSuffix);
        return mangledName.equals(splitFilter = apkData.getFilter(VariantOutput.FilterType.LANGUAGE));
    }

    public static String unMangleSplitName(String splitWithOptionalSuffix) {
        String mangledName = splitWithOptionalSuffix.replaceAll("_", ",");
        return mangledName.contains("-r") ? mangledName : mangledName.replace("-", "-r");
    }

    public static List<ApkData> getApksToGenerate(OutputScope outputScope, Set<String> supportedAbis, String buildTargetAbi, String buildTargetDensity) {
        List apksToGenerate;
        Density density = Density.getEnum((String)buildTargetDensity);
        List list = buildTargetAbi == null ? outputScope.getApkDatas() : (apksToGenerate = SplitOutputMatcher.computeBestOutput(outputScope.getApkDatas(), supportedAbis, (int)(density == null ? -1 : density.getDpiValue()), Arrays.asList(Strings.nullToEmpty((String)buildTargetAbi).split(","))));
        if (apksToGenerate.isEmpty()) {
            Preconditions.checkNotNull((Object)buildTargetAbi, (Object)"buildTargetAbi should not be null when no splits are computed");
            Preconditions.checkNotNull(supportedAbis, (Object)"supportedAbis should not be null when no splits are computed");
            List splits = outputScope.getApkDatas().stream().map(ApkData::getFilterName).collect(Collectors.toList());
            throw new RuntimeException(String.format("Cannot build for ABI: %1$s; no suitable splits configured: %2$s; supported ABIs are: %3$s", buildTargetAbi, splits.isEmpty() ? "none" : Joiner.on((String)", ").join(splits), supportedAbis.isEmpty() ? "none" : Joiner.on((String)", ").join(supportedAbis)));
        }
        return apksToGenerate;
    }

    public File getManifestFile() {
        File manifestDirectory = (File)Iterables.getFirst((Iterable)this.manifestFiles.getFiles(), null);
        Preconditions.checkNotNull((Object)manifestDirectory);
        Preconditions.checkNotNull((Object)this.outputScope.getMainSplit());
        return FileUtils.join((File)manifestDirectory, (String[])new String[]{this.outputScope.getMainSplit().getDirName(), "AndroidManifest.xml"});
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getManifestFiles() {
        return this.manifestFiles;
    }

    public void setManifestFiles(FileCollection manifestFiles) {
        this.manifestFiles = manifestFiles;
    }

    @Optional
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getPackageIdsFiles() {
        return this.packageIdsFiles != null ? this.packageIdsFiles.getArtifactFiles() : null;
    }

    @Input
    public boolean isInstantRunMode() {
        return this.buildContext.isInInstantRunMode();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getInputResourcesDir() {
        return this.inputResourcesDir;
    }

    @OutputDirectory
    @Optional
    public File getSourceOutputDir() {
        return this.sourceOutputDir;
    }

    public void setSourceOutputDir(File sourceOutputDir) {
        this.sourceOutputDir = sourceOutputDir;
    }

    @OutputFile
    @Optional
    public File getTextSymbolOutputFile() {
        return new File(this.textSymbolOutputDir.get(), "R.txt");
    }

    @OutputFile
    @Optional
    public File getSymbolslWithPackageNameOutputFile() {
        return this.symbolsWithPackageNameOutputFile;
    }

    @OutputFile
    @Optional
    public File getProguardOutputFile() {
        return this.proguardOutputFile;
    }

    public void setProguardOutputFile(File proguardOutputFile) {
        this.proguardOutputFile = proguardOutputFile;
    }

    @OutputFile
    @Optional
    public File getMainDexListProguardOutputFile() {
        return this.mainDexListProguardOutputFile;
    }

    public void setAaptMainDexListProguardOutputFile(File mainDexListProguardOutputFile) {
        this.mainDexListProguardOutputFile = mainDexListProguardOutputFile;
    }

    @Input
    public String getBuildToolsVersion() {
        return this.getBuildTools().getRevision().toString();
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    public FileCollection getSymbolListsWithPackageNames() {
        return this.symbolListsWithPackageNames;
    }

    @Input
    @Optional
    public String getPackageForR() {
        return this.packageForR != null ? this.packageForR.get() : null;
    }

    @Input
    public String getTypeAsString() {
        return this.type.name();
    }

    @Internal
    public VariantType getType() {
        return this.type;
    }

    public void setType(VariantType type) {
        this.type = type;
    }

    @Input
    public String getAaptGeneration() {
        return this.aaptGeneration.name();
    }

    @Input
    public boolean getDebuggable() {
        return this.debuggable;
    }

    public void setDebuggable(boolean debuggable) {
        this.debuggable = debuggable;
    }

    @Input
    public boolean getPseudoLocalesEnabled() {
        return this.pseudoLocalesEnabled;
    }

    public void setPseudoLocalesEnabled(boolean pseudoLocalesEnabled) {
        this.pseudoLocalesEnabled = pseudoLocalesEnabled;
    }

    @Nested
    public AaptOptions getAaptOptions() {
        return this.aaptOptions;
    }

    public void setAaptOptions(AaptOptions aaptOptions) {
        this.aaptOptions = aaptOptions;
    }

    @Input
    public File getMergeBlameLogFolder() {
        return this.mergeBlameLogFolder;
    }

    public void setMergeBlameLogFolder(File mergeBlameLogFolder) {
        this.mergeBlameLogFolder = mergeBlameLogFolder;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getFeatureResourcePackages() {
        return this.featureResourcePackages;
    }

    @Input
    public MultiOutputPolicy getMultiOutputPolicy() {
        return this.multiOutputPolicy;
    }

    @Input
    public String getOriginalApplicationId() {
        return this.originalApplicationId;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    FileCollection getSplitListInput() {
        return this.splitListInput;
    }

    @Input
    @Optional
    String getBuildTargetDensity() {
        return this.buildTargetDensity;
    }

    @OutputDirectory
    File getResPackageOutputFolder() {
        return this.resPackageOutputFolder;
    }

    @Input
    public boolean bypassAapt() {
        return this.bypassAapt;
    }

    @Input
    public boolean isDisableResMergeInLib() {
        return this.disableResMergeInLib;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @Optional
    FileCollection getPlatformAttrRTxt() {
        return this.platformAttrRTxt;
    }

    @Input
    public boolean isAapt2Enabled() {
        return this.enableAapt2;
    }

    public void setEnableAapt2(boolean enableAapt2) {
        this.enableAapt2 = enableAapt2;
    }

    @Input
    boolean isLibrary() {
        return this.isLibrary;
    }

    public static class FeatureSplitConfigAction
    extends ConfigAction {
        public FeatureSplitConfigAction(VariantScope scope, Supplier<File> symbolLocation, File symbolsWithPackageName, File resPackageOutputFolder, boolean generateLegacyMultidexMainDexProguardRules, TaskManager.MergeType mergeType, String baseName) {
            super(scope, symbolLocation, symbolsWithPackageName, resPackageOutputFolder, generateLegacyMultidexMainDexProguardRules, mergeType, baseName, false);
        }

        @Override
        public void execute(ProcessAndroidResources processResources) {
            super.execute(processResources);
            processResources.packageIdsFiles = this.variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_IDS_DECLARATION);
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<ProcessAndroidResources> {
        protected final VariantScope variantScope;
        protected final Supplier<File> symbolLocation;
        private final File symbolsWithPackageNameOutputFile;
        private final File resPackageOutputFolder;
        private final boolean generateLegacyMultidexMainDexProguardRules;
        private final TaskManager.MergeType sourceTaskOutputType;
        private final String baseName;
        private final boolean isLibrary;

        public ConfigAction(VariantScope scope, Supplier<File> symbolLocation, File symbolsWithPackageNameOutputFile, File resPackageOutputFolder, boolean generateLegacyMultidexMainDexProguardRules, TaskManager.MergeType sourceTaskOutputType, String baseName, boolean isLibrary) {
            this.variantScope = scope;
            this.symbolLocation = symbolLocation;
            this.symbolsWithPackageNameOutputFile = symbolsWithPackageNameOutputFile;
            this.resPackageOutputFolder = resPackageOutputFolder;
            this.generateLegacyMultidexMainDexProguardRules = generateLegacyMultidexMainDexProguardRules;
            this.baseName = baseName;
            this.sourceTaskOutputType = sourceTaskOutputType;
            this.isLibrary = isLibrary;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("process", "Resources");
        }

        @Override
        public Class<ProcessAndroidResources> getType() {
            return ProcessAndroidResources.class;
        }

        @Override
        public void execute(ProcessAndroidResources processResources) {
            BaseVariantData variantData = this.variantScope.getVariantData();
            ProjectOptions projectOptions = this.variantScope.getGlobalScope().getProjectOptions();
            variantData.addTask(TaskContainer.TaskKind.PROCESS_ANDROID_RESOURCES, (Task)processResources);
            GradleVariantConfiguration config = variantData.getVariantConfiguration();
            processResources.setAndroidBuilder(this.variantScope.getGlobalScope().getAndroidBuilder());
            processResources.fileCache = this.variantScope.getGlobalScope().getBuildCache();
            processResources.setVariantName(config.getFullName());
            processResources.resPackageOutputFolder = this.resPackageOutputFolder;
            processResources.aaptGeneration = AaptGeneration.fromProjectOptions(projectOptions);
            if (projectOptions.get(BooleanOption.ENABLE_NEW_RESOURCE_PROCESSING) && variantData.getType() == VariantType.LIBRARY) {
                processResources.bypassAapt = true;
                processResources.disableResMergeInLib = this.sourceTaskOutputType == TaskManager.MergeType.PACKAGE;
                processResources.platformAttrRTxt = this.variantScope.getGlobalScope().getOutput(TaskOutputHolder.TaskOutputType.PLATFORM_R_TXT);
            } else {
                Preconditions.checkState((this.sourceTaskOutputType == TaskManager.MergeType.MERGE ? 1 : 0) != 0, (String)"source output type should be MERGE", (Object)((Object)this.sourceTaskOutputType));
            }
            processResources.setEnableAapt2(projectOptions.get(BooleanOption.ENABLE_AAPT2));
            if (processResources.enableAapt2 && variantData.getType() == VariantType.LIBRARY) {
                Preconditions.checkState((boolean)projectOptions.get(BooleanOption.ENABLE_NEW_RESOURCE_PROCESSING), (Object)"New resource processing needs to be enabled to use AAPT2. Either disable AAPT2 or re-enable new resource processing.");
            }
            processResources.versionCode = config.getVersionCode();
            processResources.applicationId = config.getApplicationId();
            processResources.versionName = config.getVersionName();
            processResources.setIncrementalFolder(this.variantScope.getIncrementalDir(this.getName()));
            if (!this.isLibrary) {
                processResources.splitListInput = this.variantScope.getOutput(TaskOutputHolder.TaskOutputType.SPLIT_LIST);
            }
            processResources.multiOutputPolicy = variantData.getOutputScope().getMultiOutputPolicy();
            processResources.symbolListsWithPackageNames = this.variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.SYMBOL_LIST_WITH_PACKAGE_NAME);
            processResources.packageForR = TaskInputHelper.memoize(() -> {
                String splitName = config.getSplitFromManifest();
                if (splitName == null) {
                    return config.getOriginalApplicationId();
                }
                return config.getOriginalApplicationId() + "." + splitName;
            });
            processResources.setSourceOutputDir(this.variantScope.getRClassSourceOutputDir());
            processResources.textSymbolOutputDir = this.symbolLocation;
            processResources.symbolsWithPackageNameOutputFile = this.symbolsWithPackageNameOutputFile;
            if (this.variantScope.getCodeShrinker() != null) {
                processResources.setProguardOutputFile(this.variantScope.getProcessAndroidResourcesProguardOutputFile());
            }
            if (this.generateLegacyMultidexMainDexProguardRules) {
                processResources.setAaptMainDexListProguardOutputFile(this.variantScope.getManifestKeepListProguardFile());
            }
            processResources.variantScope = this.variantScope;
            processResources.outputScope = variantData.getOutputScope();
            processResources.outputFactory = variantData.getOutputFactory();
            processResources.originalApplicationId = this.variantScope.getVariantConfiguration().getOriginalApplicationId();
            boolean aaptFriendlyManifestsFilePresent = this.variantScope.hasOutput(TaskOutputHolder.TaskOutputType.AAPT_FRIENDLY_MERGED_MANIFESTS);
            processResources.taskInputType = aaptFriendlyManifestsFilePresent ? TaskOutputHolder.TaskOutputType.AAPT_FRIENDLY_MERGED_MANIFESTS : (this.variantScope.getInstantRunBuildContext().isInInstantRunMode() ? TaskOutputHolder.TaskOutputType.INSTANT_RUN_MERGED_MANIFESTS : TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS);
            processResources.setManifestFiles(this.variantScope.getOutput(processResources.taskInputType));
            processResources.inputResourcesDir = this.variantScope.getOutput(this.sourceTaskOutputType.getOutputType());
            processResources.setType(config.getType());
            processResources.setDebuggable(((CoreBuildType)config.getBuildType()).isDebuggable());
            processResources.setAaptOptions(this.variantScope.getGlobalScope().getExtension().getAaptOptions());
            processResources.setPseudoLocalesEnabled(((CoreBuildType)config.getBuildType()).isPseudoLocalesEnabled());
            processResources.buildTargetDensity = projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY);
            processResources.setMergeBlameLogFolder(this.variantScope.getResourceBlameLogDir());
            processResources.buildContext = this.variantScope.getInstantRunBuildContext();
            processResources.featureResourcePackages = this.variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_RESOURCE_PKG);
            processResources.projectBaseName = this.baseName;
            processResources.buildTargetAbi = projectOptions.get(BooleanOption.BUILD_ONLY_TARGET_ABI) || this.variantScope.getGlobalScope().getExtension().getSplits().getAbi().isEnable() ? projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI) : null;
            processResources.supportedAbis = config.getSupportedAbis();
            processResources.isLibrary = this.isLibrary;
            processResources.supportDirectory = new File(this.variantScope.getInstantRunSplitApkOutputFolder(), ProcessAndroidResources.IR_APK_FILE_NAME);
        }
    }
}

