/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.BuildSessionInterface;
import com.android.build.gradle.internal.BuildSessionSingleton;
import com.android.builder.Version;
import com.android.ide.common.util.BuildSessionVariable;
import com.android.ide.common.util.JvmWideVariable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.Project;

public final class BuildSessionHelper {
    private static BuildSessionInterface singleton = null;

    public static synchronized void startOnce(Project project) {
        Set<JvmWideVariable<?>> jvmWidePluginVersionRecords = BuildSessionHelper.verifyPluginVersion(project, Version.ANDROID_GRADLE_PLUGIN_VERSION, Version.ANDROID_GRADLE_COMPONENT_PLUGIN_VERSION);
        AtomicBoolean buildFirstStarted = new AtomicBoolean(false);
        if (singleton == null) {
            JvmWideVariable jvmWideSingleton = new JvmWideVariable(BuildSessionSingleton.class.getPackage().getName(), BuildSessionSingleton.class.getSimpleName(), TypeToken.of(Object.class), () -> {
                buildFirstStarted.set(true);
                return new BuildSessionSingleton(project.getGradle());
            });
            Object buildSessionSingleton = jvmWideSingleton.get();
            Preconditions.checkNotNull((Object)buildSessionSingleton);
            singleton = buildSessionSingleton instanceof BuildSessionInterface ? (BuildSessionInterface)buildSessionSingleton : (BuildSessionInterface)Proxy.newProxyInstance(BuildSessionInterface.class.getClassLoader(), new Class[]{BuildSessionInterface.class}, (InvocationHandler)new DelegateInvocationHandler(buildSessionSingleton));
            BuildSessionHelper.executeLastWhenBuildFinished(() -> {
                if (buildFirstStarted.get()) {
                    jvmWideSingleton.unregister();
                }
                singleton = null;
            });
        }
        BuildSessionVariable.buildStarted();
        BuildSessionHelper.executeLastWhenBuildFinished(BuildSessionVariable::buildFinished);
        if (buildFirstStarted.get()) {
            BuildSessionHelper.executeLastWhenBuildFinished(() -> jvmWidePluginVersionRecords.forEach(JvmWideVariable::unregister));
        }
    }

    static Set<JvmWideVariable<?>> verifyPluginVersion(Project project, String pluginVersion, String componentModelPluginVersion) {
        JvmWideVariable<?> jvmWidePluginVersion = BuildSessionHelper.doVerifyPluginVersion(project.getProjectDir(), "Android Gradle plugin", pluginVersion);
        JvmWideVariable<?> jvmWideComponentModelPluginVersion = BuildSessionHelper.doVerifyPluginVersion(project.getProjectDir(), "Android Gradle component model plugin", componentModelPluginVersion);
        return ImmutableSet.of(jvmWidePluginVersion, jvmWideComponentModelPluginVersion);
    }

    private static JvmWideVariable<?> doVerifyPluginVersion(File projectDir, String pluginName, String pluginVersion) {
        JvmWideVariable jvmWideMap = new JvmWideVariable("PLUGIN_VERSION", pluginName.replace(' ', '_'), (TypeToken)new TypeToken<ConcurrentMap<String, String>>(){}, ConcurrentHashMap::new);
        ConcurrentMap projectToPluginVersionMap = (ConcurrentMap)jvmWideMap.get();
        Preconditions.checkNotNull((Object)projectToPluginVersionMap);
        AtomicBoolean pluginWasAlreadyApplied = new AtomicBoolean(true);
        projectToPluginVersionMap.computeIfAbsent(projectDir.getAbsolutePath(), any -> {
            pluginWasAlreadyApplied.set(false);
            return pluginVersion;
        });
        return jvmWideMap;
    }

    static synchronized void verifySingletonExists() {
        if (singleton == null) {
            throw new IllegalStateException("Instance does not exist. BuildSessionHelper.startOnce(Gradle) must be called first.");
        }
    }

    static void executeLastWhenBuildFinished(Runnable action2) {
        BuildSessionHelper.verifySingletonExists();
        singleton.executeLastWhenBuildFinished(action2);
    }

    static synchronized BuildSessionInterface getSingleton() {
        return singleton;
    }

    private static final class DelegateInvocationHandler
    implements InvocationHandler {
        private final Object delegate;

        public DelegateInvocationHandler(Object delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.delegate.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke(this.delegate, args);
        }
    }
}

