/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.externalBuild;

import com.android.SdkConstants;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.externalBuild.ExternalBuildAndroidTarget;
import com.android.build.gradle.internal.externalBuild.ExternalBuildContext;
import com.android.build.gradle.internal.process.GradleJavaProcessExecutor;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.ErrorReporter;
import com.android.builder.sdk.TargetInfo;
import com.android.ide.common.process.JavaProcessExecutor;
import com.android.ide.common.process.ProcessExecutor;
import com.android.repository.Revision;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.rules.android.apkmanifest.ExternalBuildApkManifest;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.Project;

public class ExternalBuildManifestLoader {
    public static void loadAndPopulateContext(File execRootFile, File manifestProtoFile, Project project, ProjectOptions projectOptions, ExternalBuildContext externalBuildContext) throws IOException {
        ExternalBuildApkManifest.ApkManifest manifest;
        if (!manifestProtoFile.exists()) {
            throw new FileNotFoundException(manifestProtoFile.getAbsolutePath());
        }
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(manifestProtoFile));){
            manifest = ExternalBuildApkManifest.ApkManifest.parseFrom(is);
        }
        externalBuildContext.setBuildManifest(manifest);
        externalBuildContext.setExecutionRoot(execRootFile);
        List<File> jarFiles = manifest.getJarsList().stream().map(artifact -> new File(execRootFile, artifact.getExecRootPath())).collect(Collectors.toList());
        externalBuildContext.setInputJarFiles(jarFiles);
        externalBuildContext.setAndroidBuilder(ExternalBuildManifestLoader.createAndroidBuilder(execRootFile, project, projectOptions, manifest));
    }

    private static AndroidBuilder createAndroidBuilder(File executionRoot, Project project, ProjectOptions projectOptions, ExternalBuildApkManifest.ApkManifest manifest) {
        ExternalBuildApkManifest.AndroidSdk sdk = manifest.getAndroidSdk();
        File zipAlign = sdk.getZipalign().isEmpty() ? new File(ExternalBuildManifestLoader.getAbsoluteFile(executionRoot, sdk.getAapt()).getParentFile(), SdkConstants.FN_ZIPALIGN) : ExternalBuildManifestLoader.getAbsoluteFile(executionRoot, sdk.getZipalign());
        BuildToolInfo buildToolInfo = BuildToolInfo.partial((Revision)AndroidBuilder.DEFAULT_BUILD_TOOLS_REVISION, (File)project.getProjectDir(), (Map)ImmutableMap.of((Object)BuildToolInfo.PathId.DX_JAR, (Object)ExternalBuildManifestLoader.getAbsoluteFile(executionRoot, sdk.getDx()), (Object)BuildToolInfo.PathId.ZIP_ALIGN, (Object)zipAlign, (Object)BuildToolInfo.PathId.AAPT, (Object)ExternalBuildManifestLoader.getAbsoluteFile(executionRoot, sdk.getAapt())));
        ExternalBuildAndroidTarget androidTarget = new ExternalBuildAndroidTarget(ExternalBuildManifestLoader.getAbsoluteFile(executionRoot, sdk.getAndroidJar()));
        TargetInfo targetInfo = new TargetInfo((IAndroidTarget)androidTarget, buildToolInfo);
        AndroidBuilder androidBuilder = new AndroidBuilder(project.getPath(), "Android Studio + external build system", (ProcessExecutor)new GradleProcessExecutor(project), (JavaProcessExecutor)new GradleJavaProcessExecutor(project), (ErrorReporter)new ExtraModelInfo(projectOptions, project.getLogger()), (ILogger)new LoggerWrapper(project.getLogger()), false);
        androidBuilder.setTargetInfo(targetInfo);
        return androidBuilder;
    }

    private static File getAbsoluteFile(File executionRoot, String relativeOrAbsoluteFilePath) {
        File relativeOrAbsoluteFile = new File(relativeOrAbsoluteFilePath);
        return relativeOrAbsoluteFile.isAbsolute() ? relativeOrAbsoluteFile : new File(executionRoot, relativeOrAbsoluteFilePath);
    }
}

