/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.Toolchain;
import com.android.build.gradle.internal.ndk.DefaultNdkInfo;
import com.android.build.gradle.internal.ndk.NdkInfo;
import com.android.build.gradle.internal.ndk.NdkR11Info;
import com.android.build.gradle.internal.ndk.NdkR12Info;
import com.android.build.gradle.internal.ndk.NdkR13Info;
import com.android.build.gradle.internal.ndk.NdkR14Info;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.internal.ndk.StlNativeToolSpecification;
import com.android.repository.Revision;
import com.android.utils.Pair;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Properties;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.logging.Logging;

public class NdkHandler {
    private String platformVersion;
    private String compileSdkVersion;
    private final Toolchain toolchain;
    private final String toolchainVersion;
    private final File ndkDirectory;
    private final boolean useUnifiedHeaders;
    private final NdkInfo ndkInfo;
    private final Revision revision;
    private static final int LATEST_SUPPORTED_VERSION = 14;

    public NdkHandler(File projectDir, String platformVersion, String toolchainName, String toolchainVersion, Boolean useUnifiedHeaders) {
        this.toolchain = Toolchain.getByName(toolchainName);
        this.toolchainVersion = toolchainVersion;
        this.platformVersion = platformVersion;
        this.ndkDirectory = NdkHandler.findNdkDirectory(projectDir);
        if (this.ndkDirectory == null || !this.ndkDirectory.exists()) {
            this.ndkInfo = null;
            this.revision = null;
        } else {
            this.revision = NdkHandler.findRevision(this.ndkDirectory);
            if (this.revision == null) {
                this.ndkInfo = new DefaultNdkInfo(this.ndkDirectory);
            } else if (this.revision.getMajor() > 14) {
                this.ndkInfo = new NdkR14Info(this.ndkDirectory);
            } else {
                switch (this.revision.getMajor()) {
                    case 14: {
                        this.ndkInfo = new NdkR14Info(this.ndkDirectory);
                        break;
                    }
                    case 13: {
                        this.ndkInfo = new NdkR13Info(this.ndkDirectory);
                        break;
                    }
                    case 12: {
                        this.ndkInfo = new NdkR12Info(this.ndkDirectory);
                        break;
                    }
                    case 11: {
                        this.ndkInfo = new NdkR11Info(this.ndkDirectory);
                        break;
                    }
                    default: {
                        this.ndkInfo = new DefaultNdkInfo(this.ndkDirectory);
                    }
                }
            }
        }
        boolean bl = useUnifiedHeaders != null ? useUnifiedHeaders : (this.useUnifiedHeaders = this.revision != null && this.revision.getMajor() > 14);
        if (this.useUnifiedHeaders && (this.revision == null || this.revision.getMajor() < 14)) {
            throw new InvalidUserDataException("Unified headers is not supported before NDK r14.");
        }
    }

    private static Properties readProperties(File file) {
        Properties properties = new Properties();
        try (FileInputStream fis2 = new FileInputStream(file);
             InputStreamReader reader = new InputStreamReader((InputStream)fis2, Charsets.UTF_8);){
            properties.load(reader);
        }
        catch (FileNotFoundException fis2) {
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to read %1$s.", file), e);
        }
        return properties;
    }

    public static Revision findRevision(File ndkDirectory) {
        if (ndkDirectory == null) {
            return null;
        }
        File sourceProperties = new File(ndkDirectory, "source.properties");
        if (!sourceProperties.exists()) {
            return null;
        }
        Properties properties = NdkHandler.readProperties(sourceProperties);
        String version = properties.getProperty("Pkg.Revision");
        if (version != null) {
            return Revision.parseRevision((String)version);
        }
        return null;
    }

    public Revision getRevision() {
        return this.revision;
    }

    public String getPlatformVersion() {
        if (this.platformVersion == null && this.compileSdkVersion != null) {
            Preconditions.checkNotNull((Object)this.ndkInfo);
            this.platformVersion = this.ndkInfo.findLatestPlatformVersion(this.compileSdkVersion);
        }
        return this.platformVersion;
    }

    public void setCompileSdkVersion(String compileSdkVersion) {
        this.compileSdkVersion = compileSdkVersion;
    }

    public Toolchain getToolchain() {
        return this.toolchain;
    }

    public String getToolchainVersion() {
        return this.toolchainVersion;
    }

    private static File findNdkDirectory(File projectDir) {
        File ndkDir;
        File localProperties = new File(projectDir, "local.properties");
        Properties properties = new Properties();
        if (localProperties.isFile()) {
            properties = NdkHandler.readProperties(localProperties);
        }
        if ((ndkDir = NdkHandler.findNdkDirectory(properties, projectDir)) == null) {
            return null;
        }
        return NdkHandler.checkNdkDir(ndkDir) ? ndkDir : null;
    }

    private static boolean checkNdkDir(File ndkDir) {
        if (!new File(ndkDir, "platforms").isDirectory()) {
            NdkHandler.invalidNdkWarning("NDK is missing a \"platforms\" directory.", ndkDir);
            return false;
        }
        if (!new File(ndkDir, "toolchains").isDirectory()) {
            NdkHandler.invalidNdkWarning("NDK is missing a \"toolchains\" directory.", ndkDir);
            return false;
        }
        return true;
    }

    private static void invalidNdkWarning(String message, File ndkDir) {
        Logging.getLogger(NdkHandler.class).warn("{}\nIf you are using NDK, verify the ndk.dir is set to a valid NDK directory.  It is currently set to {}.\nIf you are not using NDK, unset the NDK variable from ANDROID_NDK_HOME or local.properties to remove this warning.\n", (Object)message, (Object)ndkDir.getAbsolutePath());
    }

    public static File findNdkDirectory(Properties properties, File projectDir) {
        File ndkBundle;
        String ndkDirProp = properties.getProperty("ndk.dir");
        if (ndkDirProp != null) {
            return new File(ndkDirProp);
        }
        String ndkEnvVar = System.getenv("ANDROID_NDK_HOME");
        if (ndkEnvVar != null) {
            return new File(ndkEnvVar);
        }
        Pair<File, Boolean> sdkLocation = SdkHandler.findSdkLocation(properties, projectDir);
        File sdkFolder = (File)sdkLocation.getFirst();
        if (sdkFolder != null && (ndkBundle = new File(sdkFolder, "ndk-bundle")).isDirectory()) {
            return ndkBundle;
        }
        return null;
    }

    public File getNdkDirectory() {
        return this.ndkDirectory;
    }

    public boolean isConfigured() {
        return this.ndkDirectory != null && this.ndkDirectory.isDirectory();
    }

    private File getToolchainPath(Toolchain toolchain, String toolchainVersion, Abi abi) {
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.ndkInfo.getToolchainPath(toolchain, toolchainVersion, abi);
    }

    public boolean isUseUnifiedHeaders() {
        return this.useUnifiedHeaders;
    }

    public String getCompilerSysroot(Abi abi) {
        if (this.getPlatformVersion() == null) {
            return "";
        }
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.ndkInfo.getCompilerSysrootPath(abi, this.getPlatformVersion(), this.useUnifiedHeaders);
    }

    public String getCompilerSysroot(Abi abi, String platformVersionOverride) {
        Preconditions.checkNotNull((Object)this.ndkInfo);
        if (platformVersionOverride == null) {
            return this.getCompilerSysroot(abi);
        }
        return this.ndkInfo.getCompilerSysrootPath(abi, platformVersionOverride, this.useUnifiedHeaders);
    }

    public String getLinkerSysroot(Abi abi) {
        if (this.getPlatformVersion() == null) {
            return "";
        }
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.ndkInfo.getLinkerSysrootPath(abi, this.getPlatformVersion());
    }

    public String getLinkerSysroot(Abi abi, String platformVersionOverride) {
        Preconditions.checkNotNull((Object)this.ndkInfo);
        if (platformVersionOverride == null) {
            return this.getLinkerSysroot(abi);
        }
        return this.ndkInfo.getLinkerSysrootPath(abi, platformVersionOverride);
    }

    private boolean supports64Bits() {
        if (this.getPlatformVersion() == null) {
            return false;
        }
        String targetString = this.getPlatformVersion().replace("android-", "");
        try {
            return Integer.parseInt(targetString) >= 20;
        }
        catch (NumberFormatException ignored) {
            return true;
        }
    }

    private String getGccToolchainVersion(Abi abi) {
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.toolchain == Toolchain.GCC && !this.toolchainVersion.isEmpty() ? this.toolchainVersion : this.ndkInfo.getDefaultToolchainVersion(Toolchain.GCC, abi);
    }

    public File getDefaultGccToolchainPath(Abi abi) {
        return this.getToolchainPath(Toolchain.GCC, this.getGccToolchainVersion(abi), abi);
    }

    public static Collection<Abi> getAbiList() {
        return ImmutableList.copyOf((Object[])Abi.values());
    }

    private static Collection<Abi> getAbiList32() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Abi abi : Abi.values()) {
            if (abi.supports64Bits()) continue;
            builder.add((Object)abi);
        }
        return builder.build();
    }

    public Collection<Abi> getSupportedAbis() {
        if (this.ndkInfo != null) {
            return this.supports64Bits() ? this.ndkInfo.getSupportedAbis() : this.ndkInfo.getSupported32BitsAbis();
        }
        return this.supports64Bits() ? NdkHandler.getAbiList() : NdkHandler.getAbiList32();
    }

    public Collection<Abi> getDefaultAbis() {
        if (this.ndkInfo != null) {
            return this.supports64Bits() ? this.ndkInfo.getDefaultAbis() : this.ndkInfo.getDefault32BitsAbis();
        }
        return this.supports64Bits() ? NdkHandler.getAbiList() : NdkHandler.getAbiList32();
    }

    public File getCCompiler(Abi abi) {
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.ndkInfo.getCCompiler(this.toolchain, this.toolchainVersion, abi);
    }

    public File getCppCompiler(Abi abi) {
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.ndkInfo.getCppCompiler(this.toolchain, this.toolchainVersion, abi);
    }

    public File getLinker(Abi abi) {
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.ndkInfo.getLinker(this.toolchain, this.toolchainVersion, abi);
    }

    public File getAssembler(Abi abi) {
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.ndkInfo.getAssembler(this.toolchain, this.toolchainVersion, abi);
    }

    public File getAr(Abi abi) {
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.ndkInfo.getAr(this.toolchain, this.toolchainVersion, abi);
    }

    public File getStripExecutable(Abi abi) {
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.ndkInfo.getStripExecutable(this.toolchain, this.toolchainVersion, abi);
    }

    public StlNativeToolSpecification getStlNativeToolSpecification(Stl stl, String stlVersion, Abi abi) {
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.ndkInfo.getStlNativeToolSpecification(stl, stlVersion, abi);
    }

    public int findSuitablePlatformVersion(String abi, int minSdkVersion) {
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.ndkInfo.findSuitablePlatformVersion(abi, minSdkVersion);
    }
}

