/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.profile.ProfileRecordWriter;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleTaskExecution;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.tasks.TaskState;

public class RecordingBuildListener
implements TaskExecutionListener {
    private final ProfileRecordWriter recordWriter;
    private final Map<String, GradleBuildProfileSpan.Builder> taskRecords = new ConcurrentHashMap<String, GradleBuildProfileSpan.Builder>();

    RecordingBuildListener(ProfileRecordWriter recorder) {
        this.recordWriter = recorder;
    }

    public void beforeExecute(Task task) {
        GradleBuildProfileSpan.Builder builder = GradleBuildProfileSpan.newBuilder();
        builder.setType(GradleBuildProfileSpan.ExecutionType.TASK_EXECUTION);
        builder.setId(this.recordWriter.allocateRecordId());
        builder.setStartTimeInMs(System.currentTimeMillis());
        this.taskRecords.put(task.getPath(), builder);
    }

    public void afterExecute(Task task, TaskState taskState) {
        GradleBuildProfileSpan.Builder record = this.taskRecords.remove(task.getPath());
        record.setDurationInMs(System.currentTimeMillis() - record.getStartTimeInMs());
        record.setTask(GradleTaskExecution.newBuilder().setType(AnalyticsUtil.getTaskExecutionType(task.getClass()).getNumber()).setDidWork(taskState.getDidWork()).setSkipped(taskState.getSkipped()).setUpToDate(taskState.getUpToDate()).setFailed(taskState.getFailure() != null));
        this.recordWriter.writeRecord(task.getProject().getPath(), RecordingBuildListener.getVariantName(task), record);
        ProcessProfileWriter.recordMemorySample();
    }

    private static String getVariantName(Task task) {
        if (!(task instanceof DefaultAndroidTask)) {
            return null;
        }
        String variantName = ((DefaultAndroidTask)task).getVariantName();
        if (variantName == null) {
            throw new IllegalStateException("Task with type " + task.getClass().getName() + " does not include a variantName");
        }
        if (variantName.isEmpty()) {
            return null;
        }
        return variantName;
    }
}

