/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.AndroidDependenciesRenderer;
import com.android.build.gradle.internal.scope.TransformVariantScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.logging.text.StyledTextOutputFactory;

public class DependencyReportTask
extends DefaultTask {
    private final AndroidDependenciesRenderer renderer = new AndroidDependenciesRenderer();
    private final Set<VariantScope> variants = new HashSet<VariantScope>();

    @TaskAction
    public void generate() throws IOException {
        this.renderer.setOutput(((StyledTextOutputFactory)this.getServices().get(StyledTextOutputFactory.class)).create(((Object)((Object)this)).getClass()));
        List sortedVariants = Ordering.natural().onResultOf(TransformVariantScope::getFullVariantName).sortedCopy(this.variants);
        for (VariantScope variant : sortedVariants) {
            this.renderer.startVariant(variant);
            this.renderer.render(variant);
        }
    }

    public void setVariants(Collection<VariantScope> variantScopes) {
        this.variants.addAll(variantScopes);
    }
}

