/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.OutputFile;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.internal.InstallUtils;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.sdk.TargetInfo;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.builder.testing.api.DeviceConfigProviderImpl;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.DeviceProvider;
import com.android.ide.common.build.SplitOutputMatcher;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class InstallVariantTask
extends BaseTask {
    private Supplier<File> adbExe;
    private Supplier<File> splitSelectExe;
    private ProcessExecutor processExecutor;
    private String projectName;
    private int timeOutInMs = 0;
    private Collection<String> installOptions;
    private FileCollection apkDirectory;
    private BaseVariantData variantData;

    public InstallVariantTask() {
        this.getOutputs().upToDateWhen(task -> {
            this.getLogger().debug("Install task is always run.");
            return false;
        });
    }

    @TaskAction
    public void install() throws DeviceException, ProcessException, InterruptedException {
        ILogger iLogger = this.getILogger();
        ConnectedDeviceProvider deviceProvider = new ConnectedDeviceProvider(this.adbExe.get(), this.getTimeOutInMs(), iLogger);
        deviceProvider.init();
        BaseVariantData variantData = this.getVariantData();
        GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        ImmutableList outputs = ImmutableList.copyOf(BuildOutputs.load((TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.APK, this.getApkDirectory()));
        InstallVariantTask.install(this.getProjectName(), variantConfig.getFullName(), (DeviceProvider)deviceProvider, variantConfig.getMinSdkVersion(), this.getProcessExecutor(), this.getSplitSelectExe(), (List<OutputFile>)outputs, variantConfig.getSupportedAbis(), this.getInstallOptions(), this.getTimeOutInMs(), this.getLogger());
    }

    static void install(String projectName, String variantName, DeviceProvider deviceProvider, AndroidVersion minSkdVersion, ProcessExecutor processExecutor, File splitSelectExe, List<OutputFile> outputs, Set<String> supportedAbis, Collection<String> installOptions, int timeOutInMs, Logger logger) throws DeviceException, ProcessException {
        LoggerWrapper iLogger = new LoggerWrapper(logger);
        int successfulInstallCount = 0;
        List devices = deviceProvider.getDevices();
        for (DeviceConnector device : devices) {
            if (!InstallUtils.checkDeviceApiLevel((DeviceConnector)device, (AndroidVersion)minSkdVersion, (ILogger)iLogger, (String)projectName, (String)variantName)) continue;
            List apkFiles = SplitOutputMatcher.computeBestOutput((ProcessExecutor)processExecutor, (File)splitSelectExe, (DeviceConfigProvider)new DeviceConfigProviderImpl(device), outputs, supportedAbis);
            if (apkFiles.isEmpty()) {
                logger.lifecycle("Skipping device '{}' for '{}:{}': Could not find build of variant which supports density {} and an ABI in {}", new Object[]{device.getName(), projectName, variantName, device.getDensity(), Joiner.on((String)", ").join((Iterable)device.getAbis())});
                continue;
            }
            logger.lifecycle("Installing APK '{}' on '{}' for {}:{}", new Object[]{FileUtils.getNamesAsCommaSeparatedList((Iterable)apkFiles), device.getName(), projectName, variantName});
            Collection extraArgs = (Collection)MoreObjects.firstNonNull(installOptions, (Object)ImmutableList.of());
            if (apkFiles.size() > 1) {
                device.installPackages(apkFiles, extraArgs, timeOutInMs, (ILogger)iLogger);
                ++successfulInstallCount;
                continue;
            }
            device.installPackage((File)apkFiles.get(0), extraArgs, timeOutInMs, (ILogger)iLogger);
            ++successfulInstallCount;
        }
        if (successfulInstallCount == 0) {
            throw new GradleException("Failed to install on any devices.");
        }
        logger.quiet("Installed on {} {}.", new Object[]{successfulInstallCount, successfulInstallCount == 1 ? "device" : "devices"});
    }

    @InputFile
    public File getAdbExe() {
        return this.adbExe.get();
    }

    @InputFile
    @Optional
    public File getSplitSelectExe() {
        return this.splitSelectExe.get();
    }

    public ProcessExecutor getProcessExecutor() {
        return this.processExecutor;
    }

    public void setProcessExecutor(ProcessExecutor processExecutor) {
        this.processExecutor = processExecutor;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Input
    public int getTimeOutInMs() {
        return this.timeOutInMs;
    }

    public void setTimeOutInMs(int timeOutInMs) {
        this.timeOutInMs = timeOutInMs;
    }

    @Input
    @Optional
    public Collection<String> getInstallOptions() {
        return this.installOptions;
    }

    public void setInstallOptions(Collection<String> installOptions) {
        this.installOptions = installOptions;
    }

    @InputDirectory
    public File getApkDirectory() {
        return this.apkDirectory.getSingleFile();
    }

    public void setApkDirectory(FileCollection apkDirectory) {
        this.apkDirectory = apkDirectory;
    }

    public BaseVariantData getVariantData() {
        return this.variantData;
    }

    public void setVariantData(BaseVariantData variantData) {
        this.variantData = variantData;
    }

    public static class ConfigAction
    implements TaskConfigAction<InstallVariantTask> {
        private final VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("install");
        }

        @Override
        public Class<InstallVariantTask> getType() {
            return InstallVariantTask.class;
        }

        @Override
        public void execute(InstallVariantTask installTask) {
            installTask.setDescription("Installs the " + this.scope.getVariantData().getDescription() + ".");
            installTask.setVariantName(this.scope.getVariantConfiguration().getFullName());
            installTask.setGroup("Install");
            installTask.setProjectName(this.scope.getGlobalScope().getProject().getName());
            installTask.setVariantData(this.scope.getVariantData());
            installTask.setApkDirectory(this.scope.getOutput(TaskOutputHolder.TaskOutputType.APK));
            installTask.setTimeOutInMs(this.scope.getGlobalScope().getExtension().getAdbOptions().getTimeOutInMs());
            installTask.setInstallOptions(this.scope.getGlobalScope().getExtension().getAdbOptions().getInstallOptions());
            installTask.setProcessExecutor(this.scope.getGlobalScope().getAndroidBuilder().getProcessExecutor());
            installTask.adbExe = TaskInputHelper.memoize(() -> {
                SdkInfo info = this.scope.getGlobalScope().getSdkHandler().getSdkInfo();
                return info == null ? null : info.getAdb();
            });
            installTask.splitSelectExe = TaskInputHelper.memoize(() -> {
                String path;
                TargetInfo info = this.scope.getGlobalScope().getAndroidBuilder().getTargetInfo();
                String string = path = info == null ? null : info.getBuildTools().getPath(BuildToolInfo.PathId.SPLIT_SELECT);
                if (path != null) {
                    File splitSelectExe = new File(path);
                    return splitSelectExe.exists() ? splitSelectExe : null;
                }
                return null;
            });
            ((ApkVariantData)this.scope.getVariantData()).installTask = installTask;
        }
    }
}

