/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.annotations;

import com.android.build.gradle.tasks.annotations.ApiDatabase;
import com.android.build.gradle.tasks.annotations.TypedefRemover;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.FileUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.xml.XmlEscapers;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.javadoc.PsiDocComment;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Extractor {
    public static final boolean REMOVE_HIDDEN_TYPEDEFS = false;
    private final boolean sortAnnotations;
    private final boolean includeClassRetentionAnnotations;
    private static final boolean INCLUDE_INFERRED_NULLABLE = false;
    public static final String ANDROID_ANNOTATIONS_PREFIX = "android.annotation.";
    public static final String ANDROID_NULLABLE = "android.annotation.Nullable";
    public static final String SUPPORT_NULLABLE = "android.support.annotation.Nullable";
    public static final String SUPPORT_KEEP = "android.support.annotation.Keep";
    public static final String RESOURCE_TYPE_ANNOTATIONS_SUFFIX = "Res";
    public static final String ANDROID_NOTNULL = "android.annotation.NonNull";
    public static final String SUPPORT_NOTNULL = "android.support.annotation.NonNull";
    public static final String ANDROID_INT_DEF = "android.annotation.IntDef";
    public static final String ANDROID_INT_RANGE = "android.annotation.IntRange";
    public static final String ANDROID_STRING_DEF = "android.annotation.StringDef";
    public static final String REQUIRES_PERMISSION = "android.support.annotation.RequiresPermission";
    public static final String ANDROID_REQUIRES_PERMISSION = "android.annotation.RequiresPermission";
    public static final String IDEA_NULLABLE = "org.jetbrains.annotations.Nullable";
    public static final String IDEA_NOTNULL = "org.jetbrains.annotations.NotNull";
    public static final String IDEA_MAGIC = "org.intellij.lang.annotations.MagicConstant";
    public static final String IDEA_CONTRACT = "org.jetbrains.annotations.Contract";
    public static final String IDEA_NON_NLS = "org.jetbrains.annotations.NonNls";
    public static final String ATTR_VAL = "val";
    public static final String ATTR_PURE = "pure";
    private final Map<String, List<AnnotationData>> types = Maps.newHashMap();
    private final Set<String> irrelevantAnnotations = Sets.newHashSet();
    private final File classDir;
    private final Map<String, Map<String, List<Item>>> itemMap = Maps.newHashMap();
    private Map<String, PackageItem> packageMap;
    private final ApiDatabase apiFilter;
    private final boolean displayInfo;
    private final Map<String, Integer> stats = Maps.newHashMap();
    private int filteredCount;
    private int mergedCount;
    private final Set<String> ignoredAnnotations = Sets.newHashSet();
    private boolean listIgnored;
    private List<String> typedefsToRemove;
    private Map<String, Boolean> sourceRetention;
    private final List<Item> keepItems = Lists.newArrayList();
    private PsiClass lastClass;
    private String lastFqn;

    public static List<PsiJavaFile> createUnitsForFiles(Project project, List<File> specificSources) {
        ArrayList units = Lists.newArrayListWithCapacity((int)specificSources.size());
        VirtualFileSystem fileSystem = StandardFileSystems.local();
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (File source : specificSources) {
            PsiFile psiFile;
            VirtualFile virtualFile = fileSystem.findFileByPath(source.getPath());
            if (virtualFile == null || !((psiFile = manager.findFile(virtualFile)) instanceof PsiJavaFile)) continue;
            units.add((PsiJavaFile)psiFile);
        }
        return units;
    }

    public static List<PsiJavaFile> createUnitsInDirectories(Project project, List<File> sourceDirs) {
        return Extractor.createUnitsForFiles(project, Extractor.gatherJavaSources(sourceDirs));
    }

    private static void addJavaSources(List<File> list, File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File child : files) {
                    Extractor.addJavaSources(list, child);
                }
            }
        } else if (file.isFile() && file.getName().endsWith(".java")) {
            list.add(file);
        }
    }

    private static List<File> gatherJavaSources(List<File> sourcePath) {
        ArrayList sources = Lists.newArrayList();
        for (File file : sourcePath) {
            Extractor.addJavaSources(sources, file);
        }
        return sources;
    }

    public Extractor(ApiDatabase apiFilter, File classDir, boolean displayInfo, boolean includeClassRetentionAnnotations, boolean sortAnnotations) {
        this.apiFilter = apiFilter;
        this.listIgnored = apiFilter != null;
        this.classDir = classDir;
        this.displayInfo = displayInfo;
        this.includeClassRetentionAnnotations = includeClassRetentionAnnotations;
        this.sortAnnotations = sortAnnotations;
    }

    public void extractFromProjectSource(List<PsiJavaFile> units) {
        AnnotationVisitor visitor = new AnnotationVisitor(false, true);
        for (PsiJavaFile unit : units) {
            unit.accept((PsiElementVisitor)visitor);
        }
        this.typedefsToRemove = visitor.getPrivateTypedefClasses();
    }

    public void removeTypedefClasses() {
        if (this.classDir != null && this.typedefsToRemove != null && !this.typedefsToRemove.isEmpty()) {
            boolean quiet = false;
            boolean verbose = false;
            boolean dryRun = false;
            TypedefRemover remover = new TypedefRemover(this, quiet, verbose, dryRun);
            remover.remove(this.classDir, this.typedefsToRemove);
        }
    }

    public void writeTypedefFile(File file) throws IOException {
        String desc = "";
        if (this.typedefsToRemove != null) {
            Collections.sort(this.typedefsToRemove);
            StringBuilder sb = new StringBuilder(this.typedefsToRemove.size() * 100);
            for (String cls : this.typedefsToRemove) {
                sb.append("D ");
                sb.append(cls);
                sb.append("\n");
            }
            desc = sb.toString();
        }
        FileUtils.deleteIfExists((File)file);
        Files.createParentDirs((File)file);
        Files.write((CharSequence)desc, (File)file, (Charset)Charsets.UTF_8);
    }

    public static void removeTypedefClasses(File classDir, File typedefFile) {
        boolean quiet = false;
        boolean verbose = false;
        boolean dryRun = false;
        TypedefRemover remover = new TypedefRemover(null, quiet, verbose, dryRun);
        remover.removeFromTypedefFile(classDir, typedefFile);
    }

    public void export(File annotationsZip, File proguardCfg) throws IOException {
        if (proguardCfg != null) {
            if (this.keepItems.isEmpty()) {
                if (proguardCfg.exists()) {
                    proguardCfg.delete();
                }
            } else if (this.writeKeepRules(proguardCfg)) {
                this.info("ProGuard keep rules written to " + proguardCfg);
            }
        }
        if (annotationsZip != null) {
            if (this.itemMap.isEmpty() && this.packageMap == null) {
                FileUtils.deleteIfExists((File)annotationsZip);
            } else {
                this.writeExternalAnnotations(annotationsZip);
                this.writeStats();
                this.info("Annotations written to " + annotationsZip);
            }
        }
    }

    public void writeStats() {
        if (!this.displayInfo) {
            return;
        }
        if (!this.stats.isEmpty()) {
            ArrayList annotations = Lists.newArrayList(this.stats.keySet());
            annotations.sort((s1, s2) -> {
                int frequency1 = this.stats.get(s1);
                int frequency2 = this.stats.get(s2);
                int delta = frequency2 - frequency1;
                if (delta != 0) {
                    return delta;
                }
                return s1.compareTo((String)s2);
            });
            HashMap fqnToName = Maps.newHashMap();
            int max = 0;
            int count = 0;
            for (String fqn : annotations) {
                String name = fqn.substring(fqn.lastIndexOf(46) + 1);
                fqnToName.put(fqn, name);
                max = Math.max(max, name.length());
                count += this.stats.get(fqn).intValue();
            }
            StringBuilder sb = new StringBuilder(200);
            sb.append("Extracted ").append(count).append(" Annotations:");
            for (String fqn : annotations) {
                sb.append('\n');
                String name = (String)fqnToName.get(fqn);
                int n = max - name.length() + 1;
                for (int i = 0; i < n; ++i) {
                    sb.append(' ');
                }
                sb.append('@');
                sb.append(name);
                sb.append(':').append(' ');
                sb.append(Integer.toString(this.stats.get(fqn)));
            }
            if (sb.length() > 0) {
                this.info(sb.toString());
            }
        }
        if (this.filteredCount > 0) {
            this.info(this.filteredCount + " of these were filtered out (not in API database file)");
        }
        if (this.mergedCount > 0) {
            this.info(this.mergedCount + " additional annotations were merged in");
        }
    }

    void info(String message) {
        if (this.displayInfo) {
            System.out.println(message);
        }
    }

    static void error(String message) {
        System.err.println("Error: " + message);
    }

    static void warning(String message) {
        System.out.println("Warning: " + message);
    }

    private static String getFqn(PsiAnnotation annotation) {
        return annotation.getQualifiedName();
    }

    private String getFqn(PsiClass cls) {
        if (cls != null) {
            if (cls.equals(this.lastClass)) {
                return this.lastFqn;
            }
            this.lastClass = cls;
            this.lastFqn = cls.getQualifiedName();
            return this.lastFqn;
        }
        return null;
    }

    private boolean hasSourceRetention(String fqn, PsiAnnotation annotation) {
        PsiElement resolved;
        Boolean source;
        if (annotation == null) {
            return false;
        }
        if (this.sourceRetention == null) {
            this.sourceRetention = Maps.newHashMapWithExpectedSize((int)20);
            this.sourceRetention.put("android.support.annotation.IntDef", true);
            this.sourceRetention.put("android.support.annotation.StringDef", true);
            this.sourceRetention.put(SUPPORT_NOTNULL, false);
            this.sourceRetention.put(SUPPORT_NULLABLE, false);
        }
        if ((source = this.sourceRetention.get(fqn)) != null) {
            return source;
        }
        boolean hasSourceRetention = false;
        PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
        if (ref != null && (resolved = ref.resolve()) instanceof PsiClass) {
            hasSourceRetention = Extractor.hasSourceRetention((PsiClass)resolved);
        }
        this.sourceRetention.put(fqn, hasSourceRetention);
        return hasSourceRetention;
    }

    static boolean hasSourceRetention(PsiAnnotation psiAnnotation) {
        if ("java.lang.annotation.Retention".equals(psiAnnotation.getQualifiedName())) {
            PsiField field;
            PsiReferenceExpression expression;
            PsiElement element;
            PsiNameValuePair[] attributes = psiAnnotation.getParameterList().getAttributes();
            if (attributes.length != 1) {
                Extractor.error("Expected exactly one parameter passed to @Retention");
                return false;
            }
            PsiAnnotationMemberValue value = attributes[0].getValue();
            if (value instanceof PsiReferenceExpression && (element = (expression = (PsiReferenceExpression)value).resolve()) instanceof PsiField && "SOURCE".equals((field = (PsiField)element).getName())) {
                return true;
            }
        }
        return false;
    }

    static boolean hasSourceRetention(PsiClass cls) {
        PsiModifierList modifierList = cls.getModifierList();
        if (modifierList != null) {
            for (PsiAnnotation psiAnnotation : modifierList.getAnnotations()) {
                if (!Extractor.hasSourceRetention(psiAnnotation)) continue;
                return true;
            }
        }
        return false;
    }

    private void addAnnotations(PsiModifierList modifierList, Item item) {
        if (modifierList != null) {
            for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                if (!this.isRelevantAnnotation(annotation)) continue;
                String fqn = Extractor.getFqn(annotation);
                if (SUPPORT_KEEP.equals(fqn)) {
                    this.keepItems.add(item);
                    continue;
                }
                this.addAnnotation(annotation, fqn, item.annotations);
            }
        }
    }

    private void addAnnotation(PsiAnnotation annotation, String fqn, List<AnnotationData> list) {
        List<AnnotationData> indirect;
        if (fqn == null) {
            return;
        }
        if (fqn.equals(ANDROID_NULLABLE) || fqn.equals(SUPPORT_NULLABLE)) {
            this.recordStats(fqn);
            list.add(new AnnotationData(SUPPORT_NULLABLE));
            return;
        }
        if (fqn.equals(ANDROID_NOTNULL) || fqn.equals(SUPPORT_NOTNULL)) {
            this.recordStats(fqn);
            list.add(new AnnotationData(SUPPORT_NOTNULL));
            return;
        }
        if (fqn.startsWith("android.support.annotation.") && fqn.endsWith(RESOURCE_TYPE_ANNOTATIONS_SUFFIX)) {
            this.recordStats(fqn);
            list.add(new AnnotationData(fqn));
            return;
        }
        if (fqn.startsWith(ANDROID_ANNOTATIONS_PREFIX)) {
            if (fqn.endsWith(RESOURCE_TYPE_ANNOTATIONS_SUFFIX)) {
                String resAnnotation = "android.support.annotation." + fqn.substring(ANDROID_ANNOTATIONS_PREFIX.length());
                if (!this.includeClassRetentionAnnotations && !this.hasSourceRetention(resAnnotation, null)) {
                    return;
                }
                this.recordStats(resAnnotation);
                list.add(new AnnotationData(resAnnotation));
                return;
            }
            if (Extractor.isRelevantFrameworkAnnotation(fqn)) {
                String supportAnnotation = "android.support.annotation." + fqn.substring(ANDROID_ANNOTATIONS_PREFIX.length());
                if (!this.includeClassRetentionAnnotations && !this.hasSourceRetention(supportAnnotation, null)) {
                    return;
                }
                this.recordStats(supportAnnotation);
                list.add(this.createData(supportAnnotation, annotation));
            }
        }
        if (fqn.startsWith("android.support.annotation.")) {
            this.recordStats(fqn);
            list.add(this.createData(fqn, annotation));
            return;
        }
        if (this.isMagicConstant(annotation, fqn) && (indirect = this.types.get(fqn)) != null) {
            list.addAll(indirect);
        }
    }

    private void recordStats(String fqn) {
        Integer count = this.stats.get(fqn);
        if (count == null) {
            count = 0;
        }
        this.stats.put(fqn, count + 1);
    }

    private boolean hasRelevantAnnotations(PsiModifierList modifiers) {
        if (modifiers != null) {
            for (PsiAnnotation annotation : modifiers.getAnnotations()) {
                if (!this.isRelevantAnnotation(annotation)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRelevantAnnotation(PsiAnnotation annotation) {
        String name;
        PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
        if (nameReferenceElement != null && ("Override".equals(name = nameReferenceElement.getReferenceName()) || "SuppressWarnings".equals(name))) {
            return false;
        }
        String fqn = Extractor.getFqn(annotation);
        if (fqn == null || fqn.startsWith("java.lang.")) {
            return false;
        }
        if (fqn.startsWith("android.support.annotation.")) {
            if (fqn.equals(SUPPORT_KEEP)) {
                return true;
            }
            return this.includeClassRetentionAnnotations || this.hasSourceRetention(fqn, annotation);
        }
        if (fqn.startsWith(ANDROID_ANNOTATIONS_PREFIX)) {
            return Extractor.isRelevantFrameworkAnnotation(fqn);
        }
        if (fqn.equals(ANDROID_NULLABLE) || fqn.equals(ANDROID_NOTNULL) || this.isMagicConstant(annotation, fqn)) {
            return true;
        }
        return fqn.equals(IDEA_CONTRACT);
    }

    private static boolean isRelevantFrameworkAnnotation(String fqn) {
        return fqn.startsWith(ANDROID_ANNOTATIONS_PREFIX) && !fqn.endsWith(".Widget") && !fqn.endsWith(".TargetApi") && !fqn.endsWith(".SystemApi") && !fqn.endsWith(".TestApi") && !fqn.endsWith(".SuppressAutoDoc") && !fqn.endsWith(".SuppressLint") && !fqn.endsWith(".SdkConstant");
    }

    boolean isMagicConstant(PsiAnnotation annotation, String typeName) {
        PsiModifierList modifierList;
        PsiElement resolved;
        if (this.irrelevantAnnotations.contains(typeName) || typeName.startsWith("java.lang.")) {
            return false;
        }
        if (this.types.containsKey(typeName)) {
            return true;
        }
        switch (typeName) {
            case "android.support.annotation.IntDef": 
            case "android.support.annotation.StringDef": 
            case "android.support.annotation.IntRange": 
            case "android.annotation.IntRange": 
            case "android.annotation.IntDef": 
            case "android.annotation.StringDef": {
                return true;
            }
        }
        PsiJavaCodeReferenceElement referenceElement = annotation.getNameReferenceElement();
        if (referenceElement != null && (resolved = referenceElement.resolve()) instanceof PsiClass && (modifierList = ((PsiClass)resolved).getModifierList()) != null) {
            boolean match = false;
            for (PsiAnnotation a : modifierList.getAnnotations()) {
                String fqn = a.getQualifiedName();
                if (!Extractor.isNestedAnnotation(fqn)) continue;
                List<AnnotationData> list = this.types.get(typeName);
                if (list == null) {
                    list = new ArrayList<AnnotationData>(2);
                    this.types.put(typeName, list);
                }
                this.addAnnotation(a, fqn, list);
                match = true;
            }
            if (match) {
                return true;
            }
        }
        this.irrelevantAnnotations.add(typeName);
        return false;
    }

    static boolean isNestedAnnotation(String fqn) {
        return fqn != null && (fqn.equals("android.support.annotation.IntDef") || fqn.equals("android.support.annotation.StringDef") || fqn.equals(REQUIRES_PERMISSION) || fqn.equals(ANDROID_REQUIRES_PERMISSION) || fqn.equals("android.support.annotation.IntRange") || fqn.equals(ANDROID_INT_RANGE) || fqn.equals(ANDROID_INT_DEF) || fqn.equals(ANDROID_STRING_DEF));
    }

    private boolean writeKeepRules(File proguardCfg) {
        if (!this.keepItems.isEmpty()) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(proguardCfg));){
                Collections.sort(this.keepItems);
                for (Item item : this.keepItems) {
                    writer.write(item.getKeepRule());
                    ((Writer)writer).write(10);
                }
            }
            catch (IOException ioe) {
                Extractor.error(ioe.toString());
                return true;
            }
            for (Item item : this.keepItems) {
                this.removeItem(item.getQualifiedClassName(), item);
            }
        } else if (proguardCfg.exists()) {
            proguardCfg.delete();
        }
        return false;
    }

    private void writeExternalAnnotations(File annotationsZip) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(annotationsZip);
             JarOutputStream zos = new JarOutputStream(new BufferedOutputStream(fileOutputStream));){
            ArrayList<String> sortedPackages = new ArrayList<String>(this.itemMap.keySet());
            if (this.packageMap != null) {
                for (String pkg : this.packageMap.keySet()) {
                    if (this.itemMap.containsKey(pkg)) continue;
                    sortedPackages.add(pkg);
                }
            }
            Collections.sort(sortedPackages);
            for (String pkg : sortedPackages) {
                String name = pkg.replace('.', '/') + "/annotations.xml";
                JarEntry outEntry = new JarEntry(name);
                zos.putNextEntry(outEntry);
                StringPrintWriter writer = StringPrintWriter.create();
                Throwable throwable = null;
                try {
                    Document document;
                    PackageItem item;
                    writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<root>");
                    Map<String, List<Item>> classMap = this.itemMap.get(pkg);
                    if (classMap == null) {
                        classMap = Collections.emptyMap();
                    }
                    if (this.packageMap != null && (item = this.packageMap.get(pkg)) != null) {
                        item.write(writer);
                    }
                    ArrayList<String> classes = new ArrayList<String>(classMap.keySet());
                    Collections.sort(classes);
                    for (String cls : classes) {
                        List<Item> items = classMap.get(cls);
                        Collections.sort(items);
                        for (Item item2 : items) {
                            item2.write(writer);
                        }
                    }
                    writer.println("</root>\n");
                    writer.close();
                    String xml = writer.getContents();
                    if (LintUtils.assertionsEnabled() && (document = Extractor.checkDocument(pkg, xml, false)) == null) {
                        Extractor.error("Could not parse XML document back in for entry " + name + ": invalid XML?\n\"\"\"\n" + xml + "\n\"\"\"\n");
                    }
                    byte[] bytes = xml.getBytes(Charsets.UTF_8);
                    zos.write(bytes);
                    zos.closeEntry();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
        }
    }

    private void addPackage(String pkg, PackageItem item) {
        if (this.apiFilter != null && item.isFiltered(this.apiFilter)) {
            if (this.isListIgnored()) {
                this.info("Skipping API because it is not part of the API file: " + item);
            }
            ++this.filteredCount;
            return;
        }
        if (this.packageMap == null) {
            this.packageMap = Maps.newHashMap();
        }
        this.packageMap.put(pkg, item);
    }

    private void addItem(String fqn, Item item) {
        if (this.apiFilter != null && item.isFiltered(this.apiFilter)) {
            if (this.isListIgnored()) {
                this.info("Skipping API because it is not part of the API file: " + item);
            }
            ++this.filteredCount;
            return;
        }
        this.addItemUnconditionally(fqn, item);
    }

    private void addItemUnconditionally(String fqn, Item item) {
        List items;
        String pkg = Extractor.getPackage(fqn);
        HashMap classMap = this.itemMap.get(pkg);
        if (classMap == null) {
            classMap = Maps.newHashMapWithExpectedSize((int)100);
            this.itemMap.put(pkg, classMap);
        }
        if ((items = (List)classMap.get(fqn)) == null) {
            items = Lists.newArrayList();
            classMap.put(fqn, items);
        }
        items.add(item);
    }

    private void removeItem(String classFqn, Item item) {
        List<Item> items;
        String pkg = Extractor.getPackage(classFqn);
        Map<String, List<Item>> classMap = this.itemMap.get(pkg);
        if (classMap != null && (items = classMap.get(classFqn)) != null) {
            items.remove(item);
            if (items.isEmpty()) {
                classMap.remove(classFqn);
                if (classMap.isEmpty()) {
                    this.itemMap.remove(pkg);
                }
            }
        }
    }

    private Item findItem(String fqn, Item item) {
        String pkg = Extractor.getPackage(fqn);
        Map<String, List<Item>> classMap = this.itemMap.get(pkg);
        if (classMap == null) {
            return null;
        }
        List<Item> items = classMap.get(fqn);
        if (items == null) {
            return null;
        }
        for (Item existing : items) {
            if (!existing.equals(item)) continue;
            return existing;
        }
        return null;
    }

    private static Document checkDocument(String pkg, String xml, boolean namespaceAware) {
        try {
            return XmlUtils.parseDocument((String)xml, (boolean)namespaceAware);
        }
        catch (SAXException sax) {
            Extractor.warning("Failed to parse document for package " + pkg + ": " + sax.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void mergeExisting(File file) {
        block4: {
            block5: {
                block3: {
                    if (!file.isDirectory()) break block3;
                    File[] files = file.listFiles();
                    if (files == null) break block4;
                    for (File child : files) {
                        this.mergeExisting(child);
                    }
                    break block4;
                }
                if (!file.isFile()) break block4;
                if (!file.getPath().endsWith(".jar") && !file.getPath().endsWith(".zip")) break block5;
                this.mergeFromJar(file);
                break block4;
            }
            if (!file.getPath().endsWith(".xml")) break block4;
            try {
                String xml = Files.toString((File)file, (Charset)Charsets.UTF_8);
                this.mergeAnnotationsXml(file.getPath(), xml);
            }
            catch (IOException e) {
                Extractor.error("Aborting: I/O problem during transform: " + e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void mergeFromJar(File jar) {
        block12: {
            JarInputStream zis = null;
            FileInputStream fis2333333332 = new FileInputStream(jar);
            zis = new JarInputStream(fis2333333332);
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (entry.getName().endsWith(".xml")) {
                    byte[] bytes = ByteStreams.toByteArray((InputStream)zis);
                    String xml = new String(bytes, Charsets.UTF_8);
                    this.mergeAnnotationsXml(jar.getPath() + ": " + entry, xml);
                }
                entry = zis.getNextEntry();
            }
            try {
                Closeables.close((Closeable)zis, (boolean)true);
            }
            catch (IOException fis2333333332) {}
            break block12;
            catch (IOException e) {
                try {
                    Extractor.error("Aborting: I/O problem during transform: " + e.toString());
                }
                catch (Throwable throwable) {
                    try {
                        Closeables.close(zis, (boolean)true);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    Closeables.close((Closeable)zis, (boolean)true);
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void mergeAnnotationsXml(String path, String xml) {
        block3: {
            try {
                Document document = XmlUtils.parseDocument((String)xml, (boolean)false);
                this.mergeDocument(document);
            }
            catch (Exception e) {
                String message = "Failed to merge " + path + ": " + e.toString();
                if (e instanceof SAXParseException) {
                    SAXParseException spe = (SAXParseException)e;
                    message = "Line " + spe.getLineNumber() + ":" + spe.getColumnNumber() + ": " + message;
                }
                Extractor.error(message);
                if (e instanceof IOException) break block3;
                e.printStackTrace();
            }
        }
    }

    private void mergeDocument(Document document) {
        Pattern XML_SIGNATURE = Pattern.compile("(\\S+) (\\S+|((.*)\\s+)?(\\S+)\\((.*)\\)( \\d+)?)");
        Element root = document.getDocumentElement();
        String rootTag = root.getTagName();
        assert (rootTag.equals("root")) : rootTag;
        for (Element item : Extractor.getChildren(root)) {
            String signature = item.getAttribute("name");
            if (signature == null || signature.equals("null") || !this.hasRelevantAnnotations(item) || (signature = Extractor.unescapeXml(signature)).equals("java.util.Calendar int get(int)") || signature.equals("java.util.Calendar void set(int, int, int) 1") || signature.equals("java.util.Calendar void set(int, int, int, int, int) 1") || signature.equals("java.util.Calendar void set(int, int, int, int, int, int) 1")) continue;
            Matcher matcher = XML_SIGNATURE.matcher(signature);
            if (matcher.matches()) {
                String methodName;
                String containingClass = matcher.group(1);
                if (containingClass == null) {
                    Extractor.warning("Could not find class for " + signature);
                }
                if ((methodName = matcher.group(5)) != null) {
                    String type = matcher.group(4);
                    boolean isConstructor = type == null;
                    String parameters = matcher.group(6);
                    this.mergeMethodOrParameter(item, matcher, containingClass, methodName, type, isConstructor, parameters);
                    continue;
                }
                String fieldName = matcher.group(2);
                this.mergeField(item, containingClass, fieldName);
                continue;
            }
            if (signature.indexOf(32) == -1 && signature.indexOf(46) != -1) continue;
            Extractor.warning("No merge match for signature " + signature);
        }
    }

    private static String unescapeXml(String escaped) {
        String workingString = escaped.replace("&quot;", "\"");
        workingString = workingString.replace("&lt;", "<");
        workingString = workingString.replace("&gt;", ">");
        workingString = workingString.replace("&apos;", "'");
        workingString = workingString.replace("&amp;", "&");
        return workingString;
    }

    private static String escapeXml(String unescaped) {
        return XmlEscapers.xmlAttributeEscaper().escape(unescaped);
    }

    private static boolean hasHistoricData(Element item) {
        for (Node curr = item.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
            if (curr.getNodeType() != 1 || !"annotation".equals(curr.getNodeName())) continue;
            for (Node inner = curr.getFirstChild(); inner != null; inner = inner.getNextSibling()) {
                if (inner.getNodeType() != 1 || !ATTR_VAL.equals(inner.getNodeName()) || !"apis".equals(((Element)inner).getAttribute("name"))) continue;
                return true;
            }
        }
        return false;
    }

    private void mergeField(Element item, String containingClass, String fieldName) {
        if (this.apiFilter != null && !Extractor.hasHistoricData(item) && !this.apiFilter.hasField(containingClass, fieldName)) {
            if (this.isListIgnored()) {
                this.info("Skipping imported element because it is not part of the API file: " + containingClass + "#" + fieldName);
            }
            ++this.filteredCount;
        } else {
            FieldItem fieldItem = new FieldItem(null, containingClass, fieldName, null);
            Item existing = this.findItem(containingClass, fieldItem);
            if (existing != null) {
                this.mergedCount += this.mergeAnnotations(item, existing);
            } else {
                this.addItemUnconditionally(containingClass, fieldItem);
                this.mergedCount += this.addAnnotations(item, (Item)fieldItem);
            }
        }
    }

    private void mergeMethodOrParameter(Element item, Matcher matcher, String containingClass, String methodName, String type, boolean constructor, String parameters) {
        parameters = Extractor.fixParameterString(parameters);
        if (this.apiFilter != null && !Extractor.hasHistoricData(item) && !this.apiFilter.hasMethod(containingClass, methodName, parameters)) {
            if (this.isListIgnored()) {
                this.info("Skipping imported element because it is not part of the API file: " + containingClass + "#" + methodName + "(" + parameters + ")");
            }
            ++this.filteredCount;
            return;
        }
        String argNum = matcher.group(7);
        if (argNum != null) {
            argNum = argNum.trim();
            ParameterItem parameterItem = new ParameterItem(null, containingClass, type, methodName, parameters, constructor, argNum);
            Item existing = this.findItem(containingClass, parameterItem);
            if ("java.util.Calendar".equals(containingClass) && "set".equals(methodName) && Integer.parseInt(argNum) > 0) {
                return;
            }
            if (existing != null) {
                this.mergedCount += this.mergeAnnotations(item, existing);
            } else {
                this.addItemUnconditionally(containingClass, parameterItem);
                this.mergedCount += this.addAnnotations(item, (Item)parameterItem);
            }
        } else {
            MethodItem methodItem = new MethodItem(null, containingClass, type, methodName, parameters, constructor);
            Item existing = this.findItem(containingClass, methodItem);
            if (existing != null) {
                this.mergedCount += this.mergeAnnotations(item, existing);
            } else {
                this.addItemUnconditionally(containingClass, methodItem);
                this.mergedCount += this.addAnnotations(item, (Item)methodItem);
            }
        }
    }

    private static String fixParameterString(String parameters) {
        return parameters.replace("  ", " ").replace(", ", ",").replace("?super", "? super ").replace("?extends", "? extends ");
    }

    private boolean hasRelevantAnnotations(Element item) {
        for (Element annotationElement : Extractor.getChildren(item)) {
            if (!this.isRelevantAnnotation(annotationElement)) continue;
            return true;
        }
        return false;
    }

    private boolean isRelevantAnnotation(Element annotationElement) {
        AnnotationData annotation = this.createAnnotation(annotationElement);
        if (annotation == null) {
            return false;
        }
        if (Extractor.isNullable(annotation.name) || Extractor.isNonNull(annotation.name) || annotation.name.startsWith(ANDROID_ANNOTATIONS_PREFIX) || annotation.name.startsWith("android.support.annotation.")) {
            return true;
        }
        if (annotation.name.equals(IDEA_CONTRACT)) {
            return true;
        }
        if (annotation.name.equals(IDEA_NON_NLS)) {
            return false;
        }
        if (!this.ignoredAnnotations.contains(annotation.name)) {
            this.ignoredAnnotations.add(annotation.name);
            if (this.isListIgnored()) {
                this.info("(Ignoring merge annotation " + annotation.name + ")");
            }
        }
        return false;
    }

    private static List<Element> getChildren(Element element) {
        NodeList itemList = element.getChildNodes();
        int length = itemList.getLength();
        ArrayList<Element> result = new ArrayList<Element>(Math.max(5, length / 2 + 1));
        for (int i = 0; i < length; ++i) {
            Node node = itemList.item(i);
            if (node.getNodeType() != 1) continue;
            result.add((Element)node);
        }
        return result;
    }

    private int addAnnotations(Element itemElement, Item item) {
        int count = 0;
        for (Element annotationElement : Extractor.getChildren(itemElement)) {
            if (!this.isRelevantAnnotation(annotationElement)) continue;
            AnnotationData annotation = this.createAnnotation(annotationElement);
            item.annotations.add(annotation);
            ++count;
        }
        return count;
    }

    private int mergeAnnotations(Element itemElement, Item item) {
        int count = 0;
        block0: for (Element annotationElement : Extractor.getChildren(itemElement)) {
            AnnotationData annotation;
            if (!this.isRelevantAnnotation(annotationElement) || (annotation = this.createAnnotation(annotationElement)) == null) continue;
            boolean haveNullable = false;
            boolean haveNotNull = false;
            for (AnnotationData existing : item.annotations) {
                if (Extractor.isNonNull(existing.name)) {
                    haveNotNull = true;
                }
                if (Extractor.isNullable(existing.name)) {
                    haveNullable = true;
                }
                if (!existing.equals(annotation)) continue;
                continue block0;
            }
            if (Extractor.isNonNull(annotation.name) && haveNullable || Extractor.isNullable(annotation.name) && haveNotNull) {
                Extractor.warning("Found both @Nullable and @NonNull after import for " + item);
                continue;
            }
            item.annotations.add(annotation);
            ++count;
        }
        return count;
    }

    private static boolean isNonNull(String name) {
        return name.equals(IDEA_NOTNULL) || name.equals(ANDROID_NOTNULL) || name.equals(SUPPORT_NOTNULL);
    }

    private static boolean isNullable(String name) {
        return name.equals(IDEA_NULLABLE) || name.equals(ANDROID_NULLABLE) || name.equals(SUPPORT_NULLABLE);
    }

    private AnnotationData createAnnotation(Element annotationElement) {
        AnnotationData annotation;
        String tagName = annotationElement.getTagName();
        assert (tagName.equals("annotation")) : tagName;
        String name = annotationElement.getAttribute("name");
        assert (name != null && !name.isEmpty());
        if (IDEA_MAGIC.equals(name)) {
            boolean flag;
            List<Element> children = Extractor.getChildren(annotationElement);
            assert (children.size() == 1) : children.size();
            Element valueElement = children.get(0);
            String valName = valueElement.getAttribute("name");
            String value = valueElement.getAttribute(ATTR_VAL);
            boolean flagsFromClass = valName.equals("flagsFromClass");
            boolean bl = flag = valName.equals("flags") || flagsFromClass;
            if (valName.equals("valuesFromClass") || flagsFromClass) {
                boolean found = false;
                if (value.endsWith(".class")) {
                    String clsName = value.substring(0, value.length() - ".class".length());
                    StringBuilder sb = new StringBuilder();
                    sb.append('{');
                    Field[] reflectionFields = null;
                    try {
                        Class<?> cls = Class.forName(clsName);
                        reflectionFields = cls.getDeclaredFields();
                    }
                    catch (Exception cls) {
                        // empty catch block
                    }
                    if (this.apiFilter != null) {
                        HashSet fields = this.apiFilter.getDeclaredIntFields(clsName);
                        if ("java.util.zip.ZipEntry".equals(clsName)) {
                            fields = Sets.newHashSet((Object[])new String[]{"STORED", "DEFLATED"});
                        }
                        if (fields != null) {
                            ArrayList sorted = Lists.newArrayList(fields);
                            Collections.sort(sorted);
                            if (reflectionFields != null) {
                                int i;
                                HashMap rank = Maps.newHashMap();
                                int n = sorted.size();
                                for (i = 0; i < n; ++i) {
                                    rank.put(sorted.get(i), reflectionFields.length + i);
                                }
                                n = reflectionFields.length;
                                for (i = 0; i < n; ++i) {
                                    rank.put(reflectionFields[i].getName(), i);
                                }
                                sorted.sort((o1, o2) -> {
                                    int rank2;
                                    int rank1 = (Integer)rank.get(o1);
                                    int delta = rank1 - (rank2 = ((Integer)rank.get(o2)).intValue());
                                    if (delta != 0) {
                                        return delta;
                                    }
                                    return o1.compareTo((String)o2);
                                });
                            }
                            boolean first = true;
                            for (String field : sorted) {
                                if (first) {
                                    first = false;
                                } else {
                                    sb.append(',').append(' ');
                                }
                                sb.append(clsName).append('.').append(field);
                            }
                            found = true;
                        }
                    }
                    if (!found && reflectionFields != null && (this.apiFilter == null || this.apiFilter.hasClass(clsName))) {
                        boolean first = true;
                        for (Field field : reflectionFields) {
                            if (field.getType() != Integer.TYPE && field.getType() != Integer.TYPE) continue;
                            if (first) {
                                first = false;
                            } else {
                                sb.append(',').append(' ');
                            }
                            sb.append(clsName).append('.').append(field.getName());
                        }
                    }
                    sb.append('}');
                    value = sb.toString();
                    if (sb.length() > 2) {
                        found = true;
                    }
                }
                if (!found) {
                    return null;
                }
            }
            if (this.apiFilter != null) {
                value = this.removeFiltered(value);
                while (value.contains(", ,")) {
                    value = value.replace(", ,", ",");
                }
                if (value.startsWith(", ")) {
                    value = value.substring(2);
                }
            }
            annotation = new AnnotationData(valName.equals("stringValues") ? "android.support.annotation.StringDef" : "android.support.annotation.IntDef", new String[]{"value", value, flag ? "flag" : null, flag ? "true" : null});
        } else if ("android.support.annotation.StringDef".equals(name) || ANDROID_STRING_DEF.equals(name) || "android.support.annotation.IntDef".equals(name) || ANDROID_INT_DEF.equals(name)) {
            List<Element> children = Extractor.getChildren(annotationElement);
            Element valueElement = children.get(0);
            String valName = valueElement.getAttribute("name");
            assert ("value".equals(valName));
            String value = valueElement.getAttribute(ATTR_VAL);
            boolean flag = false;
            if (children.size() == 2) {
                valueElement = children.get(1);
                assert ("flag".equals(valueElement.getAttribute("name")));
                flag = "true".equals(valueElement.getAttribute(ATTR_VAL));
            }
            boolean intDef = "android.support.annotation.IntDef".equals(name) || ANDROID_INT_DEF.equals(name);
            annotation = new AnnotationData(intDef ? "android.support.annotation.IntDef" : "android.support.annotation.StringDef", new String[]{"value", value, flag ? "flag" : null, flag ? "true" : null});
        } else if (IDEA_CONTRACT.equals(name)) {
            List<Element> children = Extractor.getChildren(annotationElement);
            Element valueElement = children.get(0);
            String value = valueElement.getAttribute(ATTR_VAL);
            String pure = valueElement.getAttribute(ATTR_PURE);
            annotation = pure != null && !pure.isEmpty() ? new AnnotationData(name, new String[]{"value", value, ATTR_PURE, pure}) : new AnnotationData(name, new String[]{"value", value});
        } else if (Extractor.isNonNull(name)) {
            annotation = new AnnotationData(SUPPORT_NOTNULL);
        } else if (Extractor.isNullable(name)) {
            if (IDEA_NULLABLE.equals(name)) {
                return null;
            }
            annotation = new AnnotationData(SUPPORT_NULLABLE);
        } else {
            List<Element> children = Extractor.getChildren(annotationElement);
            if (children.isEmpty()) {
                return new AnnotationData(name);
            }
            ArrayList attributeStrings = Lists.newArrayList();
            for (Element valueElement : children) {
                attributeStrings.add(valueElement.getAttribute("name"));
                attributeStrings.add(valueElement.getAttribute(ATTR_VAL));
            }
            annotation = new AnnotationData(name, attributeStrings.toArray(new String[attributeStrings.size()]));
        }
        return annotation;
    }

    private String removeFiltered(String value) {
        assert (this.apiFilter != null);
        if (value.startsWith("{")) {
            value = value.substring(1);
        }
        if (value.endsWith("}")) {
            value = value.substring(0, value.length() - 1);
        }
        value = value.trim();
        StringBuilder sb = new StringBuilder(value.length());
        sb.append('{');
        for (String fqn : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)value)) {
            String field;
            if ((fqn = Extractor.unescapeXml(fqn)).startsWith("\"")) continue;
            int index = fqn.lastIndexOf(46);
            String cls = fqn.substring(0, index);
            if (this.apiFilter.hasField(cls, field = fqn.substring(index + 1))) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                sb.append(fqn);
                continue;
            }
            if (!this.isListIgnored()) continue;
            this.info("Skipping constant from typedef because it is not part of the SDK: " + fqn);
        }
        sb.append('}');
        return Extractor.escapeXml(sb.toString());
    }

    private static String getPackage(String fqn) {
        int index = 0;
        int last = 0;
        while ((index = fqn.indexOf(46, index)) != -1) {
            char next;
            last = index;
            if (index < fqn.length() - 1 && Character.isUpperCase(next = fqn.charAt(index + 1))) break;
            ++index;
        }
        return fqn.substring(0, last);
    }

    public void setListIgnored(boolean listIgnored) {
        this.listIgnored = listIgnored;
    }

    public boolean isListIgnored() {
        return this.listIgnored;
    }

    public AnnotationData createData(String name, PsiAnnotation annotation) {
        PsiNameValuePair[] pairs = annotation.getParameterList().getAttributes();
        if (pairs.length == 0) {
            return new AnnotationData(name);
        }
        return new AnnotationData(name, pairs);
    }

    private static boolean appendLiteralValue(StringBuilder sb, Object literalValue) {
        if (literalValue instanceof Number || literalValue instanceof Boolean) {
            sb.append(literalValue.toString());
            return true;
        }
        if (literalValue instanceof String || literalValue instanceof Character) {
            sb.append('\"');
            XmlUtils.appendXmlAttributeValue((StringBuilder)sb, (String)literalValue.toString());
            sb.append('\"');
            return true;
        }
        return false;
    }

    private static String getReturnType(PsiMethod method) {
        if (method.isConstructor()) {
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null) {
                return containingClass.getName();
            }
        } else {
            PsiType returnType = method.getReturnType();
            if (returnType != null) {
                return returnType.getCanonicalText();
            }
        }
        return null;
    }

    private static String getVariableType(PsiVariable variable) {
        PsiType type = variable.getType();
        return type.getCanonicalText();
    }

    private static String getMethodName(PsiMethod method) {
        if (method.isConstructor()) {
            return method.getName();
        }
        return method.getName();
    }

    private static String getParameterList(PsiMethod method) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        PsiParameterList parameterList = method.getParameterList();
        for (PsiParameter parameter : parameterList.getParameters()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            PsiType type = parameter.getType();
            sb.append(type.getCanonicalText());
        }
        return sb.toString();
    }

    private static boolean javadocContainsHide(PsiDocComment docComment) {
        String text;
        return docComment != null && (text = docComment.getText()).contains("@hide");
    }

    public static boolean isHiddenTypeDef(PsiClass declaration) {
        PsiModifierList modifierList = declaration.getModifierList();
        return modifierList == null || !modifierList.hasModifierProperty("public");
    }

    private class AnnotationVisitor
    extends JavaRecursiveElementVisitor {
        private List<String> privateTypedefs = Lists.newArrayList();
        private final boolean requireHide;
        private final boolean requireSourceRetention;

        public AnnotationVisitor(boolean requireHide, boolean requireSourceRetention) {
            this.requireHide = requireHide;
            this.requireSourceRetention = requireSourceRetention;
        }

        public List<String> getPrivateTypedefClasses() {
            return this.privateTypedefs;
        }

        public void visitMethod(PsiMethod method) {
            String fqn;
            MethodItem item;
            PsiModifierList modifierList = method.getModifierList();
            PsiClass containingClass = method.getContainingClass();
            if (Extractor.this.hasRelevantAnnotations(modifierList) && (item = MethodItem.create(containingClass, fqn = Extractor.this.getFqn(containingClass), method)) != null) {
                Extractor.this.addItem(fqn, item);
                boolean skipReturnAnnotations = false;
                if ("findViewById".equals(item.getName())) {
                    skipReturnAnnotations = true;
                    if (item.annotations.isEmpty()) {
                        Extractor.this.removeItem(fqn, item);
                    }
                }
                if (!skipReturnAnnotations) {
                    Extractor.this.addAnnotations(modifierList, item);
                }
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            int index = 0;
            for (PsiParameter parameter : parameters) {
                String fqn2;
                ParameterItem item2;
                PsiModifierList parameterModifierList = parameter.getModifierList();
                if (Extractor.this.hasRelevantAnnotations(parameterModifierList) && (item2 = ParameterItem.create(containingClass, fqn2 = Extractor.this.getFqn(containingClass), method, parameter, index)) != null) {
                    Extractor.this.addItem(fqn2, item2);
                    Extractor.this.addAnnotations(parameterModifierList, item2);
                }
                ++index;
            }
        }

        public void visitField(PsiField field) {
            String fqn;
            FieldItem item;
            PsiClass containingClass;
            PsiModifierList modifierList = field.getModifierList();
            if (Extractor.this.hasRelevantAnnotations(modifierList) && (containingClass = field.getContainingClass()) != null && (item = FieldItem.create(containingClass, fqn = Extractor.this.getFqn(containingClass), field)) != null) {
                Extractor.this.addItem(fqn, item);
                Extractor.this.addAnnotations(modifierList, item);
            }
        }

        public void visitClassInitializer(PsiClassInitializer initializer) {
        }

        public void visitImportList(PsiImportList list) {
        }

        public void visitPackageStatement(PsiPackageStatement statement) {
            String fqn;
            PsiModifierList modifierList;
            PsiElement curr = statement.getFirstChild();
            if (curr instanceof PsiModifierList && Extractor.this.hasRelevantAnnotations(modifierList = (PsiModifierList)curr) && (fqn = statement.getPackageName()) != null) {
                PackageItem item = PackageItem.create(fqn);
                Extractor.this.addPackage(fqn, item);
                Extractor.this.addAnnotations(modifierList, item);
            }
        }

        public void visitDocComment(PsiDocComment comment) {
        }

        public void visitClass(PsiClass aClass) {
            String fqn;
            PsiModifierList modifierList;
            super.visitClass(aClass);
            if (aClass instanceof PsiAnonymousClass) {
                return;
            }
            if (aClass.isAnnotationType() && (modifierList = aClass.getModifierList()) != null) {
                for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                    String cls;
                    String fqn2 = annotation.getQualifiedName();
                    if (!Extractor.isNestedAnnotation(fqn2)) continue;
                    if (this.requireHide && !Extractor.javadocContainsHide(aClass.getDocComment())) {
                        Extractor.warning(aClass.getQualifiedName() + ": This typedef annotation should specify @hide in a doc comment");
                    }
                    if (this.requireSourceRetention && !Extractor.hasSourceRetention(aClass)) {
                        Extractor.warning(aClass.getQualifiedName() + ": The typedef annotation should have @Retention(RetentionPolicy.SOURCE)");
                    }
                    if (!Extractor.isHiddenTypeDef(aClass) || this.privateTypedefs.contains(cls = LintUtils.getInternalName((PsiClass)aClass))) break;
                    this.privateTypedefs.add(cls);
                    break;
                }
            }
            if (aClass.isAnnotationType() && Extractor.isHiddenTypeDef(aClass)) {
                return;
            }
            modifierList = aClass.getModifierList();
            if (Extractor.this.hasRelevantAnnotations(modifierList) && (fqn = Extractor.this.getFqn(aClass)) != null) {
                ClassItem item = ClassItem.create(aClass, fqn);
                Extractor.this.addItem(fqn, item);
                Extractor.this.addAnnotations(modifierList, item);
            }
        }
    }

    private static class ParameterItem
    extends MethodItem {
        public final String argIndex;

        private ParameterItem(PsiClass psiClass, String containingClass, String returnType, String methodName, String parameterList, boolean isConstructor, String argIndex) {
            super(psiClass, containingClass, returnType, methodName, parameterList, isConstructor);
            this.argIndex = argIndex;
        }

        static ParameterItem create(PsiClass psiClass, String classFqn, PsiMethod method, PsiParameter parameter, int index) {
            if (classFqn == null) {
                return null;
            }
            String methodName = Extractor.getMethodName(method);
            String returnType = Extractor.getReturnType(method);
            if (methodName == null || returnType == null) {
                return null;
            }
            String parameterList = Extractor.getParameterList(method);
            String argNum = Integer.toString(index);
            return new ParameterItem(psiClass, classFqn, returnType, methodName, parameterList, method.isConstructor(), argNum);
        }

        @Override
        String getSignature() {
            return super.getSignature() + ' ' + this.argIndex;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ParameterItem that = (ParameterItem)o;
            return this.argIndex.equals(that.argIndex);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.argIndex.hashCode();
            return result;
        }

        @Override
        public String toString() {
            return "Parameter #" + this.argIndex + " in " + super.toString();
        }

        @Override
        public String getKeepRule() {
            return "";
        }
    }

    private static class MethodItem
    extends Item {
        public final String methodName;
        public final String parameterList;
        public final String returnType;
        public final boolean isConstructor;

        private MethodItem(PsiClass psiClass, String containingClass, String returnType, String methodName, String parameterList, boolean isConstructor) {
            super(psiClass, containingClass);
            this.returnType = returnType;
            this.methodName = methodName;
            this.parameterList = parameterList;
            this.isConstructor = isConstructor;
        }

        public String getName() {
            return this.methodName;
        }

        static MethodItem create(PsiClass psiClass, String classFqn, PsiMethod declaration) {
            if (classFqn == null) {
                return null;
            }
            String returnType = Extractor.getReturnType(declaration);
            String methodName = Extractor.getMethodName(declaration);
            if (returnType == null) {
                return null;
            }
            String parameterList = Extractor.getParameterList(declaration);
            return new MethodItem(psiClass, classFqn, returnType, methodName, parameterList, declaration.isConstructor());
        }

        @Override
        String getSignature() {
            StringBuilder sb = new StringBuilder(100);
            sb.append(Extractor.escapeXml(this.containingClass));
            sb.append(' ');
            if (this.isConstructor) {
                sb.append(Extractor.escapeXml(this.methodName));
            } else {
                assert (this.returnType != null);
                sb.append(Extractor.escapeXml(this.returnType));
                sb.append(' ');
                sb.append(Extractor.escapeXml(this.methodName));
            }
            sb.append('(');
            int balance = 0;
            int n = this.parameterList.length();
            for (int i = 0; i < n; ++i) {
                char c = this.parameterList.charAt(i);
                if (c == '<') {
                    ++balance;
                    sb.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    --balance;
                    sb.append("&gt;");
                    continue;
                }
                if (c == ',') {
                    sb.append(',');
                    if (balance != 0) continue;
                    sb.append(' ');
                    continue;
                }
                sb.append(c);
            }
            sb.append(')');
            return sb.toString();
        }

        @Override
        boolean isFiltered(ApiDatabase database) {
            return !database.hasMethod(this.containingClass, this.methodName, this.parameterList);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodItem that = (MethodItem)o;
            return this.isConstructor == that.isConstructor && this.containingClass.equals(that.containingClass) && this.methodName.equals(that.methodName) && this.parameterList.equals(that.parameterList);
        }

        public int hashCode() {
            int result = this.methodName.hashCode();
            result = 31 * result + this.containingClass.hashCode();
            result = 31 * result + this.parameterList.hashCode();
            result = 31 * result + (this.returnType != null ? this.returnType.hashCode() : 0);
            result = 31 * result + (this.isConstructor ? 1 : 0);
            return result;
        }

        public String toString() {
            return "Method " + this.containingClass + "#" + this.methodName;
        }

        @Override
        public String getKeepRule() {
            StringBuilder sb = new StringBuilder();
            sb.append("-keep ");
            sb.append(ClassKind.forClass(this.psiClass).getKeepType());
            sb.append(" ");
            sb.append(this.containingClass);
            sb.append(" {\n");
            sb.append("    ");
            if (this.isConstructor) {
                sb.append("<init>");
            } else {
                sb.append(this.returnType);
                sb.append(" ");
                sb.append(this.methodName);
            }
            sb.append("(");
            sb.append(this.parameterList);
            sb.append(")\n");
            sb.append("}\n");
            return sb.toString();
        }

        @Override
        public String getQualifiedClassName() {
            return this.containingClass;
        }
    }

    private static class FieldItem
    extends Item {
        public final String fieldName;
        public final String fieldType;

        private FieldItem(PsiClass psiClass, String containingClass, String fieldName, String fieldType) {
            super(psiClass, containingClass);
            this.fieldName = fieldName;
            this.fieldType = fieldType;
        }

        static FieldItem create(PsiClass psiClass, String classFqn, PsiField field) {
            if (classFqn == null) {
                return null;
            }
            String name = field.getName();
            String type = Extractor.getVariableType((PsiVariable)field);
            if (name != null && type != null) {
                return new FieldItem(psiClass, classFqn, name, type);
            }
            return null;
        }

        @Override
        boolean isFiltered(ApiDatabase database) {
            return !database.hasField(this.containingClass, this.fieldName);
        }

        @Override
        String getSignature() {
            return Extractor.escapeXml(this.containingClass) + ' ' + this.fieldName;
        }

        @Override
        public String getKeepRule() {
            if (this.fieldType == null) {
                return "";
            }
            return "-keep " + ClassKind.forClass(this.psiClass).getKeepType() + " " + this.containingClass + " {\n    " + this.fieldType + " " + this.fieldName + "\n}\n";
        }

        @Override
        public String getQualifiedClassName() {
            return this.containingClass;
        }

        public String toString() {
            return "Field " + this.containingClass + "#" + this.fieldName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldItem that = (FieldItem)o;
            return this.containingClass.equals(that.containingClass) && this.fieldName.equals(that.fieldName);
        }

        public int hashCode() {
            int result = this.fieldName.hashCode();
            result = 31 * result + this.containingClass.hashCode();
            return result;
        }
    }

    private static class PackageItem
    extends Item {
        private PackageItem(String containingClass) {
            super(null, containingClass);
        }

        static PackageItem create(String fqn) {
            return new PackageItem(fqn);
        }

        @Override
        boolean isFiltered(ApiDatabase database) {
            return !database.hasPackage(this.containingClass);
        }

        @Override
        String getSignature() {
            return Extractor.escapeXml(this.containingClass);
        }

        @Override
        public String getKeepRule() {
            return "";
        }

        @Override
        public String getQualifiedClassName() {
            return this.containingClass;
        }

        public String toString() {
            return "Package " + this.containingClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PackageItem that = (PackageItem)o;
            return this.containingClass.equals(that.containingClass);
        }

        public int hashCode() {
            return this.containingClass.hashCode();
        }
    }

    private static class ClassItem
    extends Item {
        private ClassItem(PsiClass psiClass, String containingClass) {
            super(psiClass, containingClass);
        }

        static ClassItem create(PsiClass psiClass, String classFqn) {
            return new ClassItem(psiClass, classFqn);
        }

        @Override
        boolean isFiltered(ApiDatabase database) {
            return !database.hasClass(this.containingClass);
        }

        @Override
        String getSignature() {
            return Extractor.escapeXml(this.containingClass);
        }

        @Override
        public String getKeepRule() {
            return "-keep " + ClassKind.forClass(this.psiClass).getKeepType() + " " + this.containingClass + "\n";
        }

        @Override
        public String getQualifiedClassName() {
            return this.containingClass;
        }

        public String toString() {
            return "Class " + this.containingClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassItem that = (ClassItem)o;
            return this.containingClass.equals(that.containingClass);
        }

        public int hashCode() {
            return this.containingClass.hashCode();
        }
    }

    private static abstract class Item
    implements Comparable<Item> {
        public final String containingClass;
        public final PsiClass psiClass;
        public final List<AnnotationData> annotations = Lists.newArrayList();

        public Item(PsiClass psiClass, String containingClass) {
            this.psiClass = psiClass;
            this.containingClass = containingClass;
        }

        void write(StringPrintWriter writer) {
            if (this.annotations.isEmpty()) {
                return;
            }
            writer.print("  <item name=\"");
            writer.print(this.getSignature());
            writer.println("\">");
            for (AnnotationData annotation : this.annotations) {
                annotation.write(writer);
            }
            writer.print("  </item>");
            writer.println();
        }

        abstract boolean isFiltered(ApiDatabase var1);

        abstract String getSignature();

        @Override
        public int compareTo(Item item) {
            String signature1 = this.getSignature();
            String signature2 = item.getSignature();
            signature1 = signature1.replace('&', '.');
            signature2 = signature2.replace('&', '.');
            return signature1.compareTo(signature2);
        }

        public abstract String getKeepRule();

        public abstract String getQualifiedClassName();
    }

    public static enum ClassKind {
        CLASS,
        INTERFACE,
        ENUM,
        ANNOTATION;


        public static ClassKind forClass(PsiClass declaration) {
            if (declaration == null) {
                return CLASS;
            }
            if (declaration.isEnum()) {
                return ENUM;
            }
            if (declaration.isAnnotationType()) {
                return ANNOTATION;
            }
            if (declaration.isInterface()) {
                return INTERFACE;
            }
            return CLASS;
        }

        public String getKeepType() {
            switch (this) {
                case INTERFACE: {
                    return "interface";
                }
                case ENUM: {
                    return "enum";
                }
            }
            return "class";
        }

        public String toString() {
            return this.getKeepType();
        }
    }

    private class AnnotationData {
        public final String name;
        public String[] attributeStrings;
        public PsiNameValuePair[] attributes;

        private AnnotationData(String name) {
            this.name = name;
        }

        private AnnotationData(String name, PsiNameValuePair[] pairs) {
            this(name);
            this.attributes = pairs;
            assert (this.attributes == null || this.attributes.length > 0);
        }

        private AnnotationData(String name, String[] attributeStrings) {
            this(name);
            this.attributeStrings = attributeStrings;
            assert (attributeStrings != null && attributeStrings.length > 0);
        }

        void write(StringPrintWriter writer) {
            writer.mark();
            writer.print("    <annotation name=\"");
            writer.print(this.name);
            if (this.attributes != null) {
                PsiNameValuePair[] attributes;
                writer.print("\">");
                writer.println();
                if (this.attributes.length > 1 && Extractor.this.sortAnnotations) {
                    Arrays.sort(this.attributes, new Comparator<PsiNameValuePair>(){

                        private String getName(PsiNameValuePair pair) {
                            String name = pair.getName();
                            if (name == null) {
                                return "value";
                            }
                            return name;
                        }

                        private int rank(PsiNameValuePair pair) {
                            return "value".equals(this.getName(pair)) ? -1 : 0;
                        }

                        @Override
                        public int compare(PsiNameValuePair o1, PsiNameValuePair o2) {
                            int r2;
                            int r1 = this.rank(o1);
                            int delta = r1 - (r2 = this.rank(o2));
                            if (delta != 0) {
                                return delta;
                            }
                            return this.getName(o1).compareTo(this.getName(o2));
                        }
                    });
                }
                if ((attributes = this.attributes).length == 1 && this.name.startsWith(Extractor.REQUIRES_PERMISSION) && this.name.length() > Extractor.REQUIRES_PERMISSION.length() && attributes[0].getValue() instanceof PsiAnnotation) {
                    PsiAnnotation annotation = (PsiAnnotation)attributes[0].getValue();
                    attributes = annotation.getParameterList().getAttributes();
                }
                boolean empty = true;
                for (PsiNameValuePair pair : attributes) {
                    String value = this.attributeString(pair.getValue());
                    if (value == null) continue;
                    empty = false;
                    String name = pair.getName();
                    if (name == null) {
                        name = "value";
                    }
                    if ("prefix".equals(name) && "android.support.annotation.IntDef".equals(this.name)) continue;
                    writer.print("      <val name=\"");
                    writer.print(name);
                    writer.print("\" val=\"");
                    writer.print(Extractor.escapeXml(value));
                    writer.println("\" />");
                }
                if (empty) {
                    writer.reset();
                    return;
                }
                writer.println("    </annotation>");
            } else if (this.attributeStrings != null) {
                writer.print("\">");
                writer.println();
                for (int i = 0; i < this.attributeStrings.length; i += 2) {
                    String name = this.attributeStrings[i];
                    String value = this.attributeStrings[i + 1];
                    if (name == null) continue;
                    writer.print("      <val name=\"");
                    writer.print(name);
                    writer.print("\" val=\"");
                    writer.print(Extractor.escapeXml(value));
                    writer.println("\" />");
                }
                writer.println("    </annotation>");
            } else {
                writer.println("\" />");
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotationData that = (AnnotationData)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        private String attributeString(PsiAnnotationMemberValue value) {
            StringBuilder sb = new StringBuilder();
            if (value != null && this.appendExpression(sb, value)) {
                return sb.toString();
            }
            return null;
        }

        private boolean appendExpression(StringBuilder sb, PsiAnnotationMemberValue expression) {
            Object literalValue;
            PsiLiteral literal;
            Object literalValue2;
            if (expression instanceof PsiArrayInitializerMemberValue) {
                sb.append('{');
                PsiArrayInitializerMemberValue initializer = (PsiArrayInitializerMemberValue)expression;
                boolean first = true;
                int initialLength = sb.length();
                for (PsiAnnotationMemberValue e : initializer.getInitializers()) {
                    int length = sb.length();
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    boolean appended = this.appendExpression(sb, e);
                    if (appended) continue;
                    sb.setLength(length);
                    if (length != initialLength) continue;
                    first = true;
                }
                sb.append('}');
                return sb.length() != 2;
            }
            if (expression instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
                PsiElement resolved = referenceExpression.resolve();
                if (resolved instanceof PsiField) {
                    Object value;
                    PsiField field = (PsiField)resolved;
                    if (!this.isInlinedConstant() && Extractor.appendLiteralValue(sb, value = field.computeConstantValue())) {
                        return true;
                    }
                    PsiClass declaringClass = field.getContainingClass();
                    if (declaringClass == null) {
                        Extractor.error("No containing class found for " + field.getName());
                        return false;
                    }
                    String qualifiedName = declaringClass.getQualifiedName();
                    String fieldName = field.getName();
                    if (qualifiedName != null && fieldName != null) {
                        if (Extractor.this.apiFilter != null && !Extractor.this.apiFilter.hasField(qualifiedName, fieldName)) {
                            if (Extractor.this.isListIgnored()) {
                                Extractor.this.info("Filtering out typedef constant " + qualifiedName + "." + fieldName + "");
                            }
                            return false;
                        }
                        sb.append(qualifiedName);
                        sb.append('.');
                        sb.append(fieldName);
                        return true;
                    }
                    return false;
                }
                Extractor.warning("Unexpected reference to " + resolved);
                return false;
            }
            if (expression instanceof PsiLiteral ? Extractor.appendLiteralValue(sb, literalValue2 = (literal = (PsiLiteral)expression).getValue()) : expression instanceof PsiExpression && Extractor.appendLiteralValue(sb, literalValue = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)((PsiExpression)expression), (boolean)false))) {
                return true;
            }
            Extractor.warning("Unexpected annotation expression of type " + expression.getClass() + " and is " + expression);
            return false;
        }

        private boolean isInlinedConstant() {
            return this.name.equals("android.support.annotation.IntDef") || this.name.equals("android.support.annotation.StringDef") || this.name.equals("android.support.annotation.SystemService");
        }
    }

    private static class StringPrintWriter
    extends PrintWriter {
        private final StringWriter stringWriter;
        private int mark;

        private StringPrintWriter(StringWriter stringWriter) {
            super(stringWriter);
            this.stringWriter = stringWriter;
        }

        public void mark() {
            this.flush();
            this.mark = this.stringWriter.getBuffer().length();
        }

        public void reset() {
            this.stringWriter.getBuffer().setLength(this.mark);
        }

        public String getContents() {
            return this.stringWriter.toString();
        }

        public String toString() {
            return this.getContents();
        }

        public static StringPrintWriter create() {
            return new StringPrintWriter(new StringWriter(1000));
        }
    }
}

