/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.transforms.DexMergerTransformCallable;
import com.android.build.gradle.internal.transforms.TransformInputUtil;
import com.android.builder.core.ErrorReporter;
import com.android.builder.dexing.DexMergerTool;
import com.android.builder.dexing.DexingType;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.DexParser;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutput;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import org.gradle.api.file.FileCollection;

public class DexMergerTransform
extends Transform {
    private static final LoggerWrapper logger = LoggerWrapper.getLogger(DexMergerTransform.class);
    private final DexingType dexingType;
    private final FileCollection mainDexListFile;
    private final DexMergerTool dexMerger;
    private final int minSdkVersion;
    private final boolean isDebuggable;
    private final ErrorReporter errorReporter;
    private final ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();

    public DexMergerTransform(DexingType dexingType, FileCollection mainDexListFile, ErrorReporter errorReporter, DexMergerTool dexMerger, int minSdkVersion, boolean isDebuggable) {
        this.dexingType = dexingType;
        this.mainDexListFile = mainDexListFile;
        this.dexMerger = dexMerger;
        this.minSdkVersion = minSdkVersion;
        this.isDebuggable = isDebuggable;
        Preconditions.checkState((dexingType == DexingType.LEGACY_MULTIDEX == (mainDexListFile != null) ? 1 : 0) != 0, (Object)"Main dex list must only be set when in legacy multidex");
        this.errorReporter = errorReporter;
    }

    public String getName() {
        return "dexMerger";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return ImmutableSet.of((Object)((Object)ExtendedContentType.DEX_ARCHIVE));
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return TransformManager.CONTENT_DEX;
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        return TransformManager.SCOPE_FULL_WITH_IR_FOR_DEXING;
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        if (this.mainDexListFile != null) {
            return ImmutableList.of((Object)SecondaryFile.nonIncremental((FileCollection)this.mainDexListFile));
        }
        return ImmutableList.of();
    }

    public Map<String, Object> getParameterInputs() {
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        params.put("dexing-type", this.dexingType.name());
        params.put("dex-merger-tool", this.dexMerger.name());
        return params;
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, IOException, InterruptedException {
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        Preconditions.checkNotNull((Object)outputProvider, (Object)("Missing output object for transform " + this.getName()));
        ParsingProcessOutputHandler outputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)new DexParser(), Message.Kind.ERROR, (ILogger)logger), new ToolOutputParser((PatternAwareOutputParser)new DexParser(), (ILogger)logger), new MessageReceiver[]{this.errorReporter});
        if (!transformInvocation.isIncremental()) {
            outputProvider.deleteAll();
        }
        ProcessOutput output = null;
        try (ProcessOutput ignored = output = outputHandler.createOutput();){
            List<ForkJoinTask<Void>> mergeTasks = this.dexingType == DexingType.NATIVE_MULTIDEX ? this.handleNativeMultiDex(transformInvocation.getInputs(), output, outputProvider, transformInvocation.isIncremental()) : this.handleLegacyAndMonoDex(transformInvocation.getInputs(), output, outputProvider);
            mergeTasks.forEach(ForkJoinTask::join);
        }
        catch (IOException e) {
            throw new TransformException((Throwable)e);
        }
        catch (Exception e) {
            throw new TransformException(Throwables.getRootCause((Throwable)e));
        }
        finally {
            if (output != null) {
                try {
                    outputHandler.handleOutput(output);
                }
                catch (ProcessException processException) {}
            }
        }
    }

    private List<ForkJoinTask<Void>> handleLegacyAndMonoDex(Collection<TransformInput> inputs, ProcessOutput output, TransformOutputProvider outputProvider) throws IOException {
        ImmutableList.Builder dexArchiveBuilder = ImmutableList.builder();
        TransformInputUtil.getDirectories(inputs).stream().map(File::toPath).forEach(arg_0 -> ((ImmutableList.Builder)dexArchiveBuilder).add(arg_0));
        TransformInputUtil.getJarFiles(inputs).stream().map(File::toPath).forEach(arg_0 -> ((ImmutableList.Builder)dexArchiveBuilder).add(arg_0));
        File outputDir = this.getDexOutputLocation(outputProvider, "main", TransformManager.SCOPE_FULL_PROJECT);
        FileUtils.cleanOutputDir((File)outputDir);
        Path mainDexClasses = this.mainDexListFile == null ? null : this.mainDexListFile.getSingleFile().toPath();
        return ImmutableList.of(this.submitForMerging(output, outputDir, (Iterable<Path>)dexArchiveBuilder.build(), mainDexClasses));
    }

    private List<ForkJoinTask<Void>> handleNativeMultiDex(Collection<TransformInput> inputs, ProcessOutput output, TransformOutputProvider outputProvider, boolean isIncremental) throws IOException {
        ImmutableList.Builder subTasks = ImmutableList.builder();
        ArrayListMultimap externalLibs = ArrayListMultimap.create();
        for (TransformInput input : inputs) {
            subTasks.addAll(this.processDirectories(output, outputProvider, isIncremental, input));
            subTasks.addAll(this.processJars(output, outputProvider, isIncremental, input, (Multimap<Status, Path>)externalLibs));
        }
        File externalLibsOutput = this.getDexOutputLocation(outputProvider, "externalLibs", (Set<? super QualifiedContent.Scope>)ImmutableSet.of((Object)QualifiedContent.Scope.EXTERNAL_LIBRARIES));
        if (!isIncremental || externalLibs.containsKey((Object)Status.CHANGED) || externalLibs.containsKey((Object)Status.ADDED) || externalLibs.containsKey((Object)Status.REMOVED)) {
            FileUtils.cleanOutputDir((File)externalLibsOutput);
            Iterable externalLibsToMerge = Iterables.concat((Iterable)externalLibs.get((Object)Status.CHANGED), (Iterable)externalLibs.get((Object)Status.NOTCHANGED), (Iterable)externalLibs.get((Object)Status.ADDED));
            if (!Iterables.isEmpty((Iterable)externalLibsToMerge)) {
                subTasks.add(this.submitForMerging(output, externalLibsOutput, externalLibsToMerge, null));
            }
        }
        return subTasks.build();
    }

    private List<ForkJoinTask<Void>> processJars(ProcessOutput output, TransformOutputProvider outputProvider, boolean isIncremental, TransformInput input, Multimap<Status, Path> externalLibs) throws IOException {
        ImmutableList.Builder subTasks = ImmutableList.builder();
        for (JarInput jarInput : input.getJarInputs()) {
            if (jarInput.getScopes().equals(Collections.singleton(QualifiedContent.Scope.EXTERNAL_LIBRARIES))) {
                externalLibs.put((Object)jarInput.getStatus(), (Object)jarInput.getFile().toPath());
                continue;
            }
            File dexOutput = this.getDexOutputLocation(outputProvider, jarInput.getName(), jarInput.getScopes());
            if (!isIncremental || jarInput.getStatus() != Status.NOTCHANGED) {
                FileUtils.cleanOutputDir((File)dexOutput);
            }
            if (isIncremental && jarInput.getStatus() != Status.ADDED && jarInput.getStatus() != Status.CHANGED) continue;
            subTasks.add(this.submitForMerging(output, dexOutput, (Iterable<Path>)ImmutableList.of((Object)jarInput.getFile().toPath()), null));
        }
        return subTasks.build();
    }

    private List<ForkJoinTask<Void>> processDirectories(ProcessOutput output, TransformOutputProvider outputProvider, boolean isIncremental, TransformInput input) throws IOException {
        ImmutableList.Builder subTasks = ImmutableList.builder();
        for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
            boolean runAgain;
            Path rootFolder = directoryInput.getFile().toPath();
            File dexOutput = this.getDexOutputLocation(outputProvider, directoryInput.getName(), directoryInput.getScopes());
            if (!Files.isDirectory(rootFolder, new LinkOption[0])) {
                FileUtils.deleteDirectoryContents((File)dexOutput);
                continue;
            }
            boolean bl = runAgain = !isIncremental;
            if (!runAgain) {
                Collection statuses = directoryInput.getChangedFiles().values();
                boolean bl2 = runAgain = statuses.contains(Status.ADDED) || statuses.contains(Status.REMOVED) || statuses.contains(Status.CHANGED);
            }
            if (!runAgain) continue;
            FileUtils.cleanOutputDir((File)dexOutput);
            subTasks.add(this.submitForMerging(output, dexOutput, (Iterable<Path>)ImmutableList.of((Object)directoryInput.getFile().toPath()), null));
        }
        return subTasks.build();
    }

    private ForkJoinTask<Void> submitForMerging(ProcessOutput output, File dexOutputDir, Iterable<Path> dexArchives, Path mainDexList) {
        DexMergerTransformCallable callable = new DexMergerTransformCallable(this.dexingType, output, dexOutputDir, dexArchives, mainDexList, this.forkJoinPool, this.dexMerger, this.minSdkVersion, this.isDebuggable);
        return this.forkJoinPool.submit((Callable)callable);
    }

    private File getDexOutputLocation(TransformOutputProvider outputProvider, String name, Set<? super QualifiedContent.Scope> scopes) {
        return outputProvider.getContentLocation(name, this.getOutputTypes(), scopes, Format.DIRECTORY);
    }
}

