/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.annotations;

import com.android.build.gradle.tasks.annotations.ApiDatabase;
import com.android.build.gradle.tasks.annotations.Extractor;
import com.android.tools.lint.LintCoreApplicationEnvironment;
import com.android.tools.lint.LintCoreProjectEnvironment;
import com.android.utils.SdkUtils;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.intellij.core.JavaCoreApplicationEnvironment;
import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiJavaFile;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExtractAnnotationsDriver {
    private static final String SEP_JAVA_SEP = File.separator + "java" + File.separator;
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("package\\s+(.*)\\s*;");

    public static void main(String[] args) throws IOException {
        new ExtractAnnotationsDriver().run(args);
    }

    private static void usage(PrintStream output) {
        output.println("Usage: " + ExtractAnnotationsDriver.class.getSimpleName() + " <flags>");
        output.println(" --sources <paths>       : Source directories to extract annotations from. ");
        output.println("                           Separate paths with " + File.pathSeparator + ", and you can use @ ");
        output.println("                           as a filename prefix to have the filenames fed from a file");
        output.println("--classpath <paths>      : Directories and .jar files to resolve symbols from");
        output.println("--output <zip path>      : The .zip file to write the extracted annotations to, if any");
        output.println("--proguard <path>        : The proguard.cfg file to write the keep rules to, if any");
        output.println();
        output.println("Optional flags:");
        output.println("--merge-zips <paths>     : Existing external annotation files to merge in");
        output.println("--quiet                  : Don't print summary information");
        output.println("--rmtypedefs <folder>    : Remove typedef classes found in the given folder");
        output.println("--allow-missing-types    : Don't fail even if some types can't be resolved");
        output.println("--allow-errors           : Don't fail even if there are some compiler errors");
        output.println("--api-filter <api.txt>   : A framework API definition to restrict included APIs to");
        output.println("--hide-filtered          : If filtering out non-APIs, supply this flag to hide listing matches");
        output.println("--skip-class-retention   : Don't extract annotations that have class retention");
        output.println("--typedef-file <path>    : Write a packaging recipe description to the given file");
        System.exit(-1);
    }

    public void run(String[] args) throws IOException {
        List<Object> classpath = Lists.newArrayList();
        List<Object> sources = Lists.newArrayList();
        List<Object> mergePaths = Lists.newArrayList();
        List apiFilters = null;
        File rmTypeDefs = null;
        boolean verbose = true;
        boolean allowMissingTypes = false;
        boolean allowErrors = false;
        boolean listFiltered = true;
        boolean skipClassRetention = false;
        File output = null;
        File proguard = null;
        File typedefFile = null;
        if (args.length == 1 && "--help".equals(args[0])) {
            ExtractAnnotationsDriver.usage(System.out);
        }
        if (args.length < 2) {
            ExtractAnnotationsDriver.usage(System.err);
        }
        int n = args.length;
        block36: for (int i = 0; i < n; ++i) {
            String flag = args[i];
            switch (flag) {
                case "--quiet": {
                    verbose = false;
                    continue block36;
                }
                case "--allow-missing-types": {
                    allowMissingTypes = true;
                    continue block36;
                }
                case "--allow-errors": {
                    allowErrors = true;
                    continue block36;
                }
                case "--hide-filtered": {
                    listFiltered = false;
                    continue block36;
                }
                case "--skip-class-retention": {
                    skipClassRetention = true;
                    continue block36;
                }
                default: {
                    if (i == n - 1) {
                        ExtractAnnotationsDriver.usage(System.err);
                    }
                    String value = args[i + 1];
                    ++i;
                    switch (flag) {
                        case "--sources": {
                            sources = ExtractAnnotationsDriver.getFiles(value);
                            continue block36;
                        }
                        case "--classpath": {
                            classpath = ExtractAnnotationsDriver.getFiles(value);
                            continue block36;
                        }
                        case "--merge-zips": {
                            mergePaths = ExtractAnnotationsDriver.getFiles(value);
                            continue block36;
                        }
                        case "--output": {
                            output = new File(value);
                            if (output.exists()) {
                                boolean deleted;
                                if (output.isDirectory()) {
                                    ExtractAnnotationsDriver.abort(output + " is a directory");
                                }
                                if (deleted = output.delete()) continue block36;
                                ExtractAnnotationsDriver.abort("Could not delete previous version of " + output);
                                continue block36;
                            }
                            if (output.getParentFile() == null || output.getParentFile().exists()) continue block36;
                            ExtractAnnotationsDriver.abort(output.getParentFile() + " does not exist");
                            continue block36;
                        }
                        case "--proguard": {
                            proguard = new File(value);
                            if (proguard.exists()) {
                                boolean deleted;
                                if (proguard.isDirectory()) {
                                    ExtractAnnotationsDriver.abort(proguard + " is a directory");
                                }
                                if (deleted = proguard.delete()) continue block36;
                                ExtractAnnotationsDriver.abort("Could not delete previous version of " + proguard);
                                continue block36;
                            }
                            if (proguard.getParentFile() == null || proguard.getParentFile().exists()) continue block36;
                            ExtractAnnotationsDriver.abort(proguard.getParentFile() + " does not exist");
                            continue block36;
                        }
                        case "--typedef-file": {
                            typedefFile = new File(value);
                            continue block36;
                        }
                        case "--api-filter": {
                            if (apiFilters == null) {
                                apiFilters = Lists.newArrayList();
                            }
                            for (String path : Splitter.on((String)",").omitEmptyStrings().split((CharSequence)value)) {
                                File apiFilter = new File(path);
                                if (!apiFilter.isFile()) {
                                    String message = apiFilter + " does not exist or is not a file";
                                    ExtractAnnotationsDriver.abort(message);
                                }
                                apiFilters.add(apiFilter);
                            }
                            continue block36;
                        }
                        case "--rmtypedefs": {
                            rmTypeDefs = new File(value);
                            if (rmTypeDefs.isDirectory()) continue block36;
                            ExtractAnnotationsDriver.abort(rmTypeDefs + " is not a directory");
                            continue block36;
                        }
                        default: {
                            System.err.println("Unknown flag " + (String)flag + ": Use --help for usage information");
                        }
                    }
                }
            }
        }
        if (sources.isEmpty()) {
            ExtractAnnotationsDriver.abort("Must specify at least one source path");
        }
        if (classpath.isEmpty()) {
            ExtractAnnotationsDriver.abort("Must specify classpath pointing to at least android.jar or the framework");
        }
        if (output == null && proguard == null) {
            ExtractAnnotationsDriver.abort("Must specify output path with --output or a proguard path with --proguard");
        }
        ApiDatabase database = null;
        if (apiFilters != null && !apiFilters.isEmpty()) {
            try {
                ArrayList lines = Lists.newArrayList();
                for (File file : apiFilters) {
                    lines.addAll(Files.readLines((File)file, (Charset)Charsets.UTF_8));
                }
                database = new ApiDatabase(lines);
            }
            catch (IOException e) {
                ExtractAnnotationsDriver.abort("Could not open API database " + apiFilters + ": " + e.getLocalizedMessage());
            }
        }
        Extractor extractor = new Extractor(database, rmTypeDefs, verbose, !skipClassRetention, true);
        extractor.setListIgnored(listFiltered);
        LintCoreApplicationEnvironment appEnv = LintCoreApplicationEnvironment.get();
        Disposable parentDisposable = Disposer.newDisposable();
        LintCoreProjectEnvironment projectEnvironment = LintCoreProjectEnvironment.create((Disposable)parentDisposable, (JavaCoreApplicationEnvironment)appEnv);
        List<File> sourceRoots = ExtractAnnotationsDriver.findSourceRoots(sources);
        ArrayList joined = Lists.newArrayList(sourceRoots);
        joined.addAll(classpath);
        projectEnvironment.registerPaths((List)joined);
        MockProject project = projectEnvironment.getProject();
        List<PsiJavaFile> units = Extractor.createUnitsInDirectories((Project)project, sources);
        extractor.extractFromProjectSource(units);
        if (mergePaths != null) {
            for (File file : mergePaths) {
                extractor.mergeExisting(file);
            }
        }
        extractor.export(output, proguard);
        if (typedefFile != null) {
            extractor.writeTypedefFile(typedefFile);
        }
        if (rmTypeDefs != null) {
            if (typedefFile != null) {
                Extractor.removeTypedefClasses(rmTypeDefs, typedefFile);
            } else {
                extractor.removeTypedefClasses();
            }
        }
        Disposer.dispose((Disposable)LintCoreApplicationEnvironment.get().getParentDisposable());
    }

    private static List<File> findSourceRoots(List<File> sources) {
        ArrayList roots = Lists.newArrayList();
        for (File sourceFile : sources) {
            if (sourceFile.isDirectory()) {
                if (roots.contains(sourceFile)) continue;
                roots.add(sourceFile);
                continue;
            }
            String path = sourceFile.getPath();
            if (!path.endsWith(".java") && !path.endsWith(".kt")) continue;
            int index = path.indexOf(SEP_JAVA_SEP);
            if (index != -1) {
                File root = new File(path.substring(0, index + SEP_JAVA_SEP.length()));
                if (roots.contains(root)) continue;
                roots.add(root);
                continue;
            }
            try {
                String source = Files.toString((File)sourceFile, (Charset)StandardCharsets.UTF_8);
                Matcher matcher = PACKAGE_PATTERN.matcher(source);
                boolean foundPackage = matcher.find();
                if (!foundPackage) {
                    ExtractAnnotationsDriver.abort("Couldn't find package declaration in " + sourceFile);
                }
                String pkg = matcher.group(1).trim();
                int end = path.lastIndexOf(File.separatorChar);
                if (end == -1) continue;
                String relative = pkg.replace('.', File.separatorChar);
                if (SdkUtils.endsWith((CharSequence)path, (int)end, (CharSequence)relative)) {
                    String rootPath = path.substring(0, end - relative.length());
                    File root = new File(rootPath);
                    if (roots.contains(root)) continue;
                    roots.add(root);
                    continue;
                }
                ExtractAnnotationsDriver.abort("File found in a folder that doesn't appear to match the package declaration: package=" + pkg + " and file path=" + path);
            }
            catch (IOException e) {
                ExtractAnnotationsDriver.abort("Couldn't access " + sourceFile);
            }
        }
        return roots;
    }

    private static void abort(String message) {
        System.err.println(message);
        System.exit(-1);
    }

    private static List<File> getFiles(String value) {
        ArrayList files = Lists.newArrayList();
        Splitter splitter = Splitter.on((char)File.pathSeparatorChar).omitEmptyStrings().trimResults();
        for (String path : splitter.split((CharSequence)value)) {
            File file;
            if (path.startsWith("@")) {
                File sourcePath = new File(path.substring(1));
                if (!sourcePath.exists()) {
                    ExtractAnnotationsDriver.abort(sourcePath + " does not exist");
                }
                try {
                    for (String line : Files.readLines((File)sourcePath, (Charset)Charsets.UTF_8)) {
                        if ((line = line.trim()).isEmpty()) continue;
                        File file2 = new File(line);
                        if (!file2.exists()) {
                            for (String l : Splitter.on((CharMatcher)CharMatcher.whitespace()).split((CharSequence)line)) {
                                if (l.isEmpty()) continue;
                                file2 = new File(l);
                                if (!file2.exists()) {
                                    System.err.println("Warning: Could not find file " + l + " listed in " + sourcePath);
                                }
                                files.add(file2);
                            }
                        }
                        files.add(file2);
                    }
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
            if (!(file = new File(path)).exists()) {
                ExtractAnnotationsDriver.abort(file + " does not exist");
            }
            files.add(file);
        }
        return files;
    }
}

