/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.VariantOutput;
import com.android.build.gradle.internal.ide.BuildOutputSupplier;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.InstantAppOutputScope;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.ide.common.build.ApkInfo;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class BuildOutputsSupplier
implements BuildOutputSupplier<Collection<BuildOutput>> {
    private final List<File> outputFolders;
    private final List<TaskOutputHolder.OutputType> outputTypes;

    public BuildOutputsSupplier(List<TaskOutputHolder.OutputType> outputTypes, List<File> outputFolders) {
        this.outputFolders = outputFolders;
        this.outputTypes = outputTypes;
    }

    @Override
    public Collection<BuildOutput> get() {
        ImmutableList.Builder outputs = ImmutableList.builder();
        this.outputFolders.forEach(outputFolder -> {
            if (!outputFolder.exists()) {
                return;
            }
            Collection<BuildOutput> previous = BuildOutputs.load(this.outputTypes, outputFolder);
            if (previous.isEmpty()) {
                this.outputTypes.forEach(taskOutputType -> {
                    if (taskOutputType == TaskOutputHolder.TaskOutputType.INSTANTAPP_BUNDLE) {
                        BuildOutputsSupplier.processInstantAppFolder(outputFolder, (ImmutableList.Builder<BuildOutput>)outputs);
                    } else {
                        File[] files = outputFolder.listFiles();
                        if (files != null && files.length > 0) {
                            for (File file : files) {
                                BuildOutputsSupplier.processFile(taskOutputType, file, (ImmutableList.Builder<BuildOutput>)outputs);
                            }
                        }
                    }
                });
            } else {
                outputs.addAll(previous);
            }
        });
        return outputs.build();
    }

    @Override
    public File guessOutputFile(String relativeFileName) {
        return this.outputFolders.isEmpty() ? new File(relativeFileName) : new File(this.outputFolders.get(0), relativeFileName);
    }

    private static void processFile(TaskOutputHolder.OutputType taskOutputType, File file, ImmutableList.Builder<BuildOutput> outputs) {
        if (taskOutputType == TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS) {
            if (file.getName().equals("AndroidManifest.xml")) {
                outputs.add((Object)new BuildOutput(taskOutputType, ApkInfo.of((VariantOutput.OutputType)VariantOutput.OutputType.MAIN, (Collection)ImmutableList.of(), (int)0), file));
            }
        } else {
            VariantOutput.OutputType fileOutputType = taskOutputType == TaskOutputHolder.TaskOutputType.AAR || taskOutputType == TaskOutputHolder.TaskOutputType.APK ? VariantOutput.OutputType.MAIN : VariantOutput.OutputType.SPLIT;
            outputs.add((Object)new BuildOutput(taskOutputType, ApkInfo.of((VariantOutput.OutputType)fileOutputType, (Collection)ImmutableList.of(), (int)0), file));
        }
    }

    private static void processInstantAppFolder(File outputFolder, ImmutableList.Builder<BuildOutput> outputs) {
        InstantAppOutputScope instantAppOutputScope = InstantAppOutputScope.load(outputFolder);
        if (instantAppOutputScope != null) {
            outputs.add((Object)new BuildOutput(TaskOutputHolder.TaskOutputType.INSTANTAPP_BUNDLE, ApkInfo.of((VariantOutput.OutputType)VariantOutput.OutputType.MAIN, (Collection)ImmutableList.of(), (int)0), instantAppOutputScope.getInstantAppBundle()));
        }
    }

    public int hashCode() {
        return Objects.hash(this.outputFolders, this.outputTypes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildOutputsSupplier that = (BuildOutputsSupplier)o;
        return Objects.equals(this.outputFolders, that.outputFolders) && Objects.equals(this.outputTypes, that.outputTypes);
    }
}

