/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.gradle.internal.ide.FilterDataImpl;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.ide.common.build.ApkInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.SetMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.file.FileCollection;

public class BuildOutputs {
    public static String persist(Path projectPath, ImmutableList<TaskOutputHolder.OutputType> outputTypes, SetMultimap<TaskOutputHolder.OutputType, BuildOutput> splitOutputs) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(ApkInfo.class, (Object)new ApkInfoAdapter());
        gsonBuilder.registerTypeAdapter(TaskOutputHolder.TaskOutputType.class, (Object)new OutputTypeTypeAdapter());
        gsonBuilder.registerTypeAdapter(TaskOutputHolder.AnchorOutputType.class, (Object)new OutputTypeTypeAdapter());
        Gson gson = gsonBuilder.create();
        List buildOutputs = outputTypes.stream().map(arg_0 -> splitOutputs.get(arg_0)).flatMap(Collection::stream).map(buildOutput -> new BuildOutput(buildOutput.getType(), buildOutput.getApkInfo(), projectPath.relativize(buildOutput.getOutputPath()), buildOutput.getProperties())).collect(Collectors.toList());
        return gson.toJson(buildOutputs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection<BuildOutput> load(File folder) {
        File metadataFile = BuildOutputs.getMetadataFileIfPresent(folder);
        if (metadataFile == null) return ImmutableList.of();
        if (!metadataFile.exists()) {
            return ImmutableList.of();
        }
        try (FileReader reader = new FileReader(metadataFile);){
            Collection<BuildOutput> collection = BuildOutputs.load(metadataFile.getParentFile().toPath(), reader);
            return collection;
        }
        catch (IOException e) {
            return ImmutableList.of();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection<BuildOutput> load(FileCollection fileCollection) {
        File metadataFile = BuildOutputs.getMetadataFileIfPresent(fileCollection);
        if (metadataFile == null) return ImmutableList.of();
        if (!metadataFile.exists()) {
            return ImmutableList.of();
        }
        try (FileReader reader = new FileReader(metadataFile);){
            Collection<BuildOutput> collection = BuildOutputs.load(metadataFile.getParentFile().toPath(), reader);
            return collection;
        }
        catch (IOException e) {
            return ImmutableList.of();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection<BuildOutput> load(Collection<TaskOutputHolder.OutputType> types, File folder) {
        File metadataFile = BuildOutputs.getMetadataFileIfPresent(folder);
        if (metadataFile == null) return ImmutableList.of();
        if (!metadataFile.exists()) {
            return ImmutableList.of();
        }
        try (FileReader reader = new FileReader(metadataFile);){
            Collection<BuildOutput> collection = BuildOutputs.load(folder.toPath(), types, reader);
            return collection;
        }
        catch (IOException e) {
            return ImmutableList.of();
        }
    }

    public static Collection<BuildOutput> load(TaskOutputHolder.OutputType type, File folder) {
        return BuildOutputs.load((Collection<TaskOutputHolder.OutputType>)ImmutableList.of((Object)type), folder);
    }

    public static Collection<BuildOutput> load(TaskOutputHolder.OutputType type, FileCollection fileCollection) {
        return BuildOutputs.load((Collection<TaskOutputHolder.OutputType>)ImmutableList.of((Object)type), fileCollection);
    }

    static Collection<BuildOutput> load(Path projectPath, Collection<TaskOutputHolder.OutputType> outputTypes, Reader reader) {
        return BuildOutputs.load(projectPath, reader).stream().filter(splitOutput -> outputTypes.contains(splitOutput.getType())).collect(Collectors.toList());
    }

    private static File getMetadataFileIfPresent(FileCollection fileCollection) {
        for (File file : fileCollection.getAsFileTree().getFiles()) {
            if (!file.getName().equals("output.json")) continue;
            return file;
        }
        return null;
    }

    public static File getMetadataFile(File folder) {
        return new File(folder, "output.json");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Collection<BuildOutput> load(Collection<TaskOutputHolder.OutputType> outputTypes, FileCollection fileCollection) {
        File metadataFile = BuildOutputs.getMetadataFileIfPresent(fileCollection);
        if (metadataFile == null) return ImmutableList.of();
        if (!metadataFile.exists()) {
            return ImmutableList.of();
        }
        try (FileReader reader = new FileReader(metadataFile);){
            Collection<BuildOutput> collection = BuildOutputs.load(metadataFile.getParentFile().toPath(), outputTypes, reader);
            return collection;
        }
        catch (IOException e) {
            return ImmutableList.of();
        }
    }

    private static File getMetadataFileIfPresent(File folder) {
        File outputFile = BuildOutputs.getMetadataFile(folder);
        return outputFile.exists() ? outputFile : null;
    }

    private static Collection<BuildOutput> load(Path projectPath, Reader reader) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(ApkInfo.class, (Object)new ApkInfoAdapter());
        gsonBuilder.registerTypeAdapter(TaskOutputHolder.OutputType.class, (Object)new OutputTypeTypeAdapter());
        Gson gson = gsonBuilder.create();
        Type recordType = new TypeToken<List<BuildOutput>>(){}.getType();
        Collection buildOutputs = (Collection)gson.fromJson(reader, recordType);
        return buildOutputs.stream().map(buildOutput -> new BuildOutput(buildOutput.getType(), buildOutput.getApkInfo(), projectPath.resolve(buildOutput.getOutputPath()), buildOutput.getProperties())).collect(Collectors.toList());
    }

    static class OutputTypeTypeAdapter
    extends TypeAdapter<TaskOutputHolder.OutputType> {
        OutputTypeTypeAdapter() {
        }

        public void write(JsonWriter out, TaskOutputHolder.OutputType value) throws IOException {
            out.beginObject();
            out.name("type").value(value.name());
            out.endObject();
        }

        public TaskOutputHolder.OutputType read(JsonReader in) throws IOException {
            Enum outputType;
            in.beginObject();
            if (!in.nextName().endsWith("type")) {
                throw new IOException("Invalid format");
            }
            String nextString = in.nextString();
            try {
                outputType = TaskOutputHolder.TaskOutputType.valueOf(nextString);
            }
            catch (IllegalArgumentException e) {
                outputType = TaskOutputHolder.AnchorOutputType.valueOf(nextString);
            }
            in.endObject();
            return outputType;
        }
    }

    static class ApkInfoAdapter
    extends TypeAdapter<ApkInfo> {
        ApkInfoAdapter() {
        }

        public void write(JsonWriter out, ApkInfo value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("type").value(value.getType().toString());
            out.name("splits").beginArray();
            for (FilterData filter : value.getFilters()) {
                out.beginObject();
                out.name("filterType").value(filter.getFilterType());
                out.name("value").value(filter.getIdentifier());
                out.endObject();
            }
            out.endArray();
            out.name("versionCode").value((long)value.getVersionCode());
            out.endObject();
        }

        public ApkInfo read(JsonReader in) throws IOException {
            in.beginObject();
            String outputType = null;
            ImmutableList.Builder filters = ImmutableList.builder();
            int versionCode = 0;
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "type": {
                        outputType = in.nextString();
                        break;
                    }
                    case "splits": {
                        ApkInfoAdapter.readFilters(in, (ImmutableList.Builder<FilterData>)filters);
                        break;
                    }
                    case "versionCode": {
                        versionCode = in.nextInt();
                    }
                }
            }
            in.endObject();
            return ApkInfo.of((VariantOutput.OutputType)VariantOutput.OutputType.valueOf(outputType), (Collection)filters.build(), (int)versionCode);
        }

        private static void readFilters(JsonReader in, ImmutableList.Builder<FilterData> filters) throws IOException {
            in.beginArray();
            while (in.hasNext()) {
                in.beginObject();
                VariantOutput.FilterType filterType = null;
                String value = null;
                while (in.hasNext()) {
                    switch (in.nextName()) {
                        case "filterType": {
                            filterType = VariantOutput.FilterType.valueOf((String)in.nextString());
                            break;
                        }
                        case "value": {
                            value = in.nextString();
                        }
                    }
                }
                if (filterType != null && value != null) {
                    filters.add((Object)new FilterDataImpl(filterType, value));
                }
                in.endObject();
            }
            in.endArray();
        }
    }
}

