/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.actions;

import com.android.build.gradle.internal.actions.AttributeValue;
import com.android.build.gradle.internal.actions.CustomClassVisitor;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/actions/AttrExtractor;", "Ljava/lang/Runnable;", "Ljava/io/Serializable;", "inputFile", "Ljava/io/File;", "outputFile", "(Ljava/io/File;Ljava/io/File;)V", "getInputFile", "()Ljava/io/File;", "getOutputFile", "run", "", "gradle-core_main"})
public final class AttrExtractor
implements Runnable,
Serializable {
    @NotNull
    private final File inputFile;
    @NotNull
    private final File outputFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Closeable closeable = new ZipFile(this.inputFile);
        boolean bl = false;
        try {
            List<AttributeValue> result;
            Object zip = (ZipFile)closeable;
            ZipEntry entry = ((ZipFile)zip).getEntry("android/R$attr.class");
            if (entry != null) {
                InputStream inputStream = ((ZipFile)zip).getInputStream(entry);
                if (inputStream == null) {
                    Intrinsics.throwNpe();
                }
                InputStream stream = inputStream;
                CustomClassVisitor customClassVisitor = new CustomClassVisitor();
                new ClassReader(stream).accept((ClassVisitor)customClassVisitor, 0);
                result = customClassVisitor.getAttributes();
            } else {
                result = null;
            }
            zip = result;
        }
        catch (Exception zip) {
            bl = true;
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw (Throwable)zip;
        }
        finally {
            if (!bl) {
                closeable.close();
            }
        }
        Object attributes = zip;
        closeable = new FileWriter(this.outputFile);
        bl = false;
        try {
            FileWriter writer = (FileWriter)closeable;
            if (attributes != null) {
                Iterator iterator = attributes.iterator();
                while (iterator.hasNext()) {
                    String string;
                    AttributeValue attributeValue = (AttributeValue)iterator.next();
                    String name = attributeValue.component1();
                    int value = attributeValue.component2();
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string2 = "%08x";
                    Object[] objectArray = new Object[]{value};
                    StringBuilder stringBuilder = new StringBuilder().append("int attr ").append(name).append(" 0x");
                    FileWriter fileWriter = writer;
                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                    fileWriter.write(stringBuilder.append(string).append("\n").toString());
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception exception) {
            bl = true;
            try {
                closeable.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (!bl) {
                closeable.close();
            }
        }
    }

    @NotNull
    public final File getInputFile() {
        return this.inputFile;
    }

    @NotNull
    public final File getOutputFile() {
        return this.outputFile;
    }

    @Inject
    public AttrExtractor(@NotNull File inputFile, @NotNull File outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)inputFile, (String)"inputFile");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        this.inputFile = inputFile;
        this.outputFile = outputFile;
    }
}

