/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.builder.core.VariantType;
import java.util.function.Supplier;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;

public class VariantDimensionData {
    private final DefaultAndroidSourceSet sourceSet;
    private final DefaultAndroidSourceSet androidTestSourceSet;
    private final DefaultAndroidSourceSet unitTestSourceSet;

    public VariantDimensionData(DefaultAndroidSourceSet sourceSet, DefaultAndroidSourceSet androidTestSourceSet, DefaultAndroidSourceSet unitTestSourceSet, Project project) {
        this.sourceSet = sourceSet;
        this.androidTestSourceSet = androidTestSourceSet;
        this.unitTestSourceSet = unitTestSourceSet;
        ConfigurationContainer configurations = project.getConfigurations();
        if (androidTestSourceSet != null) {
            VariantDimensionData.makeTestExtendMain(sourceSet, androidTestSourceSet, configurations);
        }
        if (unitTestSourceSet != null) {
            VariantDimensionData.makeTestExtendMain(sourceSet, unitTestSourceSet, configurations);
        }
    }

    public DefaultAndroidSourceSet getSourceSet() {
        return this.sourceSet;
    }

    public DefaultAndroidSourceSet getTestSourceSet(VariantType type) {
        switch (type) {
            case ANDROID_TEST: {
                return this.androidTestSourceSet;
            }
            case UNIT_TEST: {
                return this.unitTestSourceSet;
            }
        }
        throw VariantDimensionData.unknownTestType(type);
    }

    public static void makeTestExtendMain(DefaultAndroidSourceSet mainSourceSet, DefaultAndroidSourceSet testSourceSet, ConfigurationContainer configurations) {
        VariantDimensionData.linkConfiguration(configurations, mainSourceSet::getImplementationConfigurationName, testSourceSet::getImplementationConfigurationName);
        VariantDimensionData.linkConfiguration(configurations, mainSourceSet::getRuntimeOnlyConfigurationName, testSourceSet::getRuntimeOnlyConfigurationName);
    }

    private static void linkConfiguration(ConfigurationContainer configurations, Supplier<String> main, Supplier<String> test) {
        configurations.getByName(test.get()).extendsFrom(new Configuration[]{configurations.getByName(main.get())});
    }

    private static RuntimeException unknownTestType(VariantType type) {
        throw new IllegalArgumentException(String.format("Unknown test variant type %s", type));
    }
}

