/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.featuresplit;

import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclaration;
import java.io.File;
import java.io.IOException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class FeatureSplitDeclarationWriterTask
extends BaseTask {
    @Input
    String uniqueIdentifier;
    @OutputDirectory
    File outputDirectory;

    @TaskAction
    public void fullTaskAction() throws IOException {
        FeatureSplitDeclaration declaration = new FeatureSplitDeclaration(this.uniqueIdentifier);
        declaration.save(this.outputDirectory);
    }

    public static class ConfigAction
    implements TaskConfigAction<FeatureSplitDeclarationWriterTask> {
        private final VariantScope variantScope;
        private final File outputDirectory;

        public ConfigAction(VariantScope variantScope, File outputDirectory) {
            this.variantScope = variantScope;
            this.outputDirectory = outputDirectory;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("feature", "Writer");
        }

        @Override
        public Class<FeatureSplitDeclarationWriterTask> getType() {
            return FeatureSplitDeclarationWriterTask.class;
        }

        @Override
        public void execute(FeatureSplitDeclarationWriterTask task) {
            task.setVariantName(this.variantScope.getFullVariantName());
            task.uniqueIdentifier = this.variantScope.getGlobalScope().getProject().getPath();
            task.outputDirectory = this.outputDirectory;
        }
    }
}

