/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.incremental.DexPackagingPolicy;
import com.android.build.gradle.internal.incremental.FileType;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.PackagingScope;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.tasks.PackageAndroidArtifact;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.utils.FileCache;
import com.google.wireless.android.sdk.stats.GradleBuildProjectMetrics;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Internal;

public class PackageApplication
extends PackageAndroidArtifact {
    TaskOutputHolder.TaskOutputType expectedOutputType;

    @Override
    @Internal
    protected TaskOutputHolder.TaskOutputType getTaskOutputType() {
        return this.expectedOutputType;
    }

    @Override
    @Internal
    protected boolean isIncremental() {
        return true;
    }

    @Override
    void recordMetrics(File apkOutputFile, File resourcesApFile) {
        Long resourcesApSize;
        long metricsStartTime = System.nanoTime();
        GradleBuildProjectMetrics.Builder metrics = GradleBuildProjectMetrics.newBuilder();
        Long apkSize = PackageApplication.getSize(apkOutputFile);
        if (apkSize != null) {
            metrics.setApkSize(apkSize.longValue());
        }
        if ((resourcesApSize = PackageApplication.getSize(resourcesApFile)) != null) {
            metrics.setResourcesApSize(resourcesApSize.longValue());
        }
        metrics.setMetricsTimeNs(System.nanoTime() - metricsStartTime);
        ProcessProfileWriter.getProject((String)this.getProject().getPath()).setMetrics(metrics);
    }

    @Internal
    private static Long getSize(File file) {
        if (file == null) {
            return null;
        }
        try {
            return Files.size(file.toPath());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static class InstantRunResourcesConfigAction
    extends PackageAndroidArtifact.ConfigAction<PackageApplication> {
        private final File mOutputFile;

        public InstantRunResourcesConfigAction(File outputFile, PackagingScope scope, InstantRunPatchingPolicy patchingPolicy, TaskOutputHolder.TaskOutputType inputResourceFilesType, FileCollection resourceFiles, FileCollection manifests, TaskOutputHolder.TaskOutputType manifestType, FileCache fileCache, OutputScope outputScope) {
            super(scope, outputFile.getParentFile(), patchingPolicy, inputResourceFilesType, resourceFiles, manifests, manifestType, fileCache, outputScope);
            this.mOutputFile = outputFile;
        }

        @Override
        public String getName() {
            return this.packagingScope.getTaskName("packageInstantRunResources");
        }

        @Override
        public Class<PackageApplication> getType() {
            return PackageApplication.class;
        }

        @Override
        protected void configure(PackageApplication packageApplication) {
            packageApplication.expectedOutputType = TaskOutputHolder.TaskOutputType.INSTANT_RUN_PACKAGED_RESOURCES;
            packageApplication.instantRunFileType = FileType.RESOURCES;
            packageApplication.dexPackagingPolicy = DexPackagingPolicy.STANDARD;
            ConfigurableFileCollection emptyCollection = this.packagingScope.getProject().files(new Object[0]);
            packageApplication.dexFolders = emptyCollection;
            packageApplication.jniFolders = emptyCollection;
            packageApplication.javaResourceFiles = emptyCollection;
            packageApplication.setSigningConfig(null);
            packageApplication.outputFileProvider = split -> this.mOutputFile;
        }
    }

    public static class StandardConfigAction
    extends PackageAndroidArtifact.ConfigAction<PackageApplication> {
        private final TaskOutputHolder.TaskOutputType expectedOutputType;

        public StandardConfigAction(PackagingScope packagingScope, File outputDirectory, InstantRunPatchingPolicy patchingPolicy, TaskOutputHolder.TaskOutputType inputResourceFilesType, FileCollection resourceFiles, FileCollection manifests, TaskOutputHolder.TaskOutputType manifestType, OutputScope outputScope, FileCache fileCache, TaskOutputHolder.TaskOutputType expectedOutputType) {
            super(packagingScope, outputDirectory, patchingPolicy, inputResourceFilesType, resourceFiles, manifests, manifestType, fileCache, outputScope);
            this.expectedOutputType = expectedOutputType;
        }

        @Override
        public String getName() {
            return this.packagingScope.getTaskName("package");
        }

        @Override
        public Class<PackageApplication> getType() {
            return PackageApplication.class;
        }

        @Override
        protected void configure(PackageApplication task) {
            super.configure(task);
            task.expectedOutputType = this.expectedOutputType;
        }
    }
}

