/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.annotations;

import com.android.build.gradle.tasks.annotations.Extractor;
import com.android.builder.packaging.JarMerger;
import com.google.common.base.Charsets;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class TypedefRemover
implements JarMerger.Transformer {
    private final Extractor mExtractor;
    private final boolean mQuiet;
    private final boolean mVerbose;
    private final boolean mDryRun;
    private Set<String> mAnnotationNames = Sets.newHashSet();
    private Set<String> mAnnotationClassFiles = Sets.newHashSet();
    private Set<String> mAnnotationOuterClassFiles = Sets.newHashSet();

    public TypedefRemover(Extractor extractor, boolean quiet, boolean verbose, boolean dryRun) {
        this.mExtractor = extractor;
        this.mQuiet = quiet;
        this.mVerbose = verbose;
        this.mDryRun = dryRun;
    }

    public TypedefRemover() {
        this(null, true, false, false);
    }

    private void info(String message) {
        if (this.mExtractor != null) {
            this.mExtractor.info(message);
        } else {
            System.out.println(message);
        }
    }

    public TypedefRemover setTypedefFile(File file) {
        try {
            for (String line : Files.readLines((File)file, (Charset)Charsets.UTF_8)) {
                if (!line.startsWith("D ")) continue;
                String clz = line.substring(2).trim();
                this.addTypeDef(clz);
            }
        }
        catch (IOException e) {
            Extractor.error("Could not read " + file + ": " + e.getLocalizedMessage());
        }
        return this;
    }

    public InputStream filter(String path, InputStream input) {
        if (this.mAnnotationClassFiles.contains(path)) {
            return null;
        }
        if (!this.mAnnotationOuterClassFiles.contains(path)) {
            return input;
        }
        try {
            ClassReader reader = new ClassReader(input);
            byte[] rewritten = this.rewriteOuterClass(reader);
            return new ByteArrayInputStream(rewritten);
        }
        catch (IOException ioe) {
            Extractor.error("Could not process " + path + ": " + ioe.getLocalizedMessage());
            return input;
        }
    }

    public void removeFromTypedefFile(File classDir, File file) {
        this.setTypedefFile(file);
        this.remove(classDir, Collections.emptyList());
    }

    public void remove(File classDir, List<String> owners) {
        if (!this.mQuiet) {
            this.info("Deleting @IntDef and @StringDef annotation class files");
        }
        for (String owner : owners) {
            this.addTypeDef(owner);
        }
        this.rewriteOuterClasses(classDir);
        this.deleteAnnotationClasses(classDir);
    }

    private void addTypeDef(String owner) {
        String outer;
        this.mAnnotationClassFiles.add(owner + ".class");
        this.mAnnotationNames.add(owner);
        int index = owner.lastIndexOf(36);
        if (index != -1 && !this.mAnnotationOuterClassFiles.contains(outer = owner.substring(0, index) + ".class")) {
            this.mAnnotationOuterClassFiles.add(outer);
        }
    }

    private void rewriteOuterClasses(File classDir) {
        for (String relative : this.mAnnotationOuterClassFiles) {
            byte[] bytes;
            File file = new File(classDir, relative.replace('/', File.separatorChar));
            if (!file.isFile()) {
                Extractor.error("Warning: Could not find outer class " + file + " for typedef");
                continue;
            }
            try {
                bytes = Files.toByteArray((File)file);
            }
            catch (IOException e) {
                Extractor.error("Could not read " + file + ": " + e.getLocalizedMessage());
                continue;
            }
            ClassReader reader = new ClassReader(bytes);
            byte[] rewritten = this.rewriteOuterClass(reader);
            try {
                Files.write((byte[])rewritten, (File)file);
            }
            catch (IOException e) {
                Extractor.error("Could not write " + file + ": " + e.getLocalizedMessage());
            }
        }
    }

    private byte[] rewriteOuterClass(ClassReader reader) {
        ClassWriter classWriter = new ClassWriter(327680);
        ClassVisitor classVisitor = new ClassVisitor(327680, (ClassVisitor)classWriter){

            public void visitInnerClass(String name, String outerName, String innerName, int access) {
                if (!TypedefRemover.this.mAnnotationNames.contains(name)) {
                    super.visitInnerClass(name, outerName, innerName, access);
                }
            }
        };
        reader.accept(classVisitor, 0);
        return classWriter.toByteArray();
    }

    private void deleteAnnotationClasses(File classDir) {
        for (String relative : this.mAnnotationClassFiles) {
            boolean deleted;
            File file = new File(classDir, relative.replace('/', File.separatorChar));
            if (!file.isFile()) {
                Extractor.error("Warning: Could not find class file " + file + " for typedef");
                continue;
            }
            if (this.mVerbose) {
                if (this.mDryRun) {
                    this.info("Would delete " + file);
                } else {
                    this.info("Deleting " + file);
                }
            }
            if (this.mDryRun || (deleted = file.delete())) continue;
            Extractor.warning("Could not delete " + file);
        }
    }
}

