/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.external.cmake.server;

import com.android.build.gradle.external.cmake.server.CodeModel;
import com.android.build.gradle.external.cmake.server.CompileCommand;
import com.android.build.gradle.external.cmake.server.ComputeResult;
import com.android.build.gradle.external.cmake.server.Configuration;
import com.android.build.gradle.external.cmake.server.ConfigureResult;
import com.android.build.gradle.external.cmake.server.FileGroup;
import com.android.build.gradle.external.cmake.server.HandshakeResult;
import com.android.build.gradle.external.cmake.server.HelloResult;
import com.android.build.gradle.external.cmake.server.Project;
import com.android.build.gradle.external.cmake.server.Target;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;

public class ServerUtils {
    public static List<CompileCommand> getCompilationDatabase(File buildDirectory, String compileCommandsFilename) throws IOException, JsonSyntaxException {
        File compileCommandsFile = new File(buildDirectory, compileCommandsFilename);
        if (!compileCommandsFile.isFile()) {
            throw new RuntimeException(String.format("File %s not found", compileCommandsFile));
        }
        return ServerUtils.getCompilationDatabase(compileCommandsFile);
    }

    public static List<CompileCommand> getCompilationDatabase(File compileCommandsFile) throws IOException, JsonSyntaxException {
        String text = new String(Files.readAllBytes(compileCommandsFile.toPath()), StandardCharsets.UTF_8);
        Gson gson = new GsonBuilder().create();
        return Arrays.asList((Object[])gson.fromJson(text, CompileCommand[].class));
    }

    public static boolean isHelloResultValid(HelloResult helloResult) {
        return helloResult != null && helloResult.type != null && helloResult.supportedProtocolVersions != null && helloResult.type.equals("hello") && helloResult.supportedProtocolVersions.length >= 1;
    }

    public static boolean isHandshakeResultValid(HandshakeResult handshakeResult) {
        return handshakeResult.cookie != null && handshakeResult.inReplyTo != null && handshakeResult.type != null;
    }

    public static boolean isConfigureResultValid(ConfigureResult configureResult) {
        return configureResult.type != null && configureResult.inReplyTo != null && configureResult.type.equals("reply") && configureResult.inReplyTo.equals("configure");
    }

    public static boolean isComputedResultValid(ComputeResult computeResult) {
        return computeResult.inReplyTo != null && computeResult.type != null && computeResult.inReplyTo.equals("compute") && computeResult.type.equals("reply");
    }

    public static boolean isCodeModelValid(CodeModel codeModel) {
        return codeModel.type != null && codeModel.inReplyTo != null && codeModel.inReplyTo.equals("codemodel") && codeModel.type.equals("reply");
    }

    private static boolean isCodeModelConfigurationsValid(Configuration[] configurations) {
        if (configurations.length <= 0) {
            return false;
        }
        for (Configuration configuration : configurations) {
            if (configuration.projects == null || configuration.projects.length <= 0) {
                return false;
            }
            for (Project project : configuration.projects) {
                if (ServerUtils.isCodeModelProjectValid(project)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isCodeModelProjectValid(Project project) {
        if (project == null || project.buildDirectory == null || project.sourceDirectory == null || project.targets == null || project.targets.length <= 0) {
            return false;
        }
        for (Target target : project.targets) {
            if (ServerUtils.isCodeModelTargetValid(target)) continue;
            return false;
        }
        return true;
    }

    private static boolean isCodeModelTargetValid(Target target) {
        if (target == null || target.name == null || target.artifacts == null || target.artifacts.length <= 0 || target.buildDirectory == null || target.fileGroups == null || target.fileGroups.length <= 0) {
            return false;
        }
        for (FileGroup fileGroup : target.fileGroups) {
            if (ServerUtils.isCodeModelFileGroupValid(fileGroup)) continue;
            return false;
        }
        return true;
    }

    private static boolean isCodeModelFileGroupValid(FileGroup fileGroup) {
        return fileGroup != null && fileGroup.sources != null && fileGroup.sources.length > 0;
    }
}

