/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.api.attributes.BuildTypeAttr;
import com.android.build.api.attributes.ProductFlavorAttr;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dependency.AndroidTypeAttr;
import com.android.build.gradle.internal.dependency.VariantAttr;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.builder.core.ErrorReporter;
import com.android.builder.core.VariantType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.model.ObjectFactory;

public class VariantDependencies {
    public static final String CONFIG_NAME_COMPILE = "compile";
    public static final String CONFIG_NAME_S_COMPILE = "%sCompile";
    public static final String CONFIG_NAME_PUBLISH = "publish";
    public static final String CONFIG_NAME_S_PUBLISH = "%sPublish";
    public static final String CONFIG_NAME_APK = "apk";
    public static final String CONFIG_NAME_S_APK = "%sApk";
    public static final String CONFIG_NAME_PROVIDED = "provided";
    public static final String CONFIG_NAME_S_PROVIDED = "%sProvided";
    public static final String CONFIG_NAME_WEAR_APP = "wearApp";
    public static final String CONFIG_NAME_ANNOTATION_PROCESSOR = "annotationProcessor";
    public static final String CONFIG_NAME_S_WEAR_APP = "%sWearApp";
    public static final String CONFIG_NAME_S_ANNOTATION_PROCESSOR = "%sAnnotationProcessor";
    public static final String CONFIG_NAME_API = "api";
    public static final String CONFIG_NAME_S_API = "%sApi";
    public static final String CONFIG_NAME_COMPILE_ONLY = "compileOnly";
    public static final String CONFIG_NAME_S_COMPILE_ONLY = "%sCompileOnly";
    public static final String CONFIG_NAME_IMPLEMENTATION = "implementation";
    public static final String CONFIG_NAME_S_IMPLEMENTATION = "%sImplementation";
    public static final String CONFIG_NAME_RUNTIME_ONLY = "runtimeOnly";
    public static final String CONFIG_NAME_S_RUNTIME_ONLY = "%sRuntimeOnly";
    public static final String CONFIG_NAME_FEATURE = "feature";
    public static final String CONFIG_NAME_APPLICATION = "application";
    public static final String CONFIG_NAME_LINTCHECKS = "lintChecks";
    public static final String USAGE_LINT = "android-lint-checks";
    private final String variantName;
    private final Configuration compileClasspath;
    private final Configuration runtimeClasspath;
    private final Configuration apiElements;
    private final Configuration runtimeElements;
    private final Configuration annotationProcessorConfiguration;
    private final Configuration metadataElements;
    private final Configuration wearAppConfiguration;
    private final Configuration metadataValuesConfiguration;
    private boolean annotationsPresent;

    public static Builder builder(Project project, ErrorReporter errorReporter, GradleVariantConfiguration variantConfiguration) {
        return new Builder(project, errorReporter, variantConfiguration);
    }

    private VariantDependencies(String variantName, Configuration compileClasspath, Configuration runtimeClasspath, Configuration apiElements, Configuration runtimeElements, Configuration annotationProcessorConfiguration, Configuration metadataElements, Configuration metadataValuesConfiguration, Configuration wearAppConfiguration) {
        this.variantName = variantName;
        this.compileClasspath = compileClasspath;
        this.runtimeClasspath = runtimeClasspath;
        this.apiElements = apiElements;
        this.runtimeElements = runtimeElements;
        this.annotationProcessorConfiguration = annotationProcessorConfiguration;
        this.metadataElements = metadataElements;
        this.metadataValuesConfiguration = metadataValuesConfiguration;
        this.wearAppConfiguration = wearAppConfiguration;
    }

    public String getName() {
        return this.variantName;
    }

    public Configuration getCompileClasspath() {
        return this.compileClasspath;
    }

    public Configuration getRuntimeClasspath() {
        return this.runtimeClasspath;
    }

    public Configuration getApiElements() {
        return this.apiElements;
    }

    public Configuration getRuntimeElements() {
        return this.runtimeElements;
    }

    public Configuration getAnnotationProcessorConfiguration() {
        return this.annotationProcessorConfiguration;
    }

    public Configuration getMetadataElements() {
        return this.metadataElements;
    }

    public Configuration getWearAppConfiguration() {
        return this.wearAppConfiguration;
    }

    public Configuration getMetadataValuesConfiguration() {
        return this.metadataValuesConfiguration;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.variantName).toString();
    }

    public static final class Builder {
        private final Project project;
        private final ErrorReporter errorReporter;
        private final GradleVariantConfiguration variantConfiguration;
        private boolean baseSplit = false;
        private Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> flavorSelection;
        private AndroidTypeAttr consumeType;
        private AndroidTypeAttr publishType;
        private final Set<Configuration> compileClasspaths = Sets.newHashSet();
        private final Set<Configuration> apiClasspaths = Sets.newHashSet();
        private final Set<Configuration> runtimeClasspaths = Sets.newHashSet();
        private final Set<Configuration> annotationConfigs = Sets.newHashSet();
        private final Set<Configuration> wearAppConfigs = Sets.newHashSet();

        protected Builder(Project project, ErrorReporter errorReporter, GradleVariantConfiguration variantConfiguration) {
            this.project = project;
            this.errorReporter = errorReporter;
            this.variantConfiguration = variantConfiguration;
        }

        public Builder setPublishType(AndroidTypeAttr publishType) {
            this.publishType = publishType;
            return this;
        }

        public Builder setConsumeType(AndroidTypeAttr consumeType) {
            this.consumeType = consumeType;
            return this;
        }

        public Builder addSourceSets(DefaultAndroidSourceSet ... sourceSets) {
            for (DefaultAndroidSourceSet sourceSet : sourceSets) {
                this.addSourceSet(sourceSet);
            }
            return this;
        }

        public Builder addSourceSets(Collection<DefaultAndroidSourceSet> sourceSets) {
            for (DefaultAndroidSourceSet sourceSet : sourceSets) {
                this.addSourceSet(sourceSet);
            }
            return this;
        }

        public Builder setBaseSplit(boolean baseSplit) {
            this.baseSplit = baseSplit;
            return this;
        }

        public Builder addSourceSet(DefaultAndroidSourceSet sourceSet) {
            if (sourceSet != null) {
                ConfigurationContainer configs = this.project.getConfigurations();
                this.compileClasspaths.add(configs.getByName(sourceSet.getCompileOnlyConfigurationName()));
                this.runtimeClasspaths.add(configs.getByName(sourceSet.getRuntimeOnlyConfigurationName()));
                Configuration implementationConfig = configs.getByName(sourceSet.getImplementationConfigurationName());
                this.compileClasspaths.add(implementationConfig);
                this.runtimeClasspaths.add(implementationConfig);
                String apiConfigName = sourceSet.getApiConfigurationName();
                if (apiConfigName != null) {
                    this.apiClasspaths.add(configs.getByName(apiConfigName));
                }
                this.annotationConfigs.add(configs.getByName(sourceSet.getAnnotationProcessorConfigurationName()));
                this.wearAppConfigs.add(configs.getByName(sourceSet.getWearAppConfigurationName()));
            }
            return this;
        }

        public Builder setFlavorSelection(Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> flavorSelection) {
            this.flavorSelection = flavorSelection;
            return this;
        }

        public VariantDependencies build() {
            Preconditions.checkNotNull((Object)this.consumeType);
            ObjectFactory factory = this.project.getObjects();
            Usage apiUsage = (Usage)factory.named(Usage.class, "java-api");
            Usage runtimeUsage = (Usage)factory.named(Usage.class, "java-runtime");
            String variantName = this.variantConfiguration.getFullName();
            VariantType variantType = this.variantConfiguration.getType();
            String buildType = ((CoreBuildType)this.variantConfiguration.getBuildType()).getName();
            Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> consumptionFlavorMap = this.getFlavorAttributes(this.flavorSelection);
            ConfigurationContainer configurations = this.project.getConfigurations();
            String compileClasspathName = variantName + "CompileClasspath";
            Configuration compileClasspath = (Configuration)configurations.maybeCreate(compileClasspathName);
            compileClasspath.setVisible(false);
            compileClasspath.setDescription("Resolved configuration for compilation for variant: " + variantName);
            compileClasspath.setExtendsFrom(this.compileClasspaths);
            compileClasspath.setCanBeConsumed(false);
            compileClasspath.getResolutionStrategy().sortArtifacts(ResolutionStrategy.SortOrder.CONSUMER_FIRST);
            AttributeContainer compileAttributes = compileClasspath.getAttributes();
            this.applyVariantAttributes(compileAttributes, buildType, consumptionFlavorMap);
            compileAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)apiUsage);
            compileAttributes.attribute(AndroidTypeAttr.ATTRIBUTE, (Object)this.consumeType);
            Configuration annotationProcessor = (Configuration)configurations.maybeCreate(variantName + "AnnotationProcessorClasspath");
            annotationProcessor.setVisible(false);
            annotationProcessor.setDescription("Resolved configuration for annotation-processor for variant: " + variantName);
            annotationProcessor.setExtendsFrom(this.annotationConfigs);
            annotationProcessor.setCanBeConsumed(false);
            AttributeContainer annotationAttributes = annotationProcessor.getAttributes();
            annotationAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
            this.applyVariantAttributes(annotationAttributes, buildType, consumptionFlavorMap);
            String runtimeClasspathName = variantName + "RuntimeClasspath";
            Configuration runtimeClasspath = (Configuration)configurations.maybeCreate(runtimeClasspathName);
            runtimeClasspath.setVisible(false);
            runtimeClasspath.setDescription("Resolved configuration for runtime for variant: " + variantName);
            runtimeClasspath.setExtendsFrom(this.runtimeClasspaths);
            runtimeClasspath.setCanBeConsumed(false);
            runtimeClasspath.getResolutionStrategy().sortArtifacts(ResolutionStrategy.SortOrder.CONSUMER_FIRST);
            AttributeContainer runtimeAttributes = runtimeClasspath.getAttributes();
            this.applyVariantAttributes(runtimeAttributes, buildType, consumptionFlavorMap);
            runtimeAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
            runtimeAttributes.attribute(AndroidTypeAttr.ATTRIBUTE, (Object)this.consumeType);
            Configuration wearApp = null;
            if (this.publishType != null && this.publishType.getName().equals("Apk")) {
                wearApp = (Configuration)configurations.maybeCreate(variantName + "WearBundling");
                wearApp.setDescription("Resolved Configuration for wear app bundling for variant: " + variantName);
                wearApp.setExtendsFrom(this.wearAppConfigs);
                wearApp.setCanBeConsumed(false);
                AttributeContainer wearAttributes = wearApp.getAttributes();
                this.applyVariantAttributes(wearAttributes, buildType, consumptionFlavorMap);
                wearAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
                wearAttributes.attribute(AndroidTypeAttr.ATTRIBUTE, (Object)factory.named(AndroidTypeAttr.class, "Apk"));
            }
            Configuration apiElements = null;
            Configuration runtimeElements = null;
            Configuration metadataElements = null;
            Configuration metadataValues = null;
            if (this.publishType != null) {
                Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> publicationFlavorMap = this.getFlavorAttributes(null);
                runtimeElements = (Configuration)configurations.maybeCreate(variantName + "RuntimeElements");
                runtimeElements.setDescription("Runtime elements for " + variantName);
                runtimeElements.setCanBeResolved(false);
                AttributeContainer runtimeElementsAttributes = runtimeElements.getAttributes();
                this.applyVariantAttributes(runtimeElementsAttributes, buildType, publicationFlavorMap);
                VariantAttr variantNameAttr = (VariantAttr)factory.named(VariantAttr.class, variantName);
                runtimeElementsAttributes.attribute(VariantAttr.ATTRIBUTE, (Object)variantNameAttr);
                runtimeElementsAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
                runtimeElementsAttributes.attribute(AndroidTypeAttr.ATTRIBUTE, (Object)this.publishType);
                if (variantType == VariantType.LIBRARY) {
                    runtimeElements.extendsFrom(new Configuration[]{runtimeClasspath});
                }
                apiElements = (Configuration)configurations.maybeCreate(variantName + "ApiElements");
                apiElements.setDescription("API elements for " + variantName);
                apiElements.setCanBeResolved(false);
                AttributeContainer apiElementsAttributes = apiElements.getAttributes();
                this.applyVariantAttributes(apiElementsAttributes, buildType, publicationFlavorMap);
                apiElementsAttributes.attribute(VariantAttr.ATTRIBUTE, (Object)variantNameAttr);
                apiElementsAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)apiUsage);
                apiElementsAttributes.attribute(AndroidTypeAttr.ATTRIBUTE, (Object)this.publishType);
                apiElements.setExtendsFrom(this.apiClasspaths);
                if (variantType != VariantType.LIBRARY) {
                    metadataElements = (Configuration)configurations.maybeCreate(variantName + "MetadataElements");
                    metadataElements.setDescription("Metadata elements for " + variantName);
                    metadataElements.setCanBeResolved(false);
                    AttributeContainer metadataElementsAttributes = metadataElements.getAttributes();
                    this.applyVariantAttributes(metadataElementsAttributes, buildType, publicationFlavorMap);
                    metadataElementsAttributes.attribute(AndroidTypeAttr.ATTRIBUTE, (Object)factory.named(AndroidTypeAttr.class, "Metadata"));
                    metadataElementsAttributes.attribute(VariantAttr.ATTRIBUTE, (Object)variantNameAttr);
                }
                if (variantType == VariantType.FEATURE && this.baseSplit) {
                    metadataValues = (Configuration)configurations.maybeCreate(variantName + "MetadataValues");
                    metadataValues.extendsFrom(new Configuration[]{configurations.getByName(VariantDependencies.CONFIG_NAME_FEATURE), configurations.getByName(VariantDependencies.CONFIG_NAME_APPLICATION)});
                    metadataValues.setDescription("Metadata Values dependencies for the base Split");
                    metadataValues.setCanBeConsumed(false);
                    AttributeContainer featureMetadataAttributes = metadataValues.getAttributes();
                    featureMetadataAttributes.attribute(AndroidTypeAttr.ATTRIBUTE, (Object)factory.named(AndroidTypeAttr.class, "Metadata"));
                    this.applyVariantAttributes(featureMetadataAttributes, buildType, consumptionFlavorMap);
                }
            }
            Builder.checkOldConfigurations(configurations, "_" + variantName + "Compile", compileClasspathName);
            Builder.checkOldConfigurations(configurations, "_" + variantName + "Apk", runtimeClasspathName);
            Builder.checkOldConfigurations(configurations, "_" + variantName + "Publish", runtimeClasspathName);
            return new VariantDependencies(variantName, compileClasspath, runtimeClasspath, apiElements, runtimeElements, annotationProcessor, metadataElements, metadataValues, wearApp);
        }

        private static void checkOldConfigurations(ConfigurationContainer configurations, String oldConfigName, String newConfigName) {
            if (configurations.findByName(oldConfigName) != null) {
                throw new RuntimeException(String.format("Configuration with old name %s found. Use new name %s instead.", oldConfigName, newConfigName));
            }
        }

        private Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> getFlavorAttributes(Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> flavorSelection) {
            List productFlavors = this.variantConfiguration.getProductFlavors();
            HashMap map = Maps.newHashMapWithExpectedSize((int)productFlavors.size());
            if (this.errorReporter.hasSyncIssue(26)) {
                return map;
            }
            ObjectFactory objectFactory = this.project.getObjects();
            for (CoreProductFlavor f : productFlavors) {
                assert (f.getDimension() != null);
                map.put(Attribute.of((String)f.getDimension(), ProductFlavorAttr.class), objectFactory.named(ProductFlavorAttr.class, f.getName()));
            }
            if (flavorSelection != null) {
                map.putAll(flavorSelection);
            }
            return map;
        }

        private void applyVariantAttributes(AttributeContainer attributeContainer, String buildType, Map<Attribute<ProductFlavorAttr>, ProductFlavorAttr> flavorMap) {
            attributeContainer.attribute(BuildTypeAttr.ATTRIBUTE, (Object)this.project.getObjects().named(BuildTypeAttr.class, buildType));
            for (Map.Entry<Attribute<ProductFlavorAttr>, ProductFlavorAttr> entry : flavorMap.entrySet()) {
                attributeContainer.attribute(entry.getKey(), (Object)entry.getValue());
            }
        }
    }
}

