/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.incremental.BuildInfoWriterTask;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.ApplicationId;
import com.android.build.gradle.internal.tasks.ApplicationIdWriterTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclaration;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclarationWriterTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitPackageIds;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitPackageIdsWriterTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitTransitiveDepsWriterTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.FeatureVariantData;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.MergeManifests;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.profile.Recorder;
import com.android.manifmerger.ManifestMerger2;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class FeatureTaskManager
extends TaskManager {
    public FeatureTaskManager(GlobalScope globalScope, Project project, ProjectOptions projectOptions, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(globalScope, project, projectOptions, androidBuilder, dataBindingBuilder, extension, sdkHandler, toolingRegistry, recorder);
    }

    @Override
    public void createTasksForVariantScope(TaskFactory tasks, VariantScope variantScope) {
        AndroidVersion androidVersion = AndroidTargetHash.getVersionFromHash((String)variantScope.getGlobalScope().getExtension().getCompileSdkVersion());
        if (androidVersion == null || androidVersion.getApiLevel() < 26) {
            String message = "Feature modules require compileSdkVersion set to 26 or higher.";
            if (androidVersion != null) {
                message = message + " compileSdkVersion is set to " + androidVersion.getApiString();
            }
            this.androidBuilder.getErrorReporter().handleSyncError(null, 0, message);
        }
        if (AaptGeneration.fromProjectOptions(this.projectOptions) == AaptGeneration.AAPT_V1 && !this.extension.getBaseFeature().booleanValue()) {
            this.androidBuilder.getErrorReporter().handleSyncError(null, 0, "Non-base feature modules require AAPTv2 to build.");
        }
        BaseVariantData variantData = variantScope.getVariantData();
        assert (variantData instanceof FeatureVariantData);
        if (this.extension.getDataBinding().isEnabled() && !this.extension.getBaseFeature().booleanValue()) {
            throw new GradleException("Currently, data binding does not work for non-base feature modules.\nPlease, move data binding code to the base feature module.\nSee https://issuetracker.google.com/63814741 for details");
        }
        this.createAnchorTasks(tasks, variantScope);
        this.createCheckManifestTask(tasks, variantScope);
        this.createDependencyStreams(tasks, variantScope);
        if (variantScope.isBaseFeature()) {
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_BASE_TASKS, this.project.getPath(), variantScope.getFullVariantName(), () -> {
                this.createFeatureApplicationIdWriterTask(tasks, variantScope);
                this.createFeatureIdsWriterTask(tasks, variantScope);
            });
        } else {
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_NON_BASE_TASKS, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createFeatureDeclarationTasks(tasks, variantScope));
        }
        this.createFeatureTransitiveDepsTask(tasks, variantScope);
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_MERGE_MANIFEST_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeApkManifestsTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_GENERATE_RES_VALUES_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createGenerateResValuesTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_CREATE_RENDERSCRIPT_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createRenderscriptTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_MERGE_RESOURCES_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeResourcesTask(tasks, variantScope, true));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_MERGE_ASSETS_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeAssetsTask(tasks, variantScope, null));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_BUILD_CONFIG_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createBuildConfigTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_PROCESS_RES_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> {
            AndroidTask<ProcessAndroidResources> processAndroidResourcesTask = this.createProcessResTask(tasks, variantScope, () -> FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"symbols", variantScope.getVariantData().getVariantConfiguration().getDirName()}), variantScope.getProcessResourcePackageOutputDirectory(), TaskManager.MergeType.MERGE, variantScope.getGlobalScope().getProjectBaseName());
            variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.FEATURE_RESOURCE_PKG, variantScope.getProcessResourcePackageOutputDirectory(), processAndroidResourcesTask.getName());
            this.createProcessJavaResTask(tasks, variantScope);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_AIDL_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createAidlTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_SHADER_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createShaderTask(tasks, variantScope));
        if (!this.isComponentModelPlugin()) {
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_NDK_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createNdkTasks(tasks, variantScope));
        } else if (variantData.compileTask != null) {
            variantData.compileTask.dependsOn(new Object[]{this.getNdkBuildable(variantData)});
        } else {
            variantScope.getCompileTask().dependsOn(tasks, (Object)this.getNdkBuildable(variantData));
        }
        variantScope.setNdkBuildable(this.getNdkBuildable(variantData));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_EXTERNAL_NATIVE_BUILD_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> {
            this.createExternalNativeBuildJsonGenerators(variantScope);
            this.createExternalNativeBuildTasks(tasks, variantScope);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_MERGE_JNILIBS_FOLDERS_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeJniLibFoldersTasks(tasks, variantScope));
        this.createDataBindingTasksIfNecessary(tasks, variantScope);
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_COMPILE_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.addCompileTask(tasks, variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_STRIP_NATIVE_LIBRARY_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> FeatureTaskManager.createStripNativeLibraryTask(tasks, variantScope));
        if (variantScope.getOutputScope().getMultiOutputPolicy().equals((Object)MultiOutputPolicy.SPLITS)) {
            if (this.extension.getBuildToolsRevision().getMajor() < 21) {
                throw new RuntimeException("Pure splits can only be used with buildtools 21 and later");
            }
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_SPLIT_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createSplitTasks(tasks, variantScope));
        }
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_PACKAGING_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> {
            AndroidTask<BuildInfoWriterTask> buildInfoWriterTask = this.getAndroidTasks().create(tasks, new BuildInfoWriterTask.ConfigAction(variantScope, this.getLogger()));
            this.createPackagingTask(tasks, variantScope, buildInfoWriterTask);
        });
    }

    private void createFeatureDeclarationTasks(TaskFactory tasks, VariantScope variantScope) {
        File featureSplitDeclarationOutputDirectory = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"feature-split", "declaration", variantScope.getVariantConfiguration().getDirName()});
        AndroidTask<FeatureSplitDeclarationWriterTask> featureSplitWriterTaskAndroidTask = this.androidTasks.create(tasks, new FeatureSplitDeclarationWriterTask.ConfigAction(variantScope, featureSplitDeclarationOutputDirectory));
        variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.METADATA_FEATURE_DECLARATION, FeatureSplitDeclaration.getOutputFile(featureSplitDeclarationOutputDirectory), featureSplitWriterTaskAndroidTask.getName());
    }

    private void createFeatureApplicationIdWriterTask(TaskFactory tasks, VariantScope variantScope) {
        File applicationIdOutputDirectory = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"feature-split", "applicationId", variantScope.getVariantConfiguration().getDirName()});
        AndroidTask<ApplicationIdWriterTask> writeTask = this.androidTasks.create(tasks, new ApplicationIdWriterTask.BaseFeatureConfigAction(variantScope, applicationIdOutputDirectory));
        variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.FEATURE_APPLICATION_ID_DECLARATION, ApplicationId.getOutputFile(applicationIdOutputDirectory), writeTask.getName());
    }

    private void createFeatureIdsWriterTask(TaskFactory tasks, VariantScope variantScope) {
        File featureIdsOutputDirectory = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"feature-split", "ids", variantScope.getVariantConfiguration().getDirName()});
        AndroidTask<FeatureSplitPackageIdsWriterTask> writeTask = this.androidTasks.create(tasks, new FeatureSplitPackageIdsWriterTask.ConfigAction(variantScope, featureIdsOutputDirectory));
        variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.FEATURE_IDS_DECLARATION, FeatureSplitPackageIds.getOutputFile(featureIdsOutputDirectory), writeTask.getName());
    }

    private void createFeatureTransitiveDepsTask(TaskFactory tasks, VariantScope scope) {
        File textFile = new File(FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"feature-split", "transitive-deps", scope.getVariantConfiguration().getDirName()}), "deps.txt");
        AndroidTask<FeatureSplitTransitiveDepsWriterTask> task = this.androidTasks.create(tasks, new FeatureSplitTransitiveDepsWriterTask.ConfigAction(scope, textFile));
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.FEATURE_TRANSITIVE_DEPS, textFile, task.getName());
    }

    @Override
    protected AndroidTask<? extends ManifestProcessorTask> createMergeManifestTask(TaskFactory tasks, VariantScope variantScope, ImmutableList.Builder<ManifestMerger2.Invoker.Feature> optionalFeatures) {
        AndroidTask<MergeManifests> mergeManifestsAndroidTask;
        if (variantScope.getVariantConfiguration().isInstantRunBuild(this.globalScope)) {
            optionalFeatures.add((Object)ManifestMerger2.Invoker.Feature.INSTANT_RUN_REPLACEMENT);
        }
        optionalFeatures.add((Object)ManifestMerger2.Invoker.Feature.TARGET_SANDBOX_VERSION);
        if (variantScope.isBaseFeature()) {
            mergeManifestsAndroidTask = this.androidTasks.create(tasks, new MergeManifests.BaseFeatureConfigAction(variantScope, (List<ManifestMerger2.Invoker.Feature>)optionalFeatures.build()));
        } else {
            optionalFeatures.add((Object)ManifestMerger2.Invoker.Feature.ADD_FEATURE_SPLIT_INFO);
            mergeManifestsAndroidTask = this.androidTasks.create(tasks, new MergeManifests.FeatureConfigAction(variantScope, (List<ManifestMerger2.Invoker.Feature>)optionalFeatures.build()));
            variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.METADADA_FEATURE_MANIFEST, BuildOutputs.getMetadataFile(variantScope.getManifestOutputDirectory()), mergeManifestsAndroidTask.getName());
        }
        variantScope.addTaskOutput(TaskOutputHolder.TaskOutputType.INSTANT_RUN_MERGED_MANIFESTS, variantScope.getInstantRunManifestOutputDirectory(), mergeManifestsAndroidTask.getName());
        return mergeManifestsAndroidTask;
    }

    private void addCompileTask(TaskFactory tasks, VariantScope variantScope) {
        this.createDataBindingMergeArtifactsTaskIfNecessary(tasks, variantScope);
        AndroidTask<? extends JavaCompile> javacTask = this.createJavacTask(tasks, variantScope);
        VariantScope.Java8LangSupport java8LangSupport = variantScope.getJava8LangSupportType();
        if (java8LangSupport == VariantScope.Java8LangSupport.INVALID) {
            return;
        }
        String pluginName = null;
        if (java8LangSupport == VariantScope.Java8LangSupport.DEXGUARD) {
            pluginName = "dexguard";
        } else if (java8LangSupport == VariantScope.Java8LangSupport.RETROLAMBDA) {
            pluginName = "me.tatarka.retrolambda";
        }
        if (pluginName != null) {
            String warningMsg = String.format("One of the plugins you are using supports Java 8 language features. To try the support built into the Android plugin, remove the following from your build.gradle:\n    apply plugin: '%s'\nTo learn more, go to https://d.android.com/r/tools/java-8-support-message.html\n", pluginName);
            this.androidBuilder.getErrorReporter().handleSyncWarning(null, 0, warningMsg);
        }
        this.addJavacClassesStream(variantScope);
        FeatureTaskManager.setJavaCompilerTask(javacTask, tasks, variantScope);
        this.createPostCompilationTasks(tasks, variantScope);
    }

    @Override
    protected void postJavacCreation(TaskFactory tasks, final VariantScope scope) {
        final File dest = new File(this.globalScope.getBuildDir(), FileUtils.join((String[])new String[]{"intermediates", "classes-jar", scope.getVariantConfiguration().getDirName()}));
        AndroidTask<Jar> task = this.androidTasks.create(tasks, new TaskConfigAction<Jar>(){

            @Override
            public String getName() {
                return scope.getTaskName("bundle", "Classes");
            }

            @Override
            public Class<Jar> getType() {
                return Jar.class;
            }

            @Override
            public void execute(Jar task) {
                task.from(new Object[]{scope.getOutput(TaskOutputHolder.TaskOutputType.JAVAC)});
                task.from(new Object[]{scope.getVariantData().getAllPreJavacGeneratedBytecode()});
                task.from(new Object[]{scope.getVariantData().getAllPostJavacGeneratedBytecode()});
                task.setDestinationDir(dest);
                task.setArchiveName("classes.jar");
            }
        });
        scope.addTaskOutput(TaskOutputHolder.TaskOutputType.FEATURE_CLASSES, new File(dest, "classes.jar"), task.getName());
    }

    @Override
    protected Set<? super QualifiedContent.Scope> getResMergingScopes(VariantScope variantScope) {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    @Override
    protected ProcessAndroidResources.ConfigAction createProcessAndroidResourcesConfigAction(VariantScope scope, Supplier<File> symbolLocation, File symbolsWithPackageName, File resPackageOutputFolder, boolean useAaptToGenerateLegacyMultidexMainDexProguardRules, TaskManager.MergeType sourceTaskOutputType, String baseName) {
        if (scope.isBaseFeature()) {
            return super.createProcessAndroidResourcesConfigAction(scope, symbolLocation, symbolsWithPackageName, resPackageOutputFolder, useAaptToGenerateLegacyMultidexMainDexProguardRules, sourceTaskOutputType, baseName);
        }
        return new ProcessAndroidResources.FeatureSplitConfigAction(scope, symbolLocation, symbolsWithPackageName, resPackageOutputFolder, useAaptToGenerateLegacyMultidexMainDexProguardRules, sourceTaskOutputType, baseName);
    }
}

