/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.LintGradleClient;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.tasks.LintBaseTask;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintBaseline;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class LintGlobalTask
extends LintBaseTask {
    private Map<String, LintBaseTask.VariantInputs> variantInputMap;
    private ConfigurableFileCollection allInputs;

    @InputFiles
    @Optional
    public FileCollection getAllInputs() {
        return this.allInputs;
    }

    @TaskAction
    public void lint() throws IOException {
        AndroidProject modelProject = this.createAndroidProject(this.getProject());
        this.lintAllVariants(modelProject);
    }

    /*
     * WARNING - void declaration
     */
    public void lintAllVariants(AndroidProject modelProject) throws IOException {
        void var7_12;
        UnusedResourceDetector.sIncludeInactiveReferences = false;
        HashMap warningMap = Maps.newHashMap();
        ArrayList baselines = Lists.newArrayList();
        for (Variant variant : modelProject.getVariants()) {
            LintBaseTask.VariantInputs variantInputs = this.variantInputMap.get(variant.getName());
            if (variantInputs == null) continue;
            Pair<List<Warning>, LintBaseline> pair = this.runLint(modelProject, variant, variantInputs, false);
            List warnings = (List)pair.getFirst();
            warningMap.put(variant, warnings);
            LintBaseline baseline = (LintBaseline)pair.getSecond();
            if (baseline == null) continue;
            baselines.add(baseline);
        }
        LintOptions lintOptions = this.getLintOptions();
        boolean quiet = false;
        if (lintOptions != null) {
            quiet = lintOptions.isQuiet();
        }
        for (Map.Entry entry : warningMap.entrySet()) {
            Variant variant = (Variant)entry.getKey();
            List warnings = (List)entry.getValue();
            if (this.isFatalOnly() || quiet) continue;
            LOG.warn("Ran lint on variant {}: {} issues found", (Object)variant.getName(), (Object)warnings.size());
        }
        List<Warning> mergedWarnings = LintGradleClient.merge(warningMap, modelProject);
        boolean bl = false;
        int warningCount = 0;
        for (Warning warning : mergedWarnings) {
            if (warning.severity == Severity.ERROR || warning.severity == Severity.FATAL) {
                ++var7_12;
                continue;
            }
            if (warning.severity != Severity.WARNING) continue;
            ++warningCount;
        }
        if (!modelProject.getVariants().isEmpty()) {
            TreeSet allVariants = Sets.newTreeSet((v1, v2) -> v1.getName().compareTo(v2.getName()));
            allVariants.addAll(modelProject.getVariants());
            Variant variant = (Variant)allVariants.iterator().next();
            BuiltinIssueRegistry registry = new BuiltinIssueRegistry();
            LintCliFlags flags = new LintCliFlags();
            LintGradleClient client = new LintGradleClient((IssueRegistry)registry, flags, this.getProject(), modelProject, this.getSdkHome(), variant, this.variantInputMap.get(variant.getName()), this.getBuildTools());
            LintGlobalTask.syncOptions(lintOptions, client, flags, null, this.getProject(), this.getReportsDir(), true, this.isFatalOnly());
            int baselineErrorCount = 0;
            int baselineWarningCount = 0;
            int fixedCount = 0;
            if (!baselines.isEmpty()) {
                for (Object baseline : baselines) {
                    baselineErrorCount = Math.max(baselineErrorCount, baseline.getFoundErrorCount());
                    baselineWarningCount = Math.max(baselineWarningCount, baseline.getFoundWarningCount());
                    fixedCount = Math.max(fixedCount, baseline.getFixedCount());
                }
            }
            Reporter.Stats stats = new Reporter.Stats((int)var7_12, warningCount, baselineErrorCount, baselineWarningCount, fixedCount);
            for (Reporter reporter : flags.getReporters()) {
                reporter.write(stats, mergedWarnings);
            }
            File baselineFile = flags.getBaselineFile();
            if (baselineFile != null && !baselineFile.exists()) {
                File dir = baselineFile.getParentFile();
                boolean ok = true;
                if (!dir.isDirectory()) {
                    ok = dir.mkdirs();
                }
                if (!ok) {
                    System.err.println("Couldn't create baseline folder " + dir);
                } else {
                    Reporter reporter = Reporter.createXmlReporter((LintCliClient)client, (File)baselineFile, (boolean)true);
                    reporter.write(stats, mergedWarnings);
                    System.err.println("Created baseline file " + baselineFile);
                    if (LintGradleClient.continueAfterBaseLineCreated()) {
                        return;
                    }
                    System.err.println("(Also breaking build in case this was not intentional.)");
                    String message = "Created baseline file " + baselineFile + "\n\nAlso breaking the build in case this was not intentional. If you\ndeliberately created the baseline file, re-run the build and this\ntime it should succeed without warnings.\n\nIf not, investigate the baseline path in the lintOptions config\nor verify that the baseline file has been checked into version\ncontrol.\n\nYou can set the system property lint.baselines.continue=true\nif you want to create many missing baselines in one go.";
                    throw new GradleException(message);
                }
            }
            if (baselineErrorCount > 0 || baselineWarningCount > 0) {
                System.out.println(String.format("%1$s were filtered out because they were listed in the baseline file, %2$s\n", LintUtils.describeCounts((int)baselineErrorCount, (int)baselineWarningCount, (boolean)false, (boolean)true), baselineFile));
            }
            if (fixedCount > 0) {
                System.out.println(String.format("%1$d errors/warnings were listed in the baseline file (%2$s) but not found in the project; perhaps they have been fixed?\n", fixedCount, baselineFile));
            }
            if (flags.isSetExitCode() && var7_12 > 0) {
                this.abort();
            }
        }
    }

    public static class GlobalConfigAction
    extends LintBaseTask.BaseConfigAction<LintGlobalTask> {
        private final Collection<VariantScope> variantScopes;

        public GlobalConfigAction(GlobalScope globalScope, Collection<VariantScope> variantScopes) {
            super(globalScope);
            this.variantScopes = variantScopes;
        }

        @Override
        public String getName() {
            return "lint";
        }

        @Override
        public Class<LintGlobalTask> getType() {
            return LintGlobalTask.class;
        }

        @Override
        public void execute(LintGlobalTask lintTask) {
            super.execute(lintTask);
            lintTask.setDescription("Runs lint on all variants.");
            lintTask.setVariantName("");
            lintTask.allInputs = this.getGlobalScope().getProject().files(new Object[0]);
            lintTask.variantInputMap = this.variantScopes.stream().map(variantScope -> {
                LintBaseTask.VariantInputs inputs = new LintBaseTask.VariantInputs((VariantScope)variantScope);
                lintTask.allInputs.from(new Object[]{inputs.getAllInputs()});
                return inputs;
            }).collect(Collectors.toMap(LintBaseTask.VariantInputs::getName, Function.identity()));
        }
    }
}

