/*
 * Copyright (C) 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.build.gradle.internal.tasks;

import com.android.annotations.NonNull;
import com.google.common.base.Supplier;
import java.io.File;
import org.gradle.api.Task;

/**
 * Denotes a supplier of a file. The supplier also provides a link to the task generating the file.
 */
public interface FileSupplier extends Supplier<File> {

    /**
     * Returns the task generating the file.
     */
    @NonNull
    Task getTask();
}