/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.builder.utils.ExceptionRunnable;
import com.android.builder.utils.FileCache;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.utils.PathUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class FixStackFramesTransform
extends Transform {
    private static final LoggerWrapper logger = LoggerWrapper.getLogger(FixStackFramesTransform.class);
    private static final FileTime ZERO = FileTime.fromMillis(0L);
    private final Supplier<List<File>> androidJarClasspath;
    private final List<Path> compilationBootclasspath;
    private final FileCache userCache;
    private final WaitableExecutor waitableExecutor;
    private URLClassLoader classLoader = null;

    public FixStackFramesTransform(Supplier<List<File>> androidJarClasspath, String compilationBootclasspath, FileCache userCache) {
        this.androidJarClasspath = androidJarClasspath;
        this.compilationBootclasspath = PathUtils.getClassPathItems((String)compilationBootclasspath);
        this.userCache = userCache;
        this.waitableExecutor = WaitableExecutor.useGlobalSharedThreadPool();
    }

    public String getName() {
        return "stackFramesFixer";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.EXTERNAL_LIBRARIES, (Enum[])new QualifiedContent.Scope[0]);
    }

    public Set<? super QualifiedContent.Scope> getReferencedScopes() {
        return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.SUB_PROJECTS, QualifiedContent.Scope.PROVIDED_ONLY, QualifiedContent.Scope.TESTED_CODE});
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        ImmutableList.Builder files = ImmutableList.builder();
        this.androidJarClasspath.get().forEach(file -> files.add((Object)SecondaryFile.nonIncremental((File)file)));
        this.compilationBootclasspath.forEach(file -> files.add((Object)SecondaryFile.nonIncremental((File)file.toFile())));
        return files.build();
    }

    public boolean isIncremental() {
        return true;
    }

    private URLClassLoader getClassLoader(TransformInvocation invocation) throws MalformedURLException {
        if (this.classLoader == null) {
            ImmutableList.Builder urls = new ImmutableList.Builder();
            for (File file : this.androidJarClasspath.get()) {
                urls.add((Object)file.toURI().toURL());
            }
            for (Path bootClasspath : this.compilationBootclasspath) {
                if (!Files.exists(bootClasspath, new LinkOption[0])) continue;
                urls.add((Object)bootClasspath.toUri().toURL());
            }
            for (TransformInput inputs : Iterables.concat((Iterable)invocation.getInputs(), (Iterable)invocation.getReferencedInputs())) {
                for (DirectoryInput directoryInput : inputs.getDirectoryInputs()) {
                    if (!directoryInput.getFile().isDirectory()) continue;
                    urls.add((Object)directoryInput.getFile().toURI().toURL());
                }
                for (JarInput jarInput : inputs.getJarInputs()) {
                    if (!jarInput.getFile().isFile()) continue;
                    urls.add((Object)jarInput.getFile().toURI().toURL());
                }
            }
            ImmutableList allUrls = urls.build();
            URL[] classLoaderUrls = (URL[])allUrls.toArray((Object[])new URL[allUrls.size()]);
            this.classLoader = new URLClassLoader(classLoaderUrls);
        }
        return this.classLoader;
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        TransformOutputProvider outputProvider = (TransformOutputProvider)Preconditions.checkNotNull((Object)transformInvocation.getOutputProvider());
        boolean incremental = transformInvocation.isIncremental();
        try {
            for (TransformInput input : transformInvocation.getInputs()) {
                for (JarInput jarInput : input.getJarInputs()) {
                    Status status = jarInput.getStatus();
                    if (incremental && status == Status.NOTCHANGED) continue;
                    File output = outputProvider.getContentLocation(jarInput.getName(), jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR);
                    Files.deleteIfExists(output.toPath());
                    if (incremental && status != Status.ADDED && status != Status.CHANGED) continue;
                    this.processJar(jarInput.getFile(), output, transformInvocation);
                }
            }
            this.waitableExecutor.waitForTasksWithQuickFail(true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw new TransformException((Throwable)e);
        }
        finally {
            if (this.classLoader != null) {
                this.classLoader.close();
            }
        }
    }

    private void processJar(File input, File output, TransformInvocation invocation) {
        this.waitableExecutor.execute(() -> {
            ExceptionRunnable fileCreator = this.createFile(input, output, invocation);
            if (this.userCache != null) {
                FileCache.Inputs key = new FileCache.Inputs.Builder(FileCache.Command.FIX_STACK_FRAMES).putFile("file", input, FileCache.FileProperties.PATH_SIZE_TIMESTAMP).build();
                this.userCache.createFile(output, key, fileCreator);
            } else {
                fileCreator.run();
            }
            return null;
        });
    }

    private ExceptionRunnable createFile(File input, File output, TransformInvocation invocation) {
        return () -> {
            try (ZipFile inputZip = new ZipFile(input);
                 ZipOutputStream outputZip = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(output.toPath(), new OpenOption[0])));){
                Enumeration<? extends ZipEntry> inEntries = inputZip.entries();
                while (inEntries.hasMoreElements()) {
                    ZipEntry entry = inEntries.nextElement();
                    BufferedInputStream originalFile = new BufferedInputStream(inputZip.getInputStream(entry));
                    ZipEntry outEntry = new ZipEntry(entry.getName());
                    byte[] newEntryContent = !entry.getName().endsWith(".class") ? ByteStreams.toByteArray((InputStream)originalFile) : FixStackFramesTransform.getFixedClass(originalFile, this.getClassLoader(invocation));
                    CRC32 crc32 = new CRC32();
                    crc32.update(newEntryContent);
                    outEntry.setCrc(crc32.getValue());
                    outEntry.setMethod(0);
                    outEntry.setSize(newEntryContent.length);
                    outEntry.setCompressedSize(newEntryContent.length);
                    outEntry.setLastAccessTime(ZERO);
                    outEntry.setLastModifiedTime(ZERO);
                    outEntry.setCreationTime(ZERO);
                    outputZip.putNextEntry(outEntry);
                    outputZip.write(newEntryContent);
                    outputZip.closeEntry();
                }
            }
        };
    }

    private static byte[] getFixedClass(InputStream originalFile, URLClassLoader classLoader) throws IOException {
        byte[] bytes = ByteStreams.toByteArray((InputStream)originalFile);
        try {
            ClassReader classReader = new ClassReader(bytes);
            FixFramesVisitor classWriter = new FixFramesVisitor(2, classLoader);
            classReader.accept((ClassVisitor)classWriter, 4);
            return classWriter.toByteArray();
        }
        catch (Throwable t) {
            logger.verbose(t.getMessage(), new Object[0]);
            return bytes;
        }
    }

    private static class FixFramesVisitor
    extends ClassWriter {
        private final URLClassLoader classLoader;

        public FixFramesVisitor(int flags, URLClassLoader classLoader) {
            super(flags);
            this.classLoader = classLoader;
        }

        protected String getCommonSuperClass(String type1, String type2) {
            Class<?> d;
            Class<?> c;
            URLClassLoader classLoader = this.classLoader;
            try {
                c = Class.forName(type1.replace('/', '.'), false, classLoader);
                d = Class.forName(type2.replace('/', '.'), false, classLoader);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unable to find common supper type for %s and %s.", type1, type2), e);
            }
            if (c.isAssignableFrom(d)) {
                return type1;
            }
            if (d.isAssignableFrom(c)) {
                return type2;
            }
            if (c.isInterface() || d.isInterface()) {
                return "java/lang/Object";
            }
            while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
            }
            return c.getName().replace('.', '/');
        }
    }
}

