/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.utils.FileUtils;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class PrepareLintJar
extends DefaultTask {
    public static final String NAME = "prepareLintJar";
    private FileCollection lintChecks;
    private File outputLintJar;

    @InputFiles
    public FileCollection getLintChecks() {
        return this.lintChecks;
    }

    @OutputFile
    public File getOutputLintJar() {
        return this.outputLintJar;
    }

    @TaskAction
    public void prepare() throws IOException {
        Set files = this.lintChecks.getFiles();
        if (files.size() > 1) {
            throw new RuntimeException("Found more than one jar in the 'lintChecks' configuration. Only one file is supported. If using a separate Gradle project, make sure compilation dependencies are using compileOnly");
        }
        if (files.isEmpty()) {
            if (this.outputLintJar.isFile()) {
                FileUtils.delete((File)this.outputLintJar);
            }
        } else {
            FileUtils.mkdirs((File)this.outputLintJar.getParentFile());
            Files.copy((File)((File)Iterables.getOnlyElement((Iterable)files)), (File)this.outputLintJar);
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<PrepareLintJar> {
        private final GlobalScope scope;
        private final File destFile;

        public ConfigAction(GlobalScope scope, File destFile) {
            this.scope = scope;
            this.destFile = destFile;
        }

        @Override
        public String getName() {
            return PrepareLintJar.NAME;
        }

        @Override
        public Class<PrepareLintJar> getType() {
            return PrepareLintJar.class;
        }

        @Override
        public void execute(PrepareLintJar task) {
            task.outputLintJar = this.destFile;
            task.lintChecks = this.scope.getLocalCustomLintChecks();
        }
    }
}

