/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.featuresplit;

import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitTransitiveDepsWriterTask;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\nH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSplitTransitiveDepsWriterTask;", "Lcom/android/build/gradle/internal/tasks/DefaultAndroidTask;", "()V", "outputFile", "Ljava/io/File;", "runtimeJars", "Lorg/gradle/api/artifacts/ArtifactCollection;", "getInputJars", "Lorg/gradle/api/file/FileCollection;", "write", "", "ConfigAction", "gradle-core_main"})
public class FeatureSplitTransitiveDepsWriterTask
extends DefaultAndroidTask {
    private ArtifactCollection runtimeJars;
    private File outputFile;

    @CompileClasspath
    @NotNull
    public final FileCollection getInputJars() {
        ArtifactCollection artifactCollection = this.runtimeJars;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"runtimeJars");
        }
        FileCollection fileCollection = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"runtimeJars.artifactFiles");
        return fileCollection;
    }

    @TaskAction
    public final void write() throws IOException {
        ArtifactCollection artifactCollection = this.runtimeJars;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"runtimeJars");
        }
        Set set = artifactCollection.getArtifacts().stream().map(write.content.1.INSTANCE).collect(Collectors.toSet());
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"runtimeJars.artifacts\n  \u2026llect(Collectors.toSet())");
        Set content2 = set;
        File file = this.outputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
        }
        FileUtils.mkdirs((File)file.getParentFile());
        File file2 = this.outputFile;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
        }
        Files.asCharSink((File)file2, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)Joiner.on((String)System.lineSeparator()).join((Iterable)content2));
    }

    @NotNull
    public static final /* synthetic */ File access$getOutputFile$p(FeatureSplitTransitiveDepsWriterTask $this) {
        File file = $this.outputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
        }
        return file;
    }

    @NotNull
    public static final /* synthetic */ ArtifactCollection access$getRuntimeJars$p(FeatureSplitTransitiveDepsWriterTask $this) {
        ArtifactCollection artifactCollection = $this.runtimeJars;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"runtimeJars");
        }
        return artifactCollection;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\r\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSplitTransitiveDepsWriterTask$ConfigAction;", "Lcom/android/build/gradle/internal/scope/TaskConfigAction;", "Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSplitTransitiveDepsWriterTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "outputFile", "Ljava/io/File;", "(Lcom/android/build/gradle/internal/scope/VariantScope;Ljava/io/File;)V", "execute", "", "task", "getName", "", "Lcom/android/annotations/NonNull;", "getType", "Ljava/lang/Class;", "gradle-core_main"})
    public static final class ConfigAction
    implements TaskConfigAction<FeatureSplitTransitiveDepsWriterTask> {
        private final VariantScope variantScope;
        private final File outputFile;

        @Override
        @NotNull
        public String getName() {
            return this.variantScope.getTaskName("generate", "FeatureTransitiveDeps");
        }

        @Override
        @NotNull
        public Class<FeatureSplitTransitiveDepsWriterTask> getType() {
            return FeatureSplitTransitiveDepsWriterTask.class;
        }

        @Override
        public void execute(@NotNull FeatureSplitTransitiveDepsWriterTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            task.setVariantName(this.variantScope.getFullVariantName());
            task.outputFile = this.outputFile;
            ArtifactCollection artifactCollection = this.variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES);
            Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"variantScope.getArtifact\u2026cts.ArtifactType.CLASSES)");
            task.runtimeJars = artifactCollection;
        }

        public ConfigAction(@NotNull VariantScope variantScope, @NotNull File outputFile) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            this.variantScope = variantScope;
            this.outputFile = outputFile;
        }
    }
}

