/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.api.AndroidBasePlugin;
import com.android.build.gradle.internal.BuildSessionImpl;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.Version;
import com.android.ide.common.util.JvmWideVariable;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.Project;

@ThreadSafe
public final class PluginInitializer {
    private static final ConcurrentMap<Object, String> projectToPluginVersionMap = (ConcurrentMap)Verify.verifyNotNull((Object)new JvmWideVariable("PLUGIN_VERSION_CHECK", "PROJECT_TO_PLUGIN_VERSION", (TypeToken)new TypeToken<ConcurrentMap<Object, String>>(){}, ConcurrentHashMap::new).get());
    private static final AtomicReference<Class<?>> loadedPluginClass = (AtomicReference)Verify.verifyNotNull((Object)new JvmWideVariable(PluginInitializer.class.getName(), "loadedPluginClass", Version.ANDROID_GRADLE_PLUGIN_VERSION, new TypeToken<AtomicReference<Class<?>>>(){}, () -> new AtomicReference<Object>(null)).get());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Project project, ProjectOptions projectOptions) {
        BuildSessionImpl.getSingleton().initialize(project.getGradle());
        BuildSessionImpl.getSingleton().executeOnceWhenBuildFinished(PluginInitializer.class.getName(), "resetPluginCheckVariables", () -> {
            projectToPluginVersionMap.clear();
            loadedPluginClass.set(null);
        });
        ConcurrentMap<Object, String> concurrentMap = projectToPluginVersionMap;
        synchronized (concurrentMap) {
            PluginInitializer.verifySamePluginVersion(projectToPluginVersionMap, project, Version.ANDROID_GRADLE_PLUGIN_VERSION);
        }
        PluginInitializer.verifyPluginLoadedOnce(loadedPluginClass, AndroidBasePlugin.class, projectOptions.get(BooleanOption.ENABLE_BUILDSCRIPT_CLASSPATH_CHECK));
    }

    static void verifySamePluginVersion(ConcurrentMap<Object, String> projectToPluginVersionMap, Project project, String pluginVersion) {
        Preconditions.checkState((!projectToPluginVersionMap.containsKey(project) ? 1 : 0) != 0, (Object)String.format("Android Gradle plugin %1$s must not be applied to project '%2$s' since version %3$s was already applied to this project", pluginVersion, project.getProjectDir().getAbsolutePath(), projectToPluginVersionMap.get(project)));
        projectToPluginVersionMap.put(project, pluginVersion);
        if (projectToPluginVersionMap.values().stream().distinct().count() > 1L) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Using multiple versions of the Android Gradle plugin in the same build is not allowed.");
            for (Map.Entry entry : projectToPluginVersionMap.entrySet()) {
                Preconditions.checkState((boolean)(entry.getKey() instanceof Project), (Object)(Project.class + " should be loaded only once"));
                Project fromProject = (Project)entry.getKey();
                String toPluginVersion = (String)entry.getValue();
                errorMessage.append(String.format("\n\t'%1$s' is using version %2$s", fromProject.getProjectDir().getAbsolutePath(), toPluginVersion));
            }
            throw new IllegalStateException(errorMessage.toString());
        }
    }

    static void verifyPluginLoadedOnce(AtomicReference<Class<?>> loadedPluginClass, Class<?> pluginClass, boolean checkEnabled) {
        loadedPluginClass.compareAndSet(null, pluginClass);
        if (checkEnabled && pluginClass != loadedPluginClass.get()) {
            throw new IllegalStateException("Due to a limitation of Gradle\u2019s new variant-aware dependency management, loading the Android Gradle plugin in different class loaders leads to a build error.\nThis can occur when the buildscript classpaths that contain the Android Gradle plugin in sub-projects, or included projects in the case of composite builds, are set differently.\nTo resolve this issue, add the Android Gradle plugin to only the buildscript classpath of the top-level build.gradle file.\nIn the case of composite builds, also make sure the build script classpaths that contain the Android Gradle plugin are identical across the main and included projects.\nIf you are using a version of Gradle that has fixed the issue, you can disable this check by setting android.enableBuildScriptClasspathCheck=false in the gradle.properties file.\nTo learn more about this issue, go to https://d.android.com/r/tools/buildscript-classpath-check.html.");
        }
    }
}

