/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.aapt;

import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.internal.aapt.Aapt;
import com.android.builder.internal.aapt.v1.AaptV1;
import com.android.builder.internal.aapt.v2.AaptV2Jni;
import com.android.builder.internal.aapt.v2.OutOfProcessAaptV2;
import com.android.builder.internal.aapt.v2.QueueableAapt2;
import com.android.builder.sdk.TargetInfo;
import com.android.builder.utils.FileCache;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.TeeProcessOutputHandler;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;

public final class AaptGradleFactory {
    private AaptGradleFactory() {
    }

    public static Aapt make(AaptGeneration aaptGeneration, AndroidBuilder builder, ProcessOutputHandler outputHandler, FileCache fileCache, boolean crunchPng, File intermediateDir, int cruncherProcesses) throws IOException {
        TargetInfo target = builder.getTargetInfo();
        Preconditions.checkNotNull((Object)target, (Object)"target == null");
        BuildToolInfo buildTools = target.getBuildTools();
        TeeProcessOutputHandler teeOutputHandler = new TeeProcessOutputHandler(new ProcessOutputHandler[]{outputHandler, new LoggedProcessOutputHandler((ILogger)new FilteringLogger(builder.getLogger()))});
        switch (aaptGeneration) {
            case AAPT_V1: {
                return new AaptV1(builder.getProcessExecutor(), (ProcessOutputHandler)teeOutputHandler, buildTools, (ILogger)new FilteringLogger(builder.getLogger()), crunchPng ? AaptV1.PngProcessMode.ALL : AaptV1.PngProcessMode.NO_CRUNCH, cruncherProcesses);
            }
            case AAPT_V2: {
                return new OutOfProcessAaptV2(builder.getProcessExecutor(), (ProcessOutputHandler)teeOutputHandler, buildTools, intermediateDir, (ILogger)new FilteringLogger(builder.getLogger()));
            }
            case AAPT_V2_JNI: {
                return new AaptV2Jni(intermediateDir, WaitableExecutor.useGlobalSharedThreadPool(), (ProcessOutputHandler)teeOutputHandler, fileCache);
            }
            case AAPT_V2_DAEMON_MODE: {
                return new QueueableAapt2((ProcessOutputHandler)teeOutputHandler, buildTools, intermediateDir, (ILogger)new FilteringLogger(builder.getLogger()), 0);
            }
        }
        throw new IllegalArgumentException("unknown aapt generation" + (Object)((Object)aaptGeneration));
    }

    public static class FilteringLogger
    implements ILogger {
        private static final List<Pattern> IGNORED_WARNINGS = Lists.newArrayList((Object[])new Pattern[]{Pattern.compile("Not recognizing known sRGB profile that has been edited")});
        private final ILogger mDelegate;

        public FilteringLogger(ILogger delegate) {
            this.mDelegate = delegate;
        }

        public void error(Throwable t, String msgFormat, Object ... args) {
            if (msgFormat != null && FilteringLogger.shouldDowngrade(msgFormat, args)) {
                this.mDelegate.info(Strings.nullToEmpty((String)msgFormat), args);
            } else {
                this.mDelegate.error(t, msgFormat, args);
            }
        }

        public void warning(String msgFormat, Object ... args) {
            if (FilteringLogger.shouldDowngrade(msgFormat, args)) {
                this.mDelegate.info(msgFormat, args);
            } else {
                this.mDelegate.warning(msgFormat, args);
            }
        }

        public void info(String msgFormat, Object ... args) {
            this.mDelegate.info(msgFormat, args);
        }

        public void verbose(String msgFormat, Object ... args) {
            this.mDelegate.verbose(msgFormat, args);
        }

        private static boolean shouldDowngrade(String msgFormat, Object ... args) {
            String message = String.format(msgFormat, args);
            for (Pattern pattern : IGNORED_WARNINGS) {
                if (!pattern.matcher(message).find()) continue;
                return true;
            }
            return false;
        }
    }
}

