/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.VariantOutput;
import com.android.build.gradle.internal.LintGradleClient;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.tasks.GroovyGradleDetector;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintBaseline;
import com.android.tools.lint.detector.api.Issue;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public abstract class LintBaseTask
extends BaseTask {
    public static final boolean MODEL_LIBRARIES = true;
    protected static final Logger LOG = Logging.getLogger(LintBaseTask.class);
    protected LintOptions lintOptions;
    protected File sdkHome;
    private boolean fatalOnly;
    protected ToolingModelBuilderRegistry toolingRegistry;
    protected File reportsDir;

    public LintOptions getLintOptions() {
        return this.lintOptions;
    }

    public File getSdkHome() {
        return this.sdkHome;
    }

    public ToolingModelBuilderRegistry getToolingRegistry() {
        return this.toolingRegistry;
    }

    protected void setFatalOnly(boolean fatalOnly) {
        this.fatalOnly = fatalOnly;
    }

    public boolean isFatalOnly() {
        return this.fatalOnly;
    }

    public File getReportsDir() {
        return this.reportsDir;
    }

    protected void abort() {
        String message = this.fatalOnly ? "Lint found fatal errors while assembling a release target.\n\nTo proceed, either fix the issues identified by lint, or modify your build script as follows:\n...\nandroid {\n    lintOptions {\n        checkReleaseBuilds false\n        // Or, if you prefer, you can continue to check for errors in release builds,\n        // but continue the build even when errors are found:\n        abortOnError false\n    }\n}\n..." : "Lint found errors in the project; aborting build.\n\nFix the issues identified by lint, or add the following to your build script to proceed with errors:\n...\nandroid {\n    lintOptions {\n        abortOnError false\n    }\n}\n...";
        throw new GradleException(message);
    }

    protected Pair<List<Warning>, LintBaseline> runLint(AndroidProject modelProject, Variant variant, VariantInputs variantInputs, boolean report) {
        Pair<List<Warning>, LintBaseline> warnings;
        BuiltinIssueRegistry registry = LintBaseTask.createIssueRegistry();
        LintCliFlags flags = new LintCliFlags();
        LintGradleClient client = new LintGradleClient((IssueRegistry)registry, flags, this.getProject(), modelProject, this.sdkHome, variant, variantInputs, this.getBuildTools());
        if (this.fatalOnly) {
            flags.setFatalOnly(true);
        }
        if (this.lintOptions != null) {
            LintBaseTask.syncOptions(this.lintOptions, client, flags, variant, this.getProject(), this.reportsDir, report, this.fatalOnly);
        }
        if (!report || this.fatalOnly) {
            flags.setQuiet(true);
        }
        flags.setWriteBaselineIfMissing(report && !this.fatalOnly);
        try {
            warnings = client.run((IssueRegistry)registry);
        }
        catch (IOException e) {
            throw new GradleException("Invalid arguments.", (Throwable)e);
        }
        if (report && client.haveErrors() && flags.isSetExitCode()) {
            this.abort();
        }
        return warnings;
    }

    protected static void syncOptions(LintOptions options, LintGradleClient client, LintCliFlags flags, Variant variant, Project project, File reportsDir, boolean report, boolean fatalOnly) {
        options.syncTo(client, flags, variant != null ? variant.getName() : null, project, reportsDir, report);
        boolean displayEmpty = !fatalOnly && !flags.isQuiet();
        for (Reporter reporter : flags.getReporters()) {
            reporter.setDisplayEmpty(displayEmpty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AndroidProject createAndroidProject(Project gradleProject) {
        String modelName = AndroidProject.class.getName();
        ToolingModelBuilder modelBuilder = this.toolingRegistry.getBuilder(modelName);
        assert (modelBuilder != null);
        ExtraPropertiesExtension ext = gradleProject.getExtensions().getExtraProperties();
        ext.set("android.injected.build.model.only.versioned", (Object)Integer.toString(3));
        ext.set("android.injected.build.model.disable.src.download", (Object)true);
        try {
            AndroidProject androidProject = (AndroidProject)modelBuilder.buildAll(modelName, gradleProject);
            return androidProject;
        }
        finally {
            ext.set("android.injected.build.model.only.versioned", null);
            ext.set("android.injected.build.model.disable.src.download", null);
        }
    }

    private static BuiltinIssueRegistry createIssueRegistry() {
        return new LintGradleIssueRegistry();
    }

    public static abstract class BaseConfigAction<T extends LintBaseTask>
    implements TaskConfigAction<T> {
        private final GlobalScope globalScope;

        public BaseConfigAction(GlobalScope globalScope) {
            this.globalScope = globalScope;
        }

        protected GlobalScope getGlobalScope() {
            return this.globalScope;
        }

        @Override
        public void execute(T lintTask) {
            lintTask.setGroup("verification");
            ((LintBaseTask)((Object)lintTask)).lintOptions = this.globalScope.getExtension().getLintOptions();
            File sdkFolder = this.globalScope.getSdkHandler().getSdkFolder();
            if (sdkFolder != null) {
                ((LintBaseTask)((Object)lintTask)).sdkHome = sdkFolder;
            }
            ((LintBaseTask)((Object)lintTask)).toolingRegistry = this.globalScope.getToolingRegistry();
            ((LintBaseTask)((Object)lintTask)).reportsDir = this.globalScope.getReportsDir();
            ((BaseTask)((Object)lintTask)).setAndroidBuilder(this.globalScope.getAndroidBuilder());
        }
    }

    public static class VariantInputs {
        private final String name;
        private final FileCollection localLintJarCollection;
        private final FileCollection dependencyLintJarCollection;
        private final FileCollection mergedManifest;
        private final FileCollection mergedManifestReport;
        private List<File> lintRuleJars;
        private final ConfigurableFileCollection allInputs;

        public VariantInputs(VariantScope variantScope) {
            this.name = variantScope.getFullVariantName();
            this.allInputs = variantScope.getGlobalScope().getProject().files(new Object[0]);
            Object[] objectArray = new Object[1];
            this.localLintJarCollection = variantScope.getGlobalScope().getOutput(TaskOutputHolder.TaskOutputType.LINT_JAR);
            objectArray[0] = this.localLintJarCollection;
            this.allInputs.from(objectArray);
            Object[] objectArray2 = new Object[1];
            this.dependencyLintJarCollection = variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.LINT);
            objectArray2[0] = this.dependencyLintJarCollection;
            this.allInputs.from(objectArray2);
            if (variantScope.hasOutput(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS)) {
                this.mergedManifest = variantScope.getOutput(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS);
            } else if (variantScope.hasOutput(TaskOutputHolder.TaskOutputType.LIBRARY_MANIFEST)) {
                this.mergedManifest = variantScope.getOutput(TaskOutputHolder.TaskOutputType.LIBRARY_MANIFEST);
            } else {
                throw new RuntimeException("VariantInputs initialized with no merged manifest on: " + variantScope.getVariantConfiguration().getType());
            }
            this.allInputs.from(new Object[]{this.mergedManifest});
            if (!variantScope.hasOutput(TaskOutputHolder.TaskOutputType.MANIFEST_MERGE_REPORT)) {
                throw new RuntimeException("VariantInputs initialized with no merged manifest report on: " + variantScope.getVariantConfiguration().getType());
            }
            Object[] objectArray3 = new Object[1];
            this.mergedManifestReport = variantScope.getOutput(TaskOutputHolder.TaskOutputType.MANIFEST_MERGE_REPORT);
            objectArray3[0] = this.mergedManifestReport;
            this.allInputs.from(objectArray3);
            this.allInputs.from(new Object[]{variantScope.getOutput(TaskOutputHolder.AnchorOutputType.ALL_CLASSES)});
            if (variantScope.hasOutput(TaskOutputHolder.TaskOutputType.APK)) {
                this.allInputs.from(new Object[]{variantScope.getOutput(TaskOutputHolder.TaskOutputType.APK)});
            }
        }

        public String getName() {
            return this.name;
        }

        public FileCollection getAllInputs() {
            return this.allInputs;
        }

        public List<File> getRuleJars() {
            if (this.lintRuleJars == null) {
                this.lintRuleJars = Streams.concat((Stream[])new Stream[]{this.dependencyLintJarCollection.getFiles().stream(), this.localLintJarCollection.getFiles().stream()}).filter(File::isFile).collect(Collectors.toList());
            }
            return this.lintRuleJars;
        }

        public File getMergedManifest() {
            File file = this.mergedManifest.getSingleFile();
            if (file.isFile()) {
                return file;
            }
            Collection<BuildOutput> manifests = BuildOutputs.load((Collection<TaskOutputHolder.OutputType>)ImmutableList.of((Object)TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS), file);
            if (manifests.isEmpty()) {
                throw new RuntimeException("Can't find any manifest in folder: " + file);
            }
            Optional<File> mainManifest = manifests.stream().filter(buildOutput -> buildOutput.getApkInfo().getType() == VariantOutput.OutputType.MAIN).map(BuildOutput::getOutputFile).findFirst();
            if (mainManifest.isPresent()) {
                return mainManifest.get();
            }
            Optional<File> universalSplit = manifests.stream().filter(output -> output.getApkInfo().getType() == VariantOutput.OutputType.FULL_SPLIT && output.getFilters().isEmpty()).map(BuildOutput::getOutputFile).findFirst();
            return universalSplit.orElseGet(() -> ((BuildOutput)manifests.iterator().next()).getOutputFile());
        }

        public File getManifestMergeReport() {
            if (this.mergedManifestReport == null) {
                return null;
            }
            return this.mergedManifestReport.getSingleFile();
        }
    }

    private static class LintGradleIssueRegistry
    extends BuiltinIssueRegistry {
        private boolean mInitialized;

        public List<Issue> getIssues() {
            List issues = super.getIssues();
            if (!this.mInitialized) {
                this.mInitialized = true;
                for (Issue issue : issues) {
                    if (issue.getImplementation().getDetectorClass() != GradleDetector.class) continue;
                    issue.setImplementation(GroovyGradleDetector.IMPLEMENTATION);
                }
            }
            return issues;
        }
    }
}

