/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.gradle.api.AnnotationProcessorOptions;
import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.tasks.factory.AbstractCompilesUtil;
import com.android.build.gradle.tasks.factory.AndroidJavaCompile;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import java.io.File;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.compile.AbstractCompile;

public class JavaCompileConfigAction
implements TaskConfigAction<AndroidJavaCompile> {
    private static final ILogger LOG = LoggerWrapper.getLogger(JavaCompileConfigAction.class);
    private final VariantScope scope;
    private final File outputFolder;

    public JavaCompileConfigAction(VariantScope scope, File outputFolder) {
        this.scope = scope;
        this.outputFolder = outputFolder;
    }

    @Override
    public String getName() {
        return this.scope.getTaskName("compile", "JavaWithJavac");
    }

    @Override
    public Class<AndroidJavaCompile> getType() {
        return AndroidJavaCompile.class;
    }

    @Override
    public void execute(AndroidJavaCompile javacTask) {
        this.scope.getVariantData().javacTask = javacTask;
        this.scope.getVariantData().javaCompilerTask = javacTask;
        GlobalScope globalScope = this.scope.getGlobalScope();
        Project project = globalScope.getProject();
        javacTask.compileSdkVersion = globalScope.getExtension().getCompileSdkVersion();
        javacTask.mInstantRunBuildContext = this.scope.getInstantRunBuildContext();
        for (ConfigurableFileTree fileTree : this.scope.getVariantData().getJavaSources()) {
            javacTask.source(new Object[]{fileTree});
        }
        boolean keepDefaultBootstrap = this.scope.keepDefaultBootstrap();
        if (!keepDefaultBootstrap) {
            javacTask.getOptions().setBootClasspath(Joiner.on((String)File.pathSeparator).join((Iterable)globalScope.getAndroidBuilder().getBootClasspathAsStrings(false)));
        }
        FileCollection classpath = this.scope.getJavaClasspath(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.CLASSES);
        if (keepDefaultBootstrap) {
            classpath = classpath.plus((FileCollection)project.files(new Object[]{globalScope.getAndroidBuilder().getBootClasspath(false)}));
        }
        javacTask.setClasspath(classpath);
        javacTask.setDestinationDir(this.outputFolder);
        CompileOptions compileOptions = globalScope.getExtension().getCompileOptions();
        AbstractCompilesUtil.configureLanguageLevel((AbstractCompile)javacTask, compileOptions, globalScope.getExtension().getCompileSdkVersion(), this.scope.getJava8LangSupportType());
        javacTask.getOptions().setEncoding(compileOptions.getEncoding());
        Configuration annotationProcessorConfiguration = this.scope.getVariantDependencies().getAnnotationProcessorConfiguration();
        Boolean includeCompileClasspath = this.scope.getVariantConfiguration().getJavaCompileOptions().getAnnotationProcessorOptions().getIncludeCompileClasspath();
        FileCollection processorPath = this.scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.ANNOTATION_PROCESSOR, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JAR);
        if (Boolean.TRUE.equals(includeCompileClasspath)) {
            processorPath = processorPath.plus(this.scope.getJavaClasspath(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.JAR));
        }
        javacTask.getOptions().setAnnotationProcessorPath(processorPath);
        boolean incremental = AbstractCompilesUtil.isIncremental(project, this.scope, compileOptions, null, LOG);
        if (incremental) {
            LOG.verbose("Using incremental javac compilation for %1$s %2$s.", new Object[]{project.getPath(), this.scope.getFullVariantName()});
            javacTask.getOptions().setIncremental(true);
        } else {
            LOG.verbose("Not using incremental javac compilation for %1$s %2$s.", new Object[]{project.getPath(), this.scope.getFullVariantName()});
        }
        AnnotationProcessorOptions annotationProcessorOptions = this.scope.getVariantConfiguration().getJavaCompileOptions().getAnnotationProcessorOptions();
        if (!annotationProcessorOptions.getClassNames().isEmpty()) {
            javacTask.getOptions().getCompilerArgs().add("-processor");
            javacTask.getOptions().getCompilerArgs().add(Joiner.on((char)',').join(annotationProcessorOptions.getClassNames()));
        }
        if (!annotationProcessorOptions.getArguments().isEmpty()) {
            for (Map.Entry<String, String> arg : annotationProcessorOptions.getArguments().entrySet()) {
                javacTask.getOptions().getCompilerArgs().add("-A" + arg.getKey() + "=" + arg.getValue());
            }
        }
        javacTask.getOptions().getCompilerArgs().add("-s");
        javacTask.getOptions().getCompilerArgs().add(this.scope.getAnnotationProcessorOutputDir().getAbsolutePath());
        javacTask.annotationProcessorOutputFolder = this.scope.getAnnotationProcessorOutputDir();
        if (this.scope.getGlobalScope().getExtension().getDataBinding().isEnabled() && this.scope.hasOutput(TaskOutputHolder.TaskOutputType.DATA_BINDING_DEPENDENCY_ARTIFACTS)) {
            javacTask.dataBindingDependencyArtifacts = this.scope.getOutput(TaskOutputHolder.TaskOutputType.DATA_BINDING_DEPENDENCY_ARTIFACTS);
        }
        javacTask.processorListFile = this.scope.getOutput(TaskOutputHolder.TaskOutputType.ANNOTATION_PROCESSOR_LIST);
        javacTask.variantName = this.scope.getFullVariantName();
    }
}

