/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.ApplicationTaskManager;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.CodeShrinker;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.test.TestApplicationTestData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.CheckTestedAppObfuscation;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.ProcessTestManifest;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.profile.Recorder;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceProvider;
import com.android.manifmerger.ManifestMerger2;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.file.FileCollection;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class TestApplicationTaskManager
extends ApplicationTaskManager {
    private FileCollection mTargetManifestConfiguration = null;

    public TestApplicationTaskManager(GlobalScope globalScope, Project project, ProjectOptions projectOptions, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(globalScope, project, projectOptions, androidBuilder, dataBindingBuilder, extension, sdkHandler, toolingRegistry, recorder);
    }

    @Override
    public void createTasksForVariantScope(TaskFactory tasks, VariantScope variantScope) {
        super.createTasksForVariantScope(tasks, variantScope);
        Configuration runtimeClasspath = variantScope.getVariantDependencies().getRuntimeClasspath();
        ResolvableDependencies incomingRuntimeClasspath = runtimeClasspath.getIncoming();
        FileCollection testingApk = variantScope.getOutput(TaskOutputHolder.TaskOutputType.APK);
        FileCollection testedApks = incomingRuntimeClasspath.artifactView(config -> {
            ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config.attributes(container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)AndroidArtifacts.ArtifactType.APK.getType()));
        }).getFiles();
        FileCollection testedManifestMetadata = this.getTestedManifestMetadata(variantScope.getVariantData());
        TestApplicationTestData testData = new TestApplicationTestData(variantScope.getVariantConfiguration(), variantScope.getVariantData().getApplicationId(), testingApk, testedApks);
        this.configureTestData(testData);
        AndroidTask<DeviceProviderInstrumentTestTask> instrumentTestTask = this.getAndroidTasks().create(tasks, new DeviceProviderInstrumentTestTask.ConfigAction(variantScope, (DeviceProvider)new ConnectedDeviceProvider(this.sdkHandler.getSdkInfo().getAdb(), this.extension.getAdbOptions().getTimeOutInMs(), (ILogger)new LoggerWrapper(this.getLogger())), testData, testedManifestMetadata){

            @Override
            public String getName() {
                return super.getName() + VariantType.ANDROID_TEST.getSuffix();
            }
        });
        Task connectedAndroidTest = tasks.named("connected" + VariantType.ANDROID_TEST.getSuffix());
        if (connectedAndroidTest != null) {
            connectedAndroidTest.dependsOn(new Object[]{instrumentTestTask.getName()});
        }
    }

    @Override
    protected void postJavacCreation(TaskFactory tasks, VariantScope scope) {
    }

    @Override
    public void createLintTasks(TaskFactory tasks, VariantScope scope) {
    }

    @Override
    public void createGlobalLintTask(TaskFactory tasks) {
    }

    @Override
    public void configureGlobalLintTask(Collection<VariantScope> variants) {
    }

    @Override
    protected boolean isTestedAppObfuscated(VariantScope variantScope) {
        return variantScope.getCodeShrinker() == CodeShrinker.PROGUARD;
    }

    @Override
    protected void maybeCreateJavaCodeShrinkerTransform(TaskFactory taskFactory, VariantScope variantScope) {
        if (this.isTestedAppObfuscated(variantScope)) {
            this.doCreateJavaCodeShrinkerTransform(taskFactory, variantScope, CodeShrinker.PROGUARD, variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.APK_MAPPING));
        } else {
            AndroidTask<CheckTestedAppObfuscation> checkObfuscation = this.androidTasks.create(taskFactory, new CheckTestedAppObfuscation.ConfigAction(variantScope));
            Preconditions.checkNotNull(variantScope.getJavacTask());
            variantScope.getJavacTask().dependsOn(taskFactory, checkObfuscation);
        }
    }

    private FileCollection getTestedManifestMetadata(BaseVariantData variantData) {
        if (this.mTargetManifestConfiguration == null) {
            this.mTargetManifestConfiguration = variantData.getVariantDependency().getCompileClasspath().getIncoming().artifactView(config -> {
                ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config.attributes(container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)AndroidArtifacts.ArtifactType.MANIFEST_METADATA.getType()));
            }).getFiles();
        }
        return this.mTargetManifestConfiguration;
    }

    @Override
    protected AndroidTask<? extends ManifestProcessorTask> createMergeManifestTask(TaskFactory tasks, VariantScope variantScope, ImmutableList.Builder<ManifestMerger2.Invoker.Feature> optionalFeatures) {
        return this.getAndroidTasks().create(tasks, new ProcessTestManifest.ConfigAction(variantScope, this.getTestedManifestMetadata(variantScope.getVariantData())));
    }

    @Override
    protected AndroidTask<? extends DefaultTask> createVariantPreBuildTask(TaskFactory tasks, VariantScope scope) {
        return this.createDefaultPreBuildTask(tasks, scope);
    }
}

