/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.externalBuild;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.InstantRunTaskManager;
import com.android.build.gradle.internal.TaskContainerAdaptor;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.externalBuild.ExternalBuildAnchorTask;
import com.android.build.gradle.internal.externalBuild.ExternalBuildContext;
import com.android.build.gradle.internal.externalBuild.ExternalBuildExtension;
import com.android.build.gradle.internal.externalBuild.ExternalBuildGlobalScope;
import com.android.build.gradle.internal.externalBuild.ExternalBuildManifestLoader;
import com.android.build.gradle.internal.externalBuild.ExternalBuildPackagingScope;
import com.android.build.gradle.internal.externalBuild.ExternalBuildVariantScope;
import com.android.build.gradle.internal.incremental.BuildInfoLoaderTask;
import com.android.build.gradle.internal.incremental.BuildInfoWriterTask;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.OriginalStream;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.AndroidTaskRegistry;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.OutputFactory;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.transforms.ExtractJarsTransform;
import com.android.build.gradle.internal.transforms.InstantRunSliceSplitApkBuilder;
import com.android.build.gradle.internal.transforms.PreDexTransform;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.build.gradle.tasks.PreColdSwapTask;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DefaultDexOptions;
import com.android.builder.core.DefaultManifestParser;
import com.android.builder.core.DexOptions;
import com.android.builder.core.ManifestAttributeSupplier;
import com.android.builder.dexing.DexingType;
import com.android.builder.internal.aapt.AaptOptions;
import com.android.builder.profile.Recorder;
import com.android.ide.common.build.ApkData;
import com.android.ide.common.build.ApkInfo;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.Charsets;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

class ExternalBuildTaskManager {
    private final ExternalBuildGlobalScope globalScope;
    private final Project project;
    private final AndroidTaskRegistry androidTasks;
    private final TaskContainerAdaptor tasks;
    private final Recorder recorder;

    ExternalBuildTaskManager(ExternalBuildGlobalScope globalScope, Project project, Recorder recorder) {
        this.globalScope = globalScope;
        this.project = project;
        this.tasks = new TaskContainerAdaptor(project.getTasks());
        this.recorder = recorder;
        this.androidTasks = new AndroidTaskRegistry();
    }

    void createTasks(ExternalBuildExtension externalBuildExtension) throws Exception {
        AndroidTask<ExternalBuildAnchorTask> externalBuildAnchorTask = this.androidTasks.create(this.tasks, new ExternalBuildAnchorTask.ConfigAction());
        ExternalBuildContext externalBuildContext = new ExternalBuildContext(externalBuildExtension);
        File file = this.project.file((Object)externalBuildExtension.buildManifestPath);
        ExternalBuildManifestLoader.loadAndPopulateContext(new File(externalBuildExtension.getExecutionRoot()), file, this.project, this.globalScope.getProjectOptions(), externalBuildContext);
        ExtraModelInfo modelInfo = new ExtraModelInfo(this.globalScope.getProjectOptions(), this.project.getLogger());
        TransformManager transformManager = new TransformManager(this.project, this.androidTasks, modelInfo, this.recorder);
        transformManager.addStream(OriginalStream.builder(this.project, "project-classes").addContentType((QualifiedContent.ContentType)QualifiedContent.DefaultContentType.CLASSES).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setJars(externalBuildContext::getInputJarFiles).build());
        transformManager.addStream(OriginalStream.builder(this.project, "project-res").addContentType((QualifiedContent.ContentType)QualifiedContent.DefaultContentType.RESOURCES).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFolder(new File(this.project.getBuildDir(), "temp/streams/resources")).build());
        transformManager.addStream(OriginalStream.builder(this.project, "project-jni\u2013libs").addContentType(ExtendedContentType.NATIVE_LIBS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFolder(new File(this.project.getBuildDir(), "temp/streams/native_libs")).build());
        File androidManifestFile = new File(externalBuildContext.getExecutionRoot(), externalBuildContext.getBuildManifest().getAndroidManifest().getExecRootPath());
        File processedAndroidResourcesFile = new File(externalBuildContext.getExecutionRoot(), externalBuildContext.getBuildManifest().getResourceApk().getExecRootPath());
        OutputFactory.DefaultApkData mainApkData = new OutputFactory.DefaultApkData(VariantOutput.OutputType.MAIN, "", "main", "main", "main", "debug.apk", (ImmutableList<FilterData>)ImmutableList.of());
        ExternalBuildVariantScope variantScope = new ExternalBuildVariantScope(this.globalScope, this.project.getBuildDir(), externalBuildContext, new AaptOptions(null, false, null), (ManifestAttributeSupplier)new DefaultManifestParser(androidManifestFile), (Collection<ApkData>)ImmutableList.of((Object)((Object)mainApkData)));
        ExtractJarsTransform extractJarsTransform = new ExtractJarsTransform((Set<QualifiedContent.ContentType>)ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES), (Set<QualifiedContent.Scope>)ImmutableSet.of((Object)QualifiedContent.Scope.PROJECT));
        Optional<AndroidTask<TransformTask>> extractJarsTask = transformManager.addTransform(this.tasks, variantScope, extractJarsTransform);
        InstantRunTaskManager instantRunTaskManager = new InstantRunTaskManager(this.project.getLogger(), variantScope, transformManager, this.androidTasks, this.tasks, this.recorder);
        File manifest = this.createBuildOutputs(androidManifestFile.getParentFile(), mainApkData, TaskOutputHolder.TaskOutputType.INSTANT_RUN_MERGED_MANIFESTS, androidManifestFile);
        File resources = this.createBuildOutputs(processedAndroidResourcesFile.getParentFile(), mainApkData, TaskOutputHolder.TaskOutputType.PROCESSED_RES, processedAndroidResourcesFile);
        AndroidTask<BuildInfoLoaderTask> buildInfoLoaderTask = instantRunTaskManager.createInstantRunAllTasks((DexOptions)new com.android.build.gradle.internal.dsl.DexOptions(modelInfo), () -> ((AndroidBuilder)externalBuildContext.getAndroidBuilder()).getDexByteCodeConverter(), extractJarsTask.orElse(null), externalBuildAnchorTask, EnumSet.of(QualifiedContent.Scope.PROJECT), (FileCollection)this.project.files(new Object[]{manifest}), (FileCollection)this.project.files(new Object[]{resources}), false, 1);
        extractJarsTask.ifPresent(t -> t.dependsOn((TaskFactory)this.tasks, buildInfoLoaderTask));
        AndroidTask<PreColdSwapTask> preColdswapTask = instantRunTaskManager.createPreColdswapTask(this.globalScope.getProjectOptions());
        if (variantScope.getInstantRunBuildContext().getPatchingPolicy() != InstantRunPatchingPolicy.PRE_LOLLIPOP) {
            instantRunTaskManager.createSlicerTask();
        }
        this.createDexTasks(externalBuildContext, transformManager, variantScope);
        SigningConfig manifestSigningConfig = ExternalBuildTaskManager.createManifestSigningConfig(externalBuildContext);
        ExternalBuildPackagingScope packagingScope = new ExternalBuildPackagingScope(this.project, externalBuildContext, variantScope, transformManager, manifestSigningConfig);
        OutputScope outputScope = packagingScope.getOutputScope();
        outputScope.addOutputForSplit(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, mainApkData, androidManifestFile);
        outputScope.addOutputForSplit(TaskOutputHolder.TaskOutputType.INSTANT_RUN_MERGED_MANIFESTS, mainApkData, androidManifestFile);
        outputScope.addOutputForSplit(TaskOutputHolder.TaskOutputType.PROCESSED_RES, mainApkData, processedAndroidResourcesFile);
        packagingScope.addTaskOutput(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, androidManifestFile, null);
        File assetsFolder = FileUtils.join((File)this.project.getBuildDir(), (String[])new String[]{"__external_assets__"});
        packagingScope.addTaskOutput(TaskOutputHolder.TaskOutputType.MERGED_ASSETS, assetsFolder, null);
        Logger logger = Logging.getLogger(ExternalBuildTaskManager.class);
        InstantRunSliceSplitApkBuilder slicesApkBuilder = new InstantRunSliceSplitApkBuilder(logger, this.project, variantScope.getInstantRunBuildContext(), externalBuildContext.getAndroidBuilder(), this.globalScope.getBuildCache(), packagingScope, packagingScope.getSigningConfig(), AaptGeneration.fromProjectOptions(this.globalScope.getProjectOptions()), packagingScope.getAaptOptions(), packagingScope.getInstantRunSplitApkOutputFolder(), packagingScope.getInstantRunSupportDir(), new File(packagingScope.getIncrementalDir("InstantRunSliceSplitApkBuilder"), "aapt-temp"), null);
        Optional<AndroidTask<TransformTask>> transformTaskAndroidTask = transformManager.addTransform(this.tasks, variantScope, slicesApkBuilder);
        AndroidTask<PackageApplication> packageApp = this.androidTasks.create(this.tasks, new PackageApplication.StandardConfigAction(packagingScope, FileUtils.join((File)this.globalScope.getBuildDir(), (String[])new String[]{"outputs", "apk"}), variantScope.getInstantRunBuildContext().getPatchingPolicy(), TaskOutputHolder.TaskOutputType.MERGED_RES, (FileCollection)this.project.files(new Object[]{processedAndroidResourcesFile}), (FileCollection)this.project.files(new Object[]{androidManifestFile}), TaskOutputHolder.TaskOutputType.INSTANT_RUN_MERGED_MANIFESTS, variantScope.getOutputScope(), this.globalScope.getBuildCache(), TaskOutputHolder.TaskOutputType.APK));
        transformTaskAndroidTask.ifPresent(transformTaskAndroidTask1 -> packageApp.dependsOn((TaskFactory)this.tasks, (AndroidTask<?>)transformTaskAndroidTask1));
        variantScope.setPackageApplicationTask(packageApp);
        AndroidTask<BuildInfoWriterTask> buildInfoWriterTask = this.androidTasks.create(this.tasks, new BuildInfoWriterTask.ConfigAction(variantScope, logger));
        instantRunTaskManager.configureBuildInfoWriterTask(buildInfoWriterTask, packageApp);
        externalBuildAnchorTask.dependsOn((TaskFactory)this.tasks, packageApp);
        externalBuildAnchorTask.dependsOn((TaskFactory)this.tasks, buildInfoWriterTask);
        for (AndroidTask<? extends DefaultTask> task : variantScope.getColdSwapBuildTasks()) {
            task.dependsOn((TaskFactory)this.tasks, preColdswapTask);
        }
    }

    private File createBuildOutputs(File parentFolder, ApkData apkData, TaskOutputHolder.TaskOutputType outputType, File file) throws IOException {
        File output = new File(parentFolder, outputType.name());
        FileUtils.mkdirs((File)output);
        BuildOutput buildOutput = new BuildOutput(outputType, (ApkInfo)apkData, file);
        String buildOutputs = BuildOutputs.persist(output.toPath(), (ImmutableList<TaskOutputHolder.OutputType>)ImmutableList.of((Object)outputType), (SetMultimap<TaskOutputHolder.OutputType, BuildOutput>)ImmutableSetMultimap.of((Object)outputType, (Object)buildOutput));
        Files.write((CharSequence)buildOutputs, (File)BuildOutputs.getMetadataFile(output), (Charset)Charsets.UTF_8);
        return output;
    }

    private void createDexTasks(ExternalBuildContext externalBuildContext, TransformManager transformManager, ExternalBuildVariantScope variantScope) {
        AndroidBuilder androidBuilder = externalBuildContext.getAndroidBuilder();
        DexingType dexingType = DexingType.NATIVE_MULTIDEX;
        PreDexTransform preDexTransform = new PreDexTransform((DexOptions)new DefaultDexOptions(), androidBuilder, variantScope.getGlobalScope().getBuildCache(), dexingType, 1);
        transformManager.addTransform(this.tasks, variantScope, preDexTransform);
    }

    private static SigningConfig createManifestSigningConfig(ExternalBuildContext externalBuildContext) {
        SigningConfig config = new SigningConfig("externalBuild");
        config.setStorePassword("android");
        config.setKeyAlias("AndroidDebugKey");
        config.setKeyPassword("android");
        File keystore = new File(externalBuildContext.getExecutionRoot(), externalBuildContext.getBuildManifest().getDebugKeystore().getExecRootPath());
        Preconditions.checkState((boolean)keystore.isFile(), (String)"Keystore file from the manifest (%s) does not exist.", (Object)keystore.getAbsolutePath());
        config.setStoreFile(keystore);
        return config;
    }
}

