/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidTestTask;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.TestReport;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.core.BuilderConstants;
import com.android.builder.sdk.TargetInfo;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.OnDeviceOrchestratorTestRunner;
import com.android.builder.testing.ShardedTestRunner;
import com.android.builder.testing.SimpleTestRunner;
import com.android.builder.testing.TestData;
import com.android.builder.testing.TestRunner;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.DeviceProvider;
import com.android.builder.testing.api.TestException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.FileUtils;
import com.android.utils.StringHelper;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Nullable;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.logging.ConsoleRenderer;
import org.xml.sax.SAXException;

public class DeviceProviderInstrumentTestTask
extends BaseTask
implements AndroidTestTask {
    private static final Predicate<File> IS_APK = file -> "apk".equals(Files.getFileExtension((String)file.getName()));
    private DeviceProvider deviceProvider;
    private File coverageDir;
    private File reportsDir;
    private File resultsDir;
    private FileCollection buddyApks;
    private FileCollection testTargetManifests;
    private ProcessExecutor processExecutor;
    private String flavorName;
    private Supplier<File> splitSelectExec;
    private AbstractTestDataImpl testData;
    private TestRunnerFactory testRunnerFactory;
    private boolean ignoreFailures;
    private boolean testFailed;
    @Nullable
    private Collection<String> installOptions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    protected void runTests() throws DeviceException, IOException, InterruptedException, TestRunner.NoAuthorizedDeviceFoundException, TestException, ParserConfigurationException, SAXException {
        boolean success;
        DeviceProviderInstrumentTestTask.checkForNonApks(this.buddyApks.getFiles(), message -> {
            throw new InvalidUserDataException(message);
        });
        File resultsOutDir = this.getResultsDir();
        FileUtils.cleanOutputDir((File)resultsOutDir);
        File coverageOutDir = this.getCoverageDir();
        FileUtils.cleanOutputDir((File)coverageOutDir);
        if (!this.testTargetManifests.isEmpty()) {
            this.testData.loadFromMetadataFile(this.testTargetManifests.getSingleFile());
        }
        if (!this.testsFound()) {
            this.getLogger().info("No tests found, nothing to do.");
            File emptyCoverageFile = new File(coverageOutDir, "coverage.ec");
            emptyCoverageFile.createNewFile();
            success = true;
        } else {
            this.deviceProvider.init();
            TestRunner testRunner = this.testRunnerFactory.build(this.splitSelectExec.get(), this.getProcessExecutor());
            ImmutableList extraArgs = this.installOptions == null || this.installOptions.isEmpty() ? ImmutableList.of() : this.installOptions;
            try {
                success = testRunner.runTests(this.getProject().getName(), this.getFlavorName(), (TestData)this.testData, this.buddyApks.getFiles(), this.deviceProvider.getDevices(), this.deviceProvider.getTimeoutInMs(), (Collection)extraArgs, resultsOutDir, coverageOutDir, this.getILogger());
            }
            finally {
                this.deviceProvider.terminate();
            }
        }
        File reportOutDir = this.getReportsDir();
        FileUtils.cleanOutputDir((File)reportOutDir);
        TestReport report = new TestReport(ReportType.SINGLE_FLAVOR, resultsOutDir, reportOutDir);
        report.generateReport();
        if (!success) {
            this.testFailed = true;
            String reportUrl = new ConsoleRenderer().asClickableFileUrl(new File(reportOutDir, "index.html"));
            String message2 = "There were failing tests. See the report at: " + reportUrl;
            if (this.getIgnoreFailures()) {
                this.getLogger().warn(message2);
                return;
            }
            throw new GradleException(message2);
        }
        this.testFailed = false;
    }

    public static void checkForNonApks(Collection<File> buddyApksFiles, Consumer<String> errorHandler) {
        List nonApks = buddyApksFiles.stream().filter(IS_APK.negate()).collect(Collectors.toList());
        if (!nonApks.isEmpty()) {
            Collections.sort(nonApks);
            String message = String.format("Not all files in %s configuration are APKs: %s", "androidTestUtil", Joiner.on((char)' ').join(nonApks));
            errorHandler.accept(message);
        }
    }

    private boolean testsFound() {
        return !this.getProject().files(new Object[]{this.testData.getTestDirectories()}).getAsFileTree().isEmpty();
    }

    public File getReportsDir() {
        return this.reportsDir;
    }

    public void setReportsDir(File reportsDir) {
        this.reportsDir = reportsDir;
    }

    @Override
    public File getResultsDir() {
        return this.resultsDir;
    }

    public void setResultsDir(File resultsDir) {
        this.resultsDir = resultsDir;
    }

    @OutputDirectory
    public File getCoverageDir() {
        return this.coverageDir;
    }

    public void setCoverageDir(File coverageDir) {
        this.coverageDir = coverageDir;
    }

    public String getFlavorName() {
        return this.flavorName;
    }

    public void setFlavorName(String flavorName) {
        this.flavorName = flavorName;
    }

    public Collection<String> getInstallOptions() {
        return this.installOptions;
    }

    public void setInstallOptions(Collection<String> installOptions) {
        this.installOptions = installOptions;
    }

    public DeviceProvider getDeviceProvider() {
        return this.deviceProvider;
    }

    public void setDeviceProvider(DeviceProvider deviceProvider) {
        this.deviceProvider = deviceProvider;
    }

    public AbstractTestDataImpl getTestData() {
        return this.testData;
    }

    public void setTestData(AbstractTestDataImpl testData) {
        this.testData = testData;
    }

    @InputFile
    public File getSplitSelectExec() {
        return this.splitSelectExec.get();
    }

    public ProcessExecutor getProcessExecutor() {
        return this.processExecutor;
    }

    public void setProcessExecutor(ProcessExecutor processExecutor) {
        this.processExecutor = processExecutor;
    }

    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    @Override
    public boolean getTestFailed() {
        return this.testFailed;
    }

    @InputFiles
    FileCollection getTestTargetManifests() {
        return this.testTargetManifests;
    }

    @InputFiles
    public FileCollection getBuddyApks() {
        return this.buddyApks;
    }

    @InputFiles
    FileCollection getTestApkDir() {
        return this.testData.getTestApkDir();
    }

    @InputFiles
    @Optional
    FileCollection getTestedApksDir() {
        return this.testData.getTestedApksDir();
    }

    public static class ConfigAction
    implements TaskConfigAction<DeviceProviderInstrumentTestTask> {
        private final VariantScope scope;
        private final DeviceProvider deviceProvider;
        private final AbstractTestDataImpl testData;
        private final FileCollection testTargetManifests;

        public ConfigAction(VariantScope scope, DeviceProvider deviceProvider, AbstractTestDataImpl testData, FileCollection testTargetManifests) {
            this.scope = scope;
            this.deviceProvider = deviceProvider;
            this.testData = testData;
            this.testTargetManifests = testTargetManifests;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName(this.deviceProvider.getName());
        }

        @Override
        public Class<DeviceProviderInstrumentTestTask> getType() {
            return DeviceProviderInstrumentTestTask.class;
        }

        @Override
        public void execute(DeviceProviderInstrumentTestTask task) {
            String variantName;
            Project project = this.scope.getGlobalScope().getProject();
            ProjectOptions projectOptions = this.scope.getGlobalScope().getProjectOptions();
            boolean connected = this.deviceProvider instanceof ConnectedDeviceProvider;
            String string = variantName = this.scope.getTestedVariantData() != null ? this.scope.getTestedVariantData().getName() : this.scope.getVariantData().getName();
            if (connected) {
                task.setDescription("Installs and runs the tests for " + variantName + " on connected devices.");
            } else {
                task.setDescription("Installs and runs the tests for " + variantName + " using provider: " + StringHelper.capitalize((String)this.deviceProvider.getName()));
            }
            task.setGroup("verification");
            task.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            task.setVariantName(variantName);
            task.setTestData(this.testData);
            task.setFlavorName(this.testData.getFlavorName());
            task.setDeviceProvider(this.deviceProvider);
            task.testTargetManifests = this.testTargetManifests;
            task.setInstallOptions(this.scope.getGlobalScope().getExtension().getAdbOptions().getInstallOptions());
            task.setProcessExecutor(this.scope.getGlobalScope().getAndroidBuilder().getProcessExecutor());
            boolean shardBetweenDevices = projectOptions.get(BooleanOption.ENABLE_TEST_SHARDING);
            switch (this.scope.getGlobalScope().getExtension().getTestOptions().getExecutionEnum()) {
                case ANDROID_TEST_ORCHESTRATOR: {
                    Preconditions.checkArgument((!shardBetweenDevices ? 1 : 0) != 0, (Object)"Sharding is not supported with Odo.");
                    task.testRunnerFactory = OnDeviceOrchestratorTestRunner::new;
                    break;
                }
                case HOST: {
                    if (shardBetweenDevices) {
                        Integer numShards = projectOptions.get(IntegerOption.ANDROID_TEST_SHARD_COUNT);
                        task.testRunnerFactory = (splitSelect, processExecutor) -> new ShardedTestRunner(splitSelect, processExecutor, numShards);
                        break;
                    }
                    task.testRunnerFactory = SimpleTestRunner::new;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown value " + this.scope.getGlobalScope().getExtension().getTestOptions().getExecutionEnum()));
                }
            }
            String flavorFolder = this.testData.getFlavorName();
            if (!flavorFolder.isEmpty()) {
                flavorFolder = "flavors/" + flavorFolder;
            }
            String providerFolder = connected ? "connected" : "device/" + this.deviceProvider.getName();
            String subFolder = "/" + providerFolder + "/" + flavorFolder;
            task.splitSelectExec = TaskInputHelper.memoize(() -> {
                String path;
                TargetInfo info = this.scope.getGlobalScope().getAndroidBuilder().getTargetInfo();
                String string = path = info == null ? null : info.getBuildTools().getPath(BuildToolInfo.PathId.SPLIT_SELECT);
                if (path != null) {
                    File splitSelectExe = new File(path);
                    return splitSelectExe.exists() ? splitSelectExe : null;
                }
                return null;
            });
            String rootLocation = this.scope.getGlobalScope().getExtension().getTestOptions().getResultsDir();
            if (rootLocation == null) {
                rootLocation = this.scope.getGlobalScope().getBuildDir() + "/" + "outputs" + "/" + BuilderConstants.FD_ANDROID_RESULTS;
            }
            task.resultsDir = project.file((Object)(rootLocation + subFolder));
            rootLocation = this.scope.getGlobalScope().getExtension().getTestOptions().getReportDir();
            if (rootLocation == null) {
                rootLocation = this.scope.getGlobalScope().getBuildDir() + "/" + "reports" + "/" + "androidTests";
            }
            task.reportsDir = project.file((Object)(rootLocation + subFolder));
            rootLocation = this.scope.getGlobalScope().getBuildDir() + "/" + "outputs" + "/code-coverage";
            task.setCoverageDir(project.file((Object)(rootLocation + subFolder)));
            if (this.scope.getVariantData() instanceof TestVariantData) {
                TestVariantData testVariantData = (TestVariantData)this.scope.getVariantData();
                if (connected) {
                    testVariantData.connectedTestTask = task;
                } else {
                    testVariantData.providerTestTaskList.add(task);
                }
            }
            task.buddyApks = (FileCollection)MoreObjects.firstNonNull((Object)project.getConfigurations().findByName("androidTestUtil"), (Object)project.files(new Object[0]));
            task.setEnabled(this.deviceProvider.isConfigured());
            task.getOutputs().upToDateWhen(t -> false);
        }
    }

    private static interface TestRunnerFactory {
        public TestRunner build(@Nullable File var1, ProcessExecutor var2);
    }
}

