/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.incremental.IncrementalChangeVisitor;
import com.android.build.gradle.internal.incremental.IncrementalSupportVisitor;
import com.android.build.gradle.internal.incremental.IncrementalVisitor;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunBuildMode;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.InstantRunVariantScope;
import com.android.build.gradle.options.DeploymentDevice;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.logging.Logging;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class InstantRunTransform
extends Transform {
    protected static final ILogger LOGGER = new LoggerWrapper(Logging.getLogger(InstantRunTransform.class));
    private final ImmutableList.Builder<String> generatedClasses3Names = ImmutableList.builder();
    private final InstantRunVariantScope transformScope;
    private final AndroidVersion targetPlatformApi;
    private final WaitableExecutor executor;

    public InstantRunTransform(WaitableExecutor executor, InstantRunVariantScope transformScope) {
        this.transformScope = transformScope;
        this.executor = executor;
        this.targetPlatformApi = DeploymentDevice.getDeploymentDeviceAndroidVersion(transformScope.getGlobalScope().getProjectOptions());
    }

    public String getName() {
        return "instantRun";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES, (Object)((Object)ExtendedContentType.CLASSES_ENHANCED));
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.SUB_PROJECTS});
    }

    public Set<QualifiedContent.Scope> getReferencedScopes() {
        return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.EXTERNAL_LIBRARIES, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.PROVIDED_ONLY});
    }

    public boolean isIncremental() {
        return true;
    }

    public Map<String, Object> getParameterInputs() {
        return this.transformScope.getInstantRunBuildContext().isInInstantRunMode() ? ImmutableMap.of((Object)"dex patching policy", (Object)this.transformScope.getInstantRunBuildContext().getPatchingPolicy().getDexPatchingPolicy().toString()) : ImmutableMap.of();
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        return Lists.transform(this.transformScope.getInstantRunBootClasspath(), SecondaryFile::nonIncremental);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(TransformInvocation invocation) throws IOException, TransformException, InterruptedException {
        List jarInputs = invocation.getInputs().stream().flatMap(input -> input.getJarInputs().stream()).collect(Collectors.toList());
        Preconditions.checkState((boolean)jarInputs.isEmpty(), (Object)("Unexpected inputs: " + Joiner.on((String)", ").join(jarInputs)));
        InstantRunBuildContext buildContext = this.transformScope.getInstantRunBuildContext();
        buildContext.startRecording(InstantRunBuildContext.TaskType.INSTANT_RUN_TRANSFORM);
        try {
            this.doTransform(invocation);
        }
        finally {
            buildContext.stopRecording(InstantRunBuildContext.TaskType.INSTANT_RUN_TRANSFORM);
        }
    }

    public void doTransform(TransformInvocation invocation) throws IOException, TransformException, InterruptedException {
        InstantRunBuildContext buildContext = this.transformScope.getInstantRunBuildContext();
        if (!invocation.isIncremental()) {
            buildContext.setVerifierStatus(InstantRunVerifierStatus.BUILD_NOT_INCREMENTAL);
        }
        boolean inHotSwapMode = buildContext.getBuildMode() == InstantRunBuildMode.HOT_WARM;
        TransformOutputProvider outputProvider = invocation.getOutputProvider();
        if (outputProvider == null) {
            throw new IllegalStateException("InstantRunTransform called with null output");
        }
        File classesTwoOutput = outputProvider.getContentLocation("classes", TransformManager.CONTENT_CLASS, this.getScopes(), Format.DIRECTORY);
        File classesThreeOutput = outputProvider.getContentLocation("enhanced_classes", (Set)ImmutableSet.of((Object)((Object)ExtendedContentType.CLASSES_ENHANCED)), this.getScopes(), Format.DIRECTORY);
        ArrayList<WorkItem> workItems = new ArrayList<WorkItem>();
        for (TransformInput input : invocation.getInputs()) {
            for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                File inputDir = directoryInput.getFile();
                if (invocation.isIncremental()) {
                    block20: for (Map.Entry entry : directoryInput.getChangedFiles().entrySet()) {
                        File inputFile = (File)entry.getKey();
                        if (!inputFile.getName().endsWith(".class")) continue;
                        switch ((Status)entry.getValue()) {
                            case REMOVED: {
                                InstantRunTransform.deleteOutputFile(IncrementalSupportVisitor.VISITOR_BUILDER, inputDir, inputFile, classesTwoOutput);
                                InstantRunTransform.deleteOutputFile(IncrementalChangeVisitor.VISITOR_BUILDER, inputDir, inputFile, classesThreeOutput);
                                continue block20;
                            }
                            case CHANGED: {
                                if (inHotSwapMode) {
                                    workItems.add(() -> this.transformToClasses3Format(inputDir, inputFile, classesThreeOutput));
                                }
                            }
                            case ADDED: {
                                workItems.add(() -> this.transformToClasses2Format(inputDir, inputFile, classesTwoOutput, (Status)fileEntry.getValue()));
                                continue block20;
                            }
                            case NOTCHANGED: {
                                continue block20;
                            }
                        }
                        throw new IllegalStateException("Unhandled file status " + entry.getValue());
                    }
                    continue;
                }
                FileUtils.cleanOutputDir((File)classesTwoOutput);
                for (File file : Files.fileTreeTraverser().breadthFirstTraversal((Object)inputDir)) {
                    if (file.isDirectory()) continue;
                    workItems.add(() -> this.transformToClasses2Format(inputDir, file, classesTwoOutput, Status.ADDED));
                }
            }
        }
        List<URL> referencedInputUrls = this.getAllClassesLocations(invocation.getInputs(), invocation.getReferencedInputs());
        NonDelegatingUrlClassloader urlClassLoader = new NonDelegatingUrlClassloader(referencedInputUrls);
        Object object = null;
        try {
            workItems.forEach(workItem -> this.executor.execute(() -> {
                ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(urlClassLoader);
                try {
                    Void void_ = workItem.doWork();
                    return void_;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
                }
            }));
            try {
                this.executor.waitForTasksWithQuickFail(true);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new TransformException((Throwable)e);
            }
            catch (Exception e) {
                throw new TransformException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (urlClassLoader != null) {
                if (object != null) {
                    try {
                        urlClassLoader.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    urlClassLoader.close();
                }
            }
        }
        if (buildContext.getBuildMode() != InstantRunBuildMode.HOT_WARM) {
            FileUtils.cleanOutputDir((File)classesThreeOutput);
        }
        this.wrapUpOutputs(classesTwoOutput, classesThreeOutput);
    }

    protected void wrapUpOutputs(File classes2Folder, File classes3Folder) throws IOException {
        if (!this.transformScope.getInstantRunBuildContext().hasPassedVerification()) {
            FileUtils.cleanOutputDir((File)classes3Folder);
            return;
        }
        ImmutableList generatedClassNames = this.generatedClasses3Names.build();
        if (!generatedClassNames.isEmpty()) {
            InstantRunTransform.writePatchFileContents((ImmutableList<String>)generatedClassNames, classes3Folder, this.transformScope.getInstantRunBuildContext().getBuildId());
        }
    }

    private List<URL> getAllClassesLocations(Collection<TransformInput> inputs, Collection<TransformInput> referencedInputs) throws MalformedURLException {
        ArrayList<URL> referencedInputUrls = new ArrayList<URL>();
        for (File file : this.transformScope.getInstantRunBootClasspath()) {
            referencedInputUrls.add(file.toURI().toURL());
        }
        for (TransformInput referencedInput : referencedInputs) {
            InstantRunTransform.addAllClassLocations(referencedInput, referencedInputUrls);
        }
        for (TransformInput input : inputs) {
            InstantRunTransform.addAllClassLocations(input, referencedInputUrls);
        }
        return referencedInputUrls;
    }

    private static void addAllClassLocations(TransformInput transformInput, List<URL> into) throws MalformedURLException {
        for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
            into.add(directoryInput.getFile().toURI().toURL());
        }
        for (JarInput jarInput : transformInput.getJarInputs()) {
            into.add(jarInput.getFile().toURI().toURL());
        }
    }

    protected Void transformToClasses2Format(File inputDir, File inputFile, File outputDir, Status change) throws IOException {
        if (inputFile.getPath().endsWith(".class")) {
            IncrementalVisitor.instrumentClass(this.targetPlatformApi.getFeatureLevel(), inputDir, inputFile, outputDir, IncrementalSupportVisitor.VISITOR_BUILDER, LOGGER);
        }
        return null;
    }

    private static void deleteOutputFile(IncrementalVisitor.VisitorBuilder visitorBuilder, File inputDir, File inputFile, File outputDir) {
        String inputPath = FileUtils.relativePossiblyNonExistingPath((File)inputFile, (File)inputDir);
        String outputPath = visitorBuilder.getMangledRelativeClassFilePath(inputPath);
        File outputFile = new File(outputDir, outputPath);
        if (outputFile.exists()) {
            try {
                FileUtils.delete((File)outputFile);
            }
            catch (IOException e) {
                LOGGER.warning("Cannot delete %1$s file.\nCause: %2$s", new Object[]{outputFile, Throwables.getStackTraceAsString((Throwable)e)});
            }
        }
    }

    protected Void transformToClasses3Format(File inputDir, File inputFile, File outputDir) throws IOException {
        File outputFile = IncrementalVisitor.instrumentClass(this.targetPlatformApi.getFeatureLevel(), inputDir, inputFile, outputDir, IncrementalChangeVisitor.VISITOR_BUILDER, LOGGER);
        if (outputFile == null) {
            this.transformScope.getInstantRunBuildContext().setVerifierStatus(InstantRunVerifierStatus.INSTANT_RUN_DISABLED);
            LOGGER.info("Class %s cannot be hot swapped.", new Object[]{inputFile});
            return null;
        }
        this.generatedClasses3Names.add((Object)inputFile.getAbsolutePath().substring(inputDir.getAbsolutePath().length() + 1, inputFile.getAbsolutePath().length() - ".class".length()).replace(File.separatorChar, '.'));
        return null;
    }

    private static void writePatchFileContents(ImmutableList<String> patchFileContents, File outputDir, long buildId) {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(50, 33, "com/android/tools/ir/runtime/AppPatchesLoaderImpl", null, "com/android/tools/ir/runtime/AbstractPatchesLoaderImpl", null);
        cw.visitField(25, "BUILD_ID", "J", null, (Object)buildId);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "com/android/tools/ir/runtime/AbstractPatchesLoaderImpl", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getPatchedClasses", "()[Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitIntInsn(16, patchFileContents.size());
        mv.visitTypeInsn(189, "java/lang/String");
        for (int index = 0; index < patchFileContents.size(); ++index) {
            mv.visitInsn(89);
            mv.visitIntInsn(16, index);
            mv.visitLdcInsn(patchFileContents.get(index));
            mv.visitInsn(83);
        }
        mv.visitInsn(176);
        mv.visitMaxs(4, 1);
        mv.visitEnd();
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        File outputFile = new File(outputDir, "com/android/tools/ir/runtime/AppPatchesLoaderImpl.class");
        try {
            Files.createParentDirs((File)outputFile);
            Files.write((byte[])classBytes, (File)outputFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class NonDelegatingUrlClassloader
    extends URLClassLoader {
        public NonDelegatingUrlClassloader(List<URL> urls) {
            super(urls.toArray(new URL[urls.size()]), (ClassLoader)null);
        }

        @Override
        public URL getResource(String name) {
            return this.findResource(name);
        }
    }

    private static interface WorkItem {
        public Void doWork() throws IOException;
    }
}

