/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.external.cmake.CmakeUtils;
import com.android.build.gradle.external.cmake.server.CodeModel;
import com.android.build.gradle.external.cmake.server.CompileCommand;
import com.android.build.gradle.external.cmake.server.ComputeResult;
import com.android.build.gradle.external.cmake.server.Configuration;
import com.android.build.gradle.external.cmake.server.ConfigureCommandResult;
import com.android.build.gradle.external.cmake.server.FileGroup;
import com.android.build.gradle.external.cmake.server.HandshakeRequest;
import com.android.build.gradle.external.cmake.server.HandshakeResult;
import com.android.build.gradle.external.cmake.server.Project;
import com.android.build.gradle.external.cmake.server.ProtocolVersion;
import com.android.build.gradle.external.cmake.server.Server;
import com.android.build.gradle.external.cmake.server.ServerFactory;
import com.android.build.gradle.external.cmake.server.ServerUtils;
import com.android.build.gradle.external.cmake.server.Target;
import com.android.build.gradle.external.cmake.server.receiver.InteractiveMessage;
import com.android.build.gradle.external.cmake.server.receiver.ServerReceiver;
import com.android.build.gradle.external.gson.NativeBuildConfigValue;
import com.android.build.gradle.external.gson.NativeLibraryValue;
import com.android.build.gradle.external.gson.NativeSourceFileValue;
import com.android.build.gradle.external.gson.NativeToolchainValue;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.tasks.CmakeExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.android.builder.core.AndroidBuilder;
import com.android.ide.common.process.ProcessException;
import com.android.utils.ILogger;
import com.google.common.primitives.UnsignedInts;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Contract;

class CmakeServerExternalNativeJsonGenerator
extends CmakeExternalNativeJsonGenerator {
    private static final String CMAKE_SERVER_LOG_PREFIX = "CMAKE SERVER: ";

    public CmakeServerExternalNativeJsonGenerator(NdkHandler ndkHandler, int minSdkVersion, String variantName, Collection<Abi> abis, AndroidBuilder androidBuilder, File sdkFolder, File ndkFolder, File soFolder, File objFolder, File jsonFolder, File makeFile, File cmakeFolder, boolean debuggable, List<String> buildArguments, List<String> cFlags, List<String> cppFlags, List<File> nativeBuildConfigurationsJsons) {
        super(ndkHandler, minSdkVersion, variantName, abis, androidBuilder, sdkFolder, ndkFolder, soFolder, objFolder, jsonFolder, makeFile, cmakeFolder, debuggable, buildArguments, cFlags, cppFlags, nativeBuildConfigurationsJsons);
        if (androidBuilder != null) {
            CmakeServerExternalNativeJsonGenerator.logPreviewWarning(androidBuilder);
        }
    }

    private static void logPreviewWarning(AndroidBuilder androidBuilder) {
        String previewWarning = "Support for CMake 3.7 and higher is a preview feature. To report a bug, see https://developer.android.com/studio/report-bugs.html";
        androidBuilder.getLogger().warning(previewWarning, new Object[0]);
    }

    @Contract(pure=true)
    private static String getDefaultGenerator() {
        return "Ninja";
    }

    private static String getOnlyToolchainName(Map<String, NativeToolchainValue> toolchains) {
        if (toolchains.size() != 1) {
            throw new RuntimeException(String.format("Invalid number %d of toolchains. Only one toolchain should be present.", toolchains.size()));
        }
        Iterator<String> iterator = toolchains.keySet().iterator();
        if (iterator.hasNext()) {
            String key = iterator.next();
            return key;
        }
        return null;
    }

    private static String getCmakeInfoString(Server cmakeServer) throws IOException {
        return String.format("Cmake path: %s, version: %s", cmakeServer.getCmakePath(), CmakeUtils.getVersion(new File(cmakeServer.getCmakePath())).toString());
    }

    @Override
    List<String> getCacheArguments(String abi, int abiPlatformVersion) {
        List<String> cacheArguments = this.getCommonCacheArguments(abi, abiPlatformVersion);
        cacheArguments.add("-DCMAKE_SYSTEM_NAME=Android");
        cacheArguments.add(String.format("-DCMAKE_ANDROID_ARCH_ABI=%s", abi));
        cacheArguments.add(String.format("-DCMAKE_SYSTEM_VERSION=%s", abiPlatformVersion));
        cacheArguments.add("-DCMAKE_EXPORT_COMPILE_COMMANDS=ON");
        cacheArguments.add(String.format("-DCMAKE_ANDROID_NDK=%s", this.getNdkFolder()));
        cacheArguments.add(String.format("-DCMAKE_TOOLCHAIN_FILE=%s", this.getToolchainFile(abi).getAbsolutePath()));
        cacheArguments.add("-G Ninja");
        return cacheArguments;
    }

    @Override
    public String executeProcess(String abi, int abiPlatformVersion, File outputJsonDir) throws ProcessException, IOException {
        try (PrintWriter serverLogWriter = null;){
            serverLogWriter = CmakeServerExternalNativeJsonGenerator.getCmakeServerLogWriter(ExternalNativeBuildTaskUtils.getOutputFolder(this.getJsonFolder(), abi));
            LoggerWrapper logger = LoggerWrapper.getLogger(CmakeServerExternalNativeJsonGenerator.class);
            Server cmakeServer = this.createServerAndConnect(abi, serverLogWriter, logger);
            this.doHandshake(outputJsonDir, cmakeServer);
            ConfigureCommandResult configureCommandResult = this.doConfigure(abi, abiPlatformVersion, cmakeServer);
            CmakeServerExternalNativeJsonGenerator.doCompute(cmakeServer);
            this.generateAndroidGradleBuild(abi, cmakeServer);
            String string = configureCommandResult.interactiveMessages;
            return string;
        }
    }

    private static PrintWriter getCmakeServerLogWriter(File outputFolder) throws IOException {
        return new PrintWriter(CmakeServerExternalNativeJsonGenerator.getCmakeServerLog(outputFolder).getAbsoluteFile(), "UTF-8");
    }

    private static File getCmakeServerLog(File outputFolder) {
        return new File(outputFolder, "cmake_server_log.txt");
    }

    private Server createServerAndConnect(String abi, PrintWriter serverLogWriter, ILogger logger) throws IOException {
        ServerReceiver serverReceiver = new ServerReceiver().setMessageReceiver(message -> CmakeServerExternalNativeJsonGenerator.receiveInteractiveMessage(serverLogWriter, logger, message)).setDiagnosticReceiver(message -> CmakeServerExternalNativeJsonGenerator.receiveDiagnosticMessage(serverLogWriter, logger, message));
        Server cmakeServer = ServerFactory.create(this.getCmakeBinFolder(), serverReceiver);
        if (cmakeServer == null) {
            throw new RuntimeException("Unable to create a Cmake server located at: " + this.getCmakeBinFolder().getAbsolutePath());
        }
        if (!cmakeServer.connect()) {
            throw new RuntimeException("Unable to connect to Cmake server located at: " + this.getCmakeBinFolder().getAbsolutePath());
        }
        return cmakeServer;
    }

    static void receiveInteractiveMessage(PrintWriter writer, ILogger logger, InteractiveMessage message) {
        writer.println(CMAKE_SERVER_LOG_PREFIX + message.message);
        CmakeServerExternalNativeJsonGenerator.logInteractiveMessage(logger, message);
    }

    static void logInteractiveMessage(ILogger logger, InteractiveMessage message) {
        String CMAKE_ERROR_PREFIX = "CMake Error";
        String CMAKE_WARNING_PREFIX = "CMake Warning";
        if (message.type != null && message.type.equals("error")) {
            logger.error(null, message.errorMessage, new Object[0]);
            throw new RuntimeException("CMake server sync operations failed.");
        }
        if (message.title != null && message.title.equals("Error") || message.message.startsWith("CMake Error")) {
            logger.error(null, message.message, new Object[0]);
            return;
        }
        if (message.title != null && message.title.equals("Warning") || message.message.startsWith("CMake Warning")) {
            logger.warning(message.message, new Object[0]);
            return;
        }
        logger.info(message.message, new Object[0]);
    }

    static void receiveDiagnosticMessage(PrintWriter writer, ILogger logger, String message) {
        writer.println(CMAKE_SERVER_LOG_PREFIX + message);
        logger.info(message, new Object[0]);
    }

    private void doHandshake(File outputDir, Server cmakeServer) throws IOException {
        List<ProtocolVersion> supportedProtocolVersions = cmakeServer.getSupportedVersion();
        if (supportedProtocolVersions == null || supportedProtocolVersions.size() <= 0) {
            throw new RuntimeException(String.format("Gradle does not support the Cmake server version. %s", CmakeServerExternalNativeJsonGenerator.getCmakeInfoString(cmakeServer)));
        }
        HandshakeResult handshakeResult = cmakeServer.handshake(this.getHandshakeRequest(supportedProtocolVersions.get(0), outputDir));
        if (!ServerUtils.isHandshakeResultValid(handshakeResult)) {
            throw new RuntimeException(String.format("Invalid handshake result from Cmake server: \n%s\n%s", CmakeUtils.getObjectToString(handshakeResult), CmakeServerExternalNativeJsonGenerator.getCmakeInfoString(cmakeServer)));
        }
    }

    private HandshakeRequest getHandshakeRequest(ProtocolVersion cmakeServerProtocolVersion, File outputDir) {
        HandshakeRequest handshakeRequest = new HandshakeRequest();
        handshakeRequest.cookie = "gradle-cmake-cookie";
        handshakeRequest.generator = CmakeServerExternalNativeJsonGenerator.getGenerator(this.getBuildArguments());
        handshakeRequest.protocolVersion = cmakeServerProtocolVersion;
        handshakeRequest.buildDirectory = CmakeServerExternalNativeJsonGenerator.normalizeFilePath(outputDir.getParentFile());
        handshakeRequest.sourceDirectory = CmakeServerExternalNativeJsonGenerator.normalizeFilePath(this.getMakefile().getParentFile());
        return handshakeRequest;
    }

    private ConfigureCommandResult doConfigure(String abi, int abiPlatformVersion, Server cmakeServer) throws IOException {
        List<String> cacheArgumentsList = this.getCacheArguments(abi, abiPlatformVersion);
        cacheArgumentsList.addAll(this.getBuildArguments());
        ConfigureCommandResult configureCommandResult = cmakeServer.configure(cacheArgumentsList.toArray(new String[cacheArgumentsList.size()]));
        if (!ServerUtils.isConfigureResultValid(configureCommandResult.configureResult)) {
            throw new RuntimeException(String.format("Invalid config result from Cmake server: \n%s\n%s", CmakeUtils.getObjectToString(configureCommandResult), CmakeServerExternalNativeJsonGenerator.getCmakeInfoString(cmakeServer)));
        }
        return configureCommandResult;
    }

    private static void doCompute(Server cmakeServer) throws IOException {
        ComputeResult computeResult = cmakeServer.compute();
        if (!ServerUtils.isComputedResultValid(computeResult)) {
            throw new RuntimeException(String.format("Invalid compute result from Cmake server: \n%s\n%s", CmakeUtils.getObjectToString(computeResult), CmakeServerExternalNativeJsonGenerator.getCmakeInfoString(cmakeServer)));
        }
    }

    private static String getGenerator(List<String> buildArguments) {
        String generatorArgument = "-G ";
        for (String argument : buildArguments) {
            if (!argument.startsWith(generatorArgument)) continue;
            int startIndex = argument.indexOf(generatorArgument) + generatorArgument.length();
            return argument.substring(startIndex, argument.length());
        }
        return CmakeServerExternalNativeJsonGenerator.getDefaultGenerator();
    }

    private void generateAndroidGradleBuild(String abi, Server cmakeServer) throws IOException {
        NativeBuildConfigValue nativeBuildConfigValue = this.getNativeBuildConfigValue(abi, cmakeServer);
        ExternalNativeBuildTaskUtils.writeNativeBuildConfigValueToJsonFile(ExternalNativeBuildTaskUtils.getOutputJson(this.getJsonFolder(), abi), nativeBuildConfigValue);
    }

    protected NativeBuildConfigValue getNativeBuildConfigValue(String abi, Server cmakeServer) throws IOException {
        NativeBuildConfigValue nativeBuildConfigValue = CmakeServerExternalNativeJsonGenerator.createDefaultNativeBuildConfigValue();
        nativeBuildConfigValue.buildFiles.add(this.getMakefile());
        nativeBuildConfigValue.cleanCommands.add(CmakeUtils.getCleanCommand(this.getCmakeExecutable(), ExternalNativeBuildTaskUtils.getOutputFolder(this.getJsonFolder(), abi)));
        CodeModel codeModel = cmakeServer.codemodel();
        if (!ServerUtils.isCodeModelValid(codeModel)) {
            throw new RuntimeException(String.format("Invalid code model received from Cmake server: \n%s\n%s", CmakeUtils.getObjectToString(codeModel), CmakeServerExternalNativeJsonGenerator.getCmakeInfoString(cmakeServer)));
        }
        nativeBuildConfigValue.cFileExtensions.addAll(CmakeUtils.getCExtensionSet(codeModel));
        nativeBuildConfigValue.cppFileExtensions.addAll(CmakeUtils.getCppExtensionSet(codeModel));
        nativeBuildConfigValue.toolchains = this.getNativeToolchains(abi, cmakeServer, nativeBuildConfigValue.cFileExtensions, nativeBuildConfigValue.cppFileExtensions);
        String toolchainHashString = CmakeServerExternalNativeJsonGenerator.getOnlyToolchainName(nativeBuildConfigValue.toolchains);
        for (Configuration config : codeModel.configurations) {
            for (Project project : config.projects) {
                for (Target target : project.targets) {
                    if (!CmakeServerExternalNativeJsonGenerator.canAddTargetToNativeLibrary(target)) continue;
                    NativeLibraryValue nativeLibraryValue = new NativeLibraryValue();
                    nativeLibraryValue.abi = abi;
                    nativeLibraryValue.buildCommand = CmakeUtils.getBuildCommand(this.getCmakeExecutable(), ExternalNativeBuildTaskUtils.getOutputFolder(this.getJsonFolder(), abi), target.name);
                    nativeLibraryValue.artifactName = target.name;
                    String string = nativeLibraryValue.buildType = this.isDebuggable() ? "debug" : "release";
                    if (target.artifacts.length > 0) {
                        nativeLibraryValue.output = new File(target.artifacts[0]);
                    }
                    nativeLibraryValue.files = new ArrayList<NativeSourceFileValue>();
                    for (FileGroup fileGroup : target.fileGroups) {
                        for (String source : fileGroup.sources) {
                            NativeSourceFileValue nativeSourceFileValue = new NativeSourceFileValue();
                            nativeSourceFileValue.workingDirectory = new File(target.buildDirectory);
                            nativeSourceFileValue.src = new File(source);
                            File sourceFile = new File(project.sourceDirectory, source);
                            nativeSourceFileValue.flags = this.getAndroidGradleFileLibFlags(abi, sourceFile.getAbsolutePath());
                            nativeLibraryValue.files.add(nativeSourceFileValue);
                        }
                    }
                    nativeLibraryValue.toolchain = toolchainHashString;
                    String libraryName = target.name + "-" + config.name + "-" + abi;
                    nativeBuildConfigValue.libraries.put(libraryName, nativeLibraryValue);
                }
            }
        }
        return nativeBuildConfigValue;
    }

    private static boolean canAddTargetToNativeLibrary(Target target) {
        return target.artifacts != null && target.fileGroups != null;
    }

    private static NativeBuildConfigValue createDefaultNativeBuildConfigValue() {
        NativeBuildConfigValue nativeBuildConfigValue = new NativeBuildConfigValue();
        nativeBuildConfigValue.buildFiles = new ArrayList<File>();
        nativeBuildConfigValue.cleanCommands = new ArrayList<String>();
        nativeBuildConfigValue.libraries = new HashMap<String, NativeLibraryValue>();
        nativeBuildConfigValue.toolchains = new HashMap<String, NativeToolchainValue>();
        nativeBuildConfigValue.cFileExtensions = new ArrayList<String>();
        nativeBuildConfigValue.cppFileExtensions = new ArrayList<String>();
        return nativeBuildConfigValue;
    }

    private Map<String, NativeToolchainValue> getNativeToolchains(String abi, Server cmakeServer, Collection<String> cppExtensionSet, Collection<String> cExtensionSet) {
        File cppCompilerExecutable;
        File cCompilerExecutable;
        NativeToolchainValue toolchainValue;
        block11: {
            toolchainValue = new NativeToolchainValue();
            cCompilerExecutable = null;
            cppCompilerExecutable = null;
            try {
                List<CompileCommand> compileCommands = this.getCompileCommands(abi);
                if (!compileCommands.isEmpty()) {
                    for (CompileCommand compileCommand : compileCommands) {
                        if (compileCommand.file == null || compileCommand.command == null) continue;
                        String extension = compileCommand.file.substring(compileCommand.file.lastIndexOf(46) + 1).trim();
                        String executable = compileCommand.command.substring(0, compileCommand.command.indexOf(32));
                        if (toolchainValue.cppCompilerExecutable == null && cppExtensionSet.contains(extension)) {
                            toolchainValue.cppCompilerExecutable = new File(executable);
                            continue;
                        }
                        if (toolchainValue.cCompilerExecutable != null || !cExtensionSet.contains(extension)) continue;
                        toolchainValue.cCompilerExecutable = new File(executable);
                    }
                } else {
                    if (cmakeServer.getCCompilerExecutable() != null) {
                        cCompilerExecutable = new File(cmakeServer.getCCompilerExecutable());
                    }
                    if (cmakeServer.getCppCompilerExecutable() != null) {
                        cppCompilerExecutable = new File(cmakeServer.getCppCompilerExecutable());
                    }
                }
            }
            catch (IOException e) {
                if (cmakeServer.getCCompilerExecutable() != null) {
                    cCompilerExecutable = new File(cmakeServer.getCCompilerExecutable());
                }
                if (cmakeServer.getCppCompilerExecutable() == null) break block11;
                cppCompilerExecutable = new File(cmakeServer.getCppCompilerExecutable());
            }
        }
        if (cCompilerExecutable != null) {
            toolchainValue.cCompilerExecutable = cCompilerExecutable;
        }
        if (cppCompilerExecutable != null) {
            toolchainValue.cppCompilerExecutable = cppCompilerExecutable;
        }
        int toolchainHash = CmakeUtils.getToolchainHash(toolchainValue);
        String toolchainHashString = UnsignedInts.toString((int)toolchainHash);
        HashMap<String, NativeToolchainValue> toolchains = new HashMap<String, NativeToolchainValue>();
        toolchains.put(toolchainHashString, toolchainValue);
        return toolchains;
    }

    private List<CompileCommand> getCompileCommands(String abi) throws IOException {
        return ServerUtils.getCompilationDatabase(this.getCompileCommandsJson(abi));
    }

    private String getAndroidGradleFileLibFlags(String abi, String fileName) throws IOException {
        return this.getAndroidGradleFileLibFlags(abi, fileName, this.getCompileCommands(abi));
    }

    String getAndroidGradleFileLibFlags(String abi, String fileName, List<CompileCommand> compileCommands) throws IOException {
        String flags = null;
        Path fileNamePath = Paths.get(fileName, new String[0]);
        for (CompileCommand compileCommand : compileCommands) {
            if (compileCommand.command == null || compileCommand.file == null || fileNamePath.compareTo(Paths.get(compileCommand.file, new String[0])) != 0) continue;
            flags = compileCommand.command.substring(compileCommand.command.indexOf(32) + 1, compileCommand.command.indexOf(fileName));
            break;
        }
        return flags;
    }

    private File getPreNDKr15WrapperToolchainFile(File outputFolder) {
        StringBuilder tempAndroidToolchain = new StringBuilder(String.format("include(%s)", CmakeServerExternalNativeJsonGenerator.normalizeFilePath(this.getToolChainFile())));
        tempAndroidToolchain.append(System.lineSeparator() + "set(CMAKE_ANDROID_NDK ${ANDROID_NDK})" + System.lineSeparator() + "  if(ANDROID_TOOLCHAIN STREQUAL gcc)" + System.lineSeparator() + "    set(CMAKE_ANDROID_NDK_TOOLCHAIN_VERSION 4.9)" + System.lineSeparator() + "  else()" + System.lineSeparator() + "    set(CMAKE_ANDROID_NDK_TOOLCHAIN_VERSION clang)" + System.lineSeparator() + "  endif()" + System.lineSeparator() + "  set(CMAKE_ANDROID_STL_TYPE ${ANDROID_STL})" + System.lineSeparator() + "  if(ANDROID_ABI MATCHES \"^armeabi(-v7a)?$\")" + System.lineSeparator() + "    set(CMAKE_ANDROID_ARM_NEON ${ANDROID_ARM_NEON})" + System.lineSeparator() + "    set(CMAKE_ANDROID_ARM_MODE ${ANDROID_ARM_MODE})" + System.lineSeparator() + "  endif()");
        File toolchainFile = CmakeServerExternalNativeJsonGenerator.getTempToolchainFile(outputFolder);
        try {
            FileUtils.writeStringToFile((File)toolchainFile, (String)tempAndroidToolchain.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to write to file: %s.Please upgrade NDK to version 15 or above.", toolchainFile.getAbsolutePath()));
        }
        return toolchainFile;
    }

    private static File getTempToolchainFile(File outputFolder) {
        String tempAndroidToolchainFile = "pre-ndk-r15-wrapper-android.toolchain.cmake";
        return new File(outputFolder, tempAndroidToolchainFile);
    }

    private static String normalizeFilePath(File file) {
        if (CmakeServerExternalNativeJsonGenerator.isWindows()) {
            return file.getPath().replace("\\", "/");
        }
        return file.getPath();
    }

    private File getToolchainFile(String abi) {
        if (this.getNdkHandler().getRevision().getMajor() >= 15) {
            return this.getToolChainFile();
        }
        return this.getPreNDKr15WrapperToolchainFile(ExternalNativeBuildTaskUtils.getOutputFolder(this.getJsonFolder(), abi));
    }
}

