/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.IncrementalVisitor;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InnerClassNode;

public class AsmUtils {
    public static final ClassNodeProvider classLoaderBasedProvider = (className, logger) -> {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try (InputStream is = classLoader.getResourceAsStream(className + ".class");){
            if (is == null) {
                throw new IOException("Failed to find byte code for " + className);
            }
            ClassReader classReader = new ClassReader(is);
            ClassNode node = new ClassNode();
            classReader.accept((ClassVisitor)node, 8);
            ClassNode classNode = node;
            return classNode;
        }
    };

    @VisibleForTesting
    public static List<AnnotationNode> getInvisibleAnnotationsOnClassOrOuterClasses(ClassNodeProvider classReader, ClassNode classNode, ILogger logger) throws IOException {
        String outerClassName;
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        do {
            List invisibleAnnotations;
            if ((invisibleAnnotations = classNode.invisibleAnnotations) == null) continue;
            listBuilder.addAll((Iterable)invisibleAnnotations);
        } while ((classNode = (outerClassName = AsmUtils.getOuterClassName(classNode)) != null ? classReader.loadClassNode(outerClassName, logger) : null) != null);
        return listBuilder.build();
    }

    public static IncrementalVisitor.ClassAndInterfacesNode readParentClassAndInterfaces(ClassNodeProvider classReaderProvider, String parentClassName, String childClassName, int targetApi, ILogger logger) throws IOException {
        ClassNode classNode = classReaderProvider.loadClassNode(parentClassName, logger);
        if (classNode == null) {
            logger.warning("IncrementalVisitor parseParents could not locate %1$s which is an ancestor of project class %2$s.\n%2$s is not eligible for hot swap. \nIf the class targets a more recent platform than %3$d, add a @TargetApi annotation to silence this warning.", new Object[]{parentClassName, childClassName, targetApi});
            return null;
        }
        ImmutableList.Builder interfaces = ImmutableList.builder();
        if (!AsmUtils.readInterfaces(classNode, classReaderProvider, (ImmutableList.Builder<ClassNode>)interfaces, logger)) {
            return null;
        }
        return new IncrementalVisitor.ClassAndInterfacesNode(classNode, (List<ClassNode>)interfaces.build());
    }

    public static boolean readInterfaces(ClassNode classNode, ClassNodeProvider classReaderProvider, ImmutableList.Builder<ClassNode> interfacesList, ILogger logger) throws IOException {
        for (String anInterface : classNode.interfaces) {
            ClassNode intf = AsmUtils.loadClass(classReaderProvider, anInterface, logger);
            if (intf != null) {
                interfacesList.add((Object)intf);
                continue;
            }
            logger.warning("Cannot load interface %$1s, which is implementedby %2$s, therefore %2$s will not be eligible for hotswap.", new Object[]{anInterface, classNode.name});
            return false;
        }
        return true;
    }

    public static ClassNode readClass(ClassReader classReader) {
        ClassNode node = new ClassNode();
        classReader.accept((ClassVisitor)node, 8);
        return node;
    }

    public static List<IncrementalVisitor.ClassAndInterfacesNode> parseParents(ILogger logger, ClassNodeProvider classBytesReader, ClassNode classNode, int targetApi) throws IOException {
        ImmutableList.Builder parentNodes = ImmutableList.builder();
        String currentParentName = classNode.superName;
        while (currentParentName != null) {
            IncrementalVisitor.ClassAndInterfacesNode parentWithInterfacesNode = AsmUtils.readParentClassAndInterfaces(classBytesReader, currentParentName, classNode.name, targetApi, logger);
            if (parentWithInterfacesNode == null && (parentWithInterfacesNode = AsmUtils.readParentClassAndInterfaces(classLoaderBasedProvider, currentParentName, classNode.name, targetApi, logger)) == null) {
                return ImmutableList.of();
            }
            parentNodes.add((Object)parentWithInterfacesNode);
            currentParentName = parentWithInterfacesNode.classNode.superName;
        }
        return parentNodes.build();
    }

    public static ClassNode loadClass(ClassNodeProvider classBytesReader, String className, ILogger logger) throws IOException {
        ClassNode classNode = classBytesReader.loadClassNode(className, logger);
        if (classNode != null) {
            return classNode;
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            return AsmUtils.readClass(contextClassLoader, className);
        }
        catch (IOException e) {
            logger.warning(e.getMessage(), new Object[0]);
            logger.warning("IncrementalVisitor parseParents could not locate %1$s", new Object[]{className});
            return null;
        }
    }

    public static ClassNode readClass(ClassLoader classLoader, String className) throws IOException {
        try (InputStream is = classLoader.getResourceAsStream(className + ".class");){
            if (is == null) {
                throw new IOException("Failed to find byte code for " + className);
            }
            ClassReader parentClassReader = new ClassReader(is);
            ClassNode node = new ClassNode();
            parentClassReader.accept((ClassVisitor)node, 8);
            ClassNode classNode = node;
            return classNode;
        }
    }

    public static ClassNode parsePackageInfo(File inputFile) throws IOException {
        File packageFolder = inputFile.getParentFile();
        File packageInfoClass = new File(packageFolder, "package-info.class");
        if (packageInfoClass.exists()) {
            try (BufferedInputStream reader = new BufferedInputStream(new FileInputStream(packageInfoClass));){
                ClassReader classReader = new ClassReader((InputStream)reader);
                ClassNode classNode = AsmUtils.readClass(classReader);
                return classNode;
            }
        }
        return null;
    }

    public static String getOuterClassName(ClassNode classNode) {
        if (classNode.outerClass != null) {
            return classNode.outerClass;
        }
        if (classNode.innerClasses != null) {
            List innerClassNodes = classNode.innerClasses;
            for (InnerClassNode innerClassNode : innerClassNodes) {
                if (!innerClassNode.name.equals(classNode.name)) continue;
                return innerClassNode.outerName;
            }
        }
        return null;
    }

    public static class JarBasedClassReader
    implements ClassNodeProvider {
        private final File file;

        public JarBasedClassReader(File file) {
            this.file = file;
        }

        /*
         * Loose catch block
         */
        @Override
        public ClassNode loadClassNode(String className, ILogger logger) throws IOException {
            block28: {
                Throwable throwable = null;
                try (JarFile jarFile = new JarFile(this.file);){
                    ZipEntry entry = jarFile.getEntry(className.replace(".", "/") + ".class");
                    if (entry != null) {
                        try (InputStream is = jarFile.getInputStream(entry);){
                            ClassNode classNode = AsmUtils.readClass(new ClassReader(is));
                            return classNode;
                        }
                    }
                    break block28;
                    {
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
            }
            return null;
        }
    }

    public static class DirectoryBasedClassReader
    implements ClassNodeProvider {
        private final File binaryFolder;

        public DirectoryBasedClassReader(File binaryFolder) {
            this.binaryFolder = binaryFolder;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ClassNode loadClassNode(String className, ILogger logger) {
            File outerClassFile = new File(this.binaryFolder, className + ".class");
            if (!outerClassFile.exists()) return null;
            logger.verbose("Parsing %s", new Object[]{outerClassFile});
            try (BufferedInputStream outerClassInputStream = new BufferedInputStream(new FileInputStream(outerClassFile));){
                ClassNode classNode = AsmUtils.readClass(new ClassReader((InputStream)outerClassInputStream));
                return classNode;
            }
            catch (IOException e) {
                logger.error((Throwable)e, "Cannot parse %s", new Object[]{className});
            }
            return null;
        }
    }

    public static interface ClassNodeProvider {
        public ClassNode loadClassNode(String var1, ILogger var2) throws IOException;
    }
}

