/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.transforms.LibraryBaseTransform;
import com.android.builder.packaging.TypedefRemover;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class LibraryAarJarsTransform
extends LibraryBaseTransform {
    public LibraryAarJarsTransform(File mainClassLocation, File localJarsLocation, File typedefRecipe, String packageName, boolean packageBuildConfig) {
        super(mainClassLocation, localJarsLocation, typedefRecipe, packageName, packageBuildConfig);
    }

    public String getName() {
        return "syncLibJars";
    }

    @Override
    public Set<? super QualifiedContent.Scope> getReferencedScopes() {
        return TransformManager.SCOPE_FULL_LIBRARY_WITH_LOCAL_JARS;
    }

    public boolean isIncremental() {
        return false;
    }

    public Collection<File> getSecondaryFileOutputs() {
        return ImmutableList.of((Object)this.mainClassLocation);
    }

    public void transform(TransformInvocation invocation) throws IOException, TransformException, InterruptedException {
        if (this.localJarsLocation != null) {
            FileUtils.deleteDirectoryContents((File)this.localJarsLocation);
        }
        if (this.typedefRecipe != null && !this.typedefRecipe.exists()) {
            throw new IllegalStateException("Type def recipe not found: " + this.typedefRecipe);
        }
        List<Pattern> patterns = this.computeExcludeList();
        ArrayList mainScope = Lists.newArrayList();
        ArrayList localJarScope = Lists.newArrayList();
        for (TransformInput input : invocation.getReferencedInputs()) {
            for (QualifiedContent qualifiedContent : Iterables.concat((Iterable)input.getJarInputs(), (Iterable)input.getDirectoryInputs())) {
                if (qualifiedContent.getScopes().contains(QualifiedContent.Scope.PROJECT)) {
                    mainScope.add(qualifiedContent);
                    continue;
                }
                localJarScope.add(qualifiedContent);
            }
        }
        if (mainScope.isEmpty()) {
            throw new RuntimeException("Empty Main scope for " + this.getName());
        }
        LibraryAarJarsTransform.mergeInputsToLocation(mainScope, this.mainClassLocation, false, archivePath -> LibraryAarJarsTransform.checkEntry(patterns, archivePath), this.typedefRecipe != null ? new TypedefRemover().setTypedefFile(this.typedefRecipe) : null);
        FileUtils.deleteDirectoryContents((File)this.localJarsLocation);
        this.processLocalJars(localJarScope);
    }
}

