/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant2;

import com.android.build.api.dsl.model.ProductFlavorOrVariant;
import com.android.build.api.dsl.model.VariantProperties;
import com.android.build.api.dsl.variant.Variant;
import com.android.build.api.sourcesets.AndroidSourceSet;
import com.android.build.gradle.internal.api.dsl.extensions.BaseExtension2;
import com.android.build.gradle.internal.api.dsl.extensions.VariantOrExtensionPropertiesImpl;
import com.android.build.gradle.internal.api.dsl.model.BuildTypeImpl;
import com.android.build.gradle.internal.api.dsl.model.BuildTypeOrVariantImpl;
import com.android.build.gradle.internal.api.dsl.model.ProductFlavorImpl;
import com.android.build.gradle.internal.api.dsl.model.ProductFlavorOrVariantImpl;
import com.android.build.gradle.internal.api.dsl.model.VariantPropertiesImpl;
import com.android.build.gradle.internal.api.dsl.variant.CommonVariantPropertiesImpl;
import com.android.build.gradle.internal.api.dsl.variant.SealableVariant;
import com.android.build.gradle.internal.api.sourcesets.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.variant2.DslModelData;
import com.android.build.gradle.internal.variant2.FlavorCombination;
import com.android.build.gradle.internal.variant2.VariantBuilder;
import com.android.build.gradle.internal.variant2.VariantBuilderKt;
import com.android.build.gradle.internal.variant2.VariantFactory2;
import com.android.build.gradle.internal.variant2.VariantFilterImpl;
import com.android.builder.core.VariantType;
import com.android.builder.errors.DeprecationReporter;
import com.android.builder.errors.EvalIssueReporter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u00022\u00020\u0003B9\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\"H\u0002J\"\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020 H\u0002J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020(0\bH\u0002J\u001a\u0010+\u001a\u00020,2\u0006\u0010)\u001a\u00020 2\b\u0010'\u001a\u0004\u0018\u00010(H\u0002J\u0006\u0010-\u001a\u00020,J\u0016\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\bH\u0002J\u0016\u00102\u001a\u0002032\f\u00100\u001a\b\u0012\u0004\u0012\u0002040\bH\u0002R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00028\u0000X\u0088\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001a\u00a8\u00065"}, d2={"Lcom/android/build/gradle/internal/variant2/VariantBuilder;", "E", "Lcom/android/build/gradle/internal/api/dsl/extensions/BaseExtension2;", "", "dslModelData", "Lcom/android/build/gradle/internal/variant2/DslModelData;", "extension", "factories", "", "Lcom/android/build/gradle/internal/variant2/VariantFactory2;", "deprecationReporter", "Lcom/android/builder/errors/DeprecationReporter;", "issueReporter", "Lcom/android/builder/errors/EvalIssueReporter;", "(Lcom/android/build/gradle/internal/variant2/DslModelData;Lcom/android/build/gradle/internal/api/dsl/extensions/BaseExtension2;Ljava/util/List;Lcom/android/builder/errors/DeprecationReporter;Lcom/android/builder/errors/EvalIssueReporter;)V", "_shims", "", "Lcom/android/build/api/dsl/variant/Variant;", "_variants", "", "Lcom/android/build/gradle/internal/api/dsl/variant/SealableVariant;", "Lcom/android/build/gradle/internal/api/dsl/extensions/BaseExtension2;", "generated", "", "shims", "getShims", "()Ljava/util/List;", "variants", "getVariants", "cloneBuildTypeOrVariant", "Lcom/android/build/gradle/internal/api/dsl/model/BuildTypeOrVariantImpl;", "that", "Lcom/android/build/gradle/internal/api/dsl/model/BuildTypeImpl;", "cloneVariantOrExtensionProperties", "Lcom/android/build/gradle/internal/api/dsl/extensions/VariantOrExtensionPropertiesImpl;", "computeCommonVariantPropertiesImpl", "Lcom/android/build/gradle/internal/api/dsl/variant/CommonVariantPropertiesImpl;", "variantName", "", "flavorCombo", "Lcom/android/build/gradle/internal/variant2/FlavorCombination;", "buildType", "computeFlavorCombo", "createVariant", "", "generateVariants", "mergeProductFlavorOrVariant", "Lcom/android/build/gradle/internal/api/dsl/model/ProductFlavorOrVariantImpl;", "items", "Lcom/android/build/api/dsl/model/ProductFlavorOrVariant;", "mergeVariantProperties", "Lcom/android/build/gradle/internal/api/dsl/model/VariantPropertiesImpl;", "Lcom/android/build/api/dsl/model/VariantProperties;", "gradle-core_main"})
public final class VariantBuilder<E extends BaseExtension2> {
    private boolean generated;
    private final List<SealableVariant> _variants;
    private final Map<Variant, Variant> _shims;
    private final DslModelData dslModelData;
    private final E extension;
    private final List<VariantFactory2<E>> factories;
    private final DeprecationReporter deprecationReporter;
    private final EvalIssueReporter issueReporter;

    @NotNull
    public final List<SealableVariant> getVariants() {
        if (!this.generated) {
            throw (Throwable)new RuntimeException("VariantBuilder.generateVariants() not called");
        }
        return this._variants;
    }

    @NotNull
    public final List<Variant> getShims() {
        if (!this.generated) {
            throw (Throwable)new RuntimeException("VariantBuilder.generateVariants() not called");
        }
        ImmutableList immutableList = ImmutableList.copyOf(this._shims.values());
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.copyOf(_shims.values)");
        return (List)immutableList;
    }

    public final void generateVariants() {
        List<FlavorCombination> flavorCombinations = this.computeFlavorCombo();
        if (flavorCombinations.isEmpty()) {
            Iterator iterator = this.dslModelData.getBuildTypes().iterator();
            while (iterator.hasNext()) {
                BuildTypeImpl buildType;
                BuildTypeImpl buildTypeImpl = buildType = (BuildTypeImpl)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)buildTypeImpl, (String)"buildType");
                this.createVariant(buildTypeImpl, null);
            }
        } else {
            for (BuildTypeImpl buildType : this.dslModelData.getBuildTypes()) {
                for (FlavorCombination flavorCombo : flavorCombinations) {
                    BuildTypeImpl buildTypeImpl = buildType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)buildTypeImpl, (String)"buildType");
                    this.createVariant(buildTypeImpl, flavorCombo);
                }
            }
        }
    }

    private final List<FlavorCombination> computeFlavorCombo() {
        List flavorDimensions = this.extension.getFlavorDimensions();
        if (this.dslModelData.getProductFlavors().isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (flavorDimensions.isEmpty()) {
            this.issueReporter.reportError(26, "All flavors must now belong to a named flavor dimension. Learn more at https://d.android.com/r/tools/flavorDimensions-missing-error-message.html");
        } else if (flavorDimensions.size() == 1) {
            String dimensionName = (String)flavorDimensions.get(0);
            for (ProductFlavorImpl productFlavor : this.dslModelData.getProductFlavors()) {
                productFlavor.set_dimension$gradle_core_main(dimensionName);
            }
        }
        return VariantBuilderKt.access$createCombinations(flavorDimensions, (Set)this.dslModelData.getProductFlavors(), this.issueReporter);
    }

    private final void createVariant(BuildTypeImpl buildType, FlavorCombination flavorCombo) {
        Variant variant;
        Map<Variant, Variant> map;
        Variant shim;
        Map variantType;
        String string = buildType.getName();
        Object object = flavorCombo;
        if (object == null || (object = ((FlavorCombination)object).getFlavorNames()) == null) {
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
            object = (List)immutableList;
        }
        VariantFilterImpl filterObject = new VariantFilterImpl(string, (List<String>)object, this.issueReporter);
        Object object2 = this.extension.getVariantFilters().iterator();
        while (object2.hasNext()) {
            Action filter = (Action)object2.next();
            filter.execute((Object)filterObject);
            if (!filterObject.getIgnoresAll()) continue;
            return;
        }
        filterObject.seal();
        List items = new ArrayList();
        items.add(this.dslModelData.getDefaultConfig());
        FlavorCombination flavorCombination = flavorCombo;
        if (flavorCombination != null) {
            Object it = object2 = flavorCombination;
            items.addAll((Collection)((FlavorCombination)it).getFlavors());
        }
        ProductFlavorOrVariantImpl productFlavorOrVariant = this.mergeProductFlavorOrVariant(TypeIntrinsics.asMutableList((Object)items));
        items.add(buildType);
        VariantPropertiesImpl variantProperties = this.mergeVariantProperties(TypeIntrinsics.asMutableList((Object)items));
        String appIdSuffixFromFlavors2 = VariantBuilderKt.access$combineSuffixes(TypeIntrinsics.asMutableList((Object)items), createVariant.appIdSuffixFromFlavors.1.INSTANCE, Character.valueOf('.'));
        String variantNameSuffixFromFlavors2 = VariantBuilderKt.access$combineSuffixes(TypeIntrinsics.asMutableList((Object)items), createVariant.variantNameSuffixFromFlavors.1.INSTANCE, null);
        BuildTypeOrVariantImpl buildTypOrVariant = this.cloneBuildTypeOrVariant(buildType);
        VariantOrExtensionPropertiesImpl variantExtensionProperties = this.cloneVariantOrExtensionProperties(this.extension.getVariantExtensionProperties());
        Map variantDispatcher = new LinkedHashMap();
        Map createdVariantMap = new LinkedHashMap();
        for (VariantFactory2<E> factory : this.factories) {
            VariantType generatedType = factory.getGeneratedType();
            if (!generatedType.isForTesting() ? filterObject.getIgnoresProd() : Intrinsics.areEqual((Object)generatedType, (Object)VariantType.ANDROID_TEST) && filterObject.getIgnoresAndroidTest() || Intrinsics.areEqual((Object)generatedType, (Object)VariantType.UNIT_TEST) && filterObject.getIgnoresUnitTest()) continue;
            FlavorCombination flavorCombination2 = flavorCombo;
            String variantName = VariantBuilderKt.access$computeVariantName(buildType.getName(), flavorCombination2 != null ? flavorCombination2.getName() : null, generatedType, factory.getTestTarget());
            CommonVariantPropertiesImpl commonVariantProperties = this.computeCommonVariantPropertiesImpl(variantName, flavorCombo, buildType);
            productFlavorOrVariant.setApplicationId(factory.computeApplicationId(productFlavorOrVariant, appIdSuffixFromFlavors2));
            SealableVariant variant2 = factory.createVariant(this.extension, variantProperties, productFlavorOrVariant, buildTypOrVariant, variantExtensionProperties, commonVariantProperties, variantDispatcher);
            variantType = variant2.getVariantType();
            this._variants.add(variant2);
            shim = variant2.createShim();
            map = this._shims;
            variant = shim;
            map.put(variant2, variant);
            if (createdVariantMap.get(variantType) != null) {
                throw (Throwable)new RuntimeException("More than one VariantFactory with same type " + variantType);
            }
            createdVariantMap.put(variantType, variant2);
        }
        for (VariantFactory2<E> factory : this.factories) {
            Variant generatedVariant;
            Variant testVariant;
            if ((Variant)createdVariantMap.get(factory.getGeneratedType()) == null) {
                continue;
            }
            VariantType testTargetType = factory.getTestTarget();
            if (testTargetType != null && (testVariant = (Variant)createdVariantMap.get(testTargetType)) != null) {
                Map testMap2;
                Object v = variantDispatcher.computeIfAbsent(testTargetType, createVariant.testMap.1.INSTANCE);
                if (v == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<com.android.build.api.dsl.variant.Variant, com.android.build.api.dsl.variant.Variant>");
                }
                variantType = testMap2 = TypeIntrinsics.asMutableMap(v);
                if (this._shims.get(testVariant) == null) {
                    Intrinsics.throwNpe();
                }
                variantType.put(generatedVariant, shim);
            }
            for (VariantType testedByType : factory.getTestedBy()) {
                Map<Variant, Variant> testedMap2;
                Variant testedVariant = (Variant)createdVariantMap.get(testedByType);
                if (testedVariant == null) continue;
                Object v = variantDispatcher.computeIfAbsent(testedByType, createVariant.testedMap.1.INSTANCE);
                if (v == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<com.android.build.api.dsl.variant.Variant, com.android.build.api.dsl.variant.Variant>");
                }
                map = testedMap2 = TypeIntrinsics.asMutableMap(v);
                if (this._shims.get(testedVariant) == null) {
                    Intrinsics.throwNpe();
                }
                map.put(generatedVariant, variant);
            }
        }
    }

    private final VariantPropertiesImpl mergeVariantProperties(List<? extends VariantProperties> items) {
        VariantPropertiesImpl variantProperties = new VariantPropertiesImpl(this.issueReporter);
        VariantBuilderKt.access$takeLastNonNull(variantProperties, items, VariantBuilderKt.access$getSET_MULTIDEX_ENABLED$p(), VariantBuilderKt.access$getGET_MULTIDEX_ENABLED$p());
        VariantBuilderKt.access$takeLastNonNull(variantProperties, items, VariantBuilderKt.access$getSET_MULTIDEX_KEEPFILE$p(), VariantBuilderKt.access$getGET_MULTIDEX_KEEPFILE$p());
        return variantProperties;
    }

    private final ProductFlavorOrVariantImpl mergeProductFlavorOrVariant(List<? extends ProductFlavorOrVariant> items) {
        ProductFlavorOrVariantImpl productFlavorOrVariant = new ProductFlavorOrVariantImpl(this.issueReporter);
        return productFlavorOrVariant;
    }

    private final BuildTypeOrVariantImpl cloneBuildTypeOrVariant(BuildTypeImpl that) {
        BuildTypeOrVariantImpl buildTypeOrVariant = new BuildTypeOrVariantImpl("Variant", false, false, false, this.deprecationReporter, this.issueReporter);
        buildTypeOrVariant.initWith$gradle_core_main(that.getBuildTypeOrVariant$gradle_core_main());
        return buildTypeOrVariant;
    }

    private final VariantOrExtensionPropertiesImpl cloneVariantOrExtensionProperties(VariantOrExtensionPropertiesImpl that) {
        VariantOrExtensionPropertiesImpl prop = new VariantOrExtensionPropertiesImpl(this.issueReporter);
        prop.initWith(that);
        return prop;
    }

    private final CommonVariantPropertiesImpl computeCommonVariantPropertiesImpl(String variantName, FlavorCombination flavorCombo, BuildTypeImpl buildType) {
        String string;
        ImmutableList immutableList = flavorCombo;
        if (immutableList == null || (immutableList = immutableList.getFlavors()) == null) {
            ImmutableList immutableList2 = ImmutableList.of();
            immutableList = immutableList2;
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList2, (String)"ImmutableList.of()");
        }
        ImmutableList flavors = immutableList;
        NamedDomainObjectContainer<DefaultAndroidSourceSet> allSourceSets = this.dslModelData.getSourceSets();
        List sourceSets = new ArrayList();
        Object object = allSourceSets.getByName("main");
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"allSourceSets.getByName(BuilderConstants.MAIN)");
        sourceSets.add(object);
        List list = flavors.stream().map(new Function<T, R>(allSourceSets){
            final /* synthetic */ NamedDomainObjectContainer $allSourceSets;

            public final DefaultAndroidSourceSet apply(ProductFlavorImpl it) {
                return (DefaultAndroidSourceSet)this.$allSourceSets.getByName(it.getName());
            }
            {
                this.$allSourceSets = namedDomainObjectContainer;
            }
        }).collect(Collectors.toList());
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"flavors.stream()\n       \u2026lect(Collectors.toList())");
        sourceSets.addAll(list);
        Object object2 = allSourceSets.getByName(buildType.getName());
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"allSourceSets.getByName(buildType.name)");
        sourceSets.add(object2);
        DefaultAndroidSourceSet variantSourceSet = (DefaultAndroidSourceSet)allSourceSets.create(variantName);
        AndroidSourceSet multiFlavorSourceSet = null;
        ImmutableList immutableList3 = flavorCombo;
        String it = string = immutableList3 != null ? immutableList3.getName() : null;
        multiFlavorSourceSet = (AndroidSourceSet)allSourceSets.create(it);
        String string2 = buildType.getName();
        Object object3 = flavorCombo;
        if (object3 == null || (object3 = object3.getFlavorNames()) == null) {
            ImmutableList immutableList4 = ImmutableList.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList4, (String)"ImmutableList.of()");
            object3 = (List)immutableList4;
        }
        DefaultAndroidSourceSet defaultAndroidSourceSet = variantSourceSet;
        Intrinsics.checkExpressionValueIsNotNull((Object)defaultAndroidSourceSet, (String)"variantSourceSet");
        return new CommonVariantPropertiesImpl(variantName, string2, (List<String>)object3, sourceSets, defaultAndroidSourceSet, multiFlavorSourceSet, this.issueReporter);
    }

    public VariantBuilder(@NotNull DslModelData dslModelData, @NotNull E extension, @NotNull List<? extends VariantFactory2<? super E>> factories, @NotNull DeprecationReporter deprecationReporter, @NotNull EvalIssueReporter issueReporter) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)dslModelData, (String)"dslModelData");
        Intrinsics.checkParameterIsNotNull(extension, (String)"extension");
        Intrinsics.checkParameterIsNotNull(factories, (String)"factories");
        Intrinsics.checkParameterIsNotNull((Object)deprecationReporter, (String)"deprecationReporter");
        Intrinsics.checkParameterIsNotNull((Object)issueReporter, (String)"issueReporter");
        this.dslModelData = dslModelData;
        this.extension = extension;
        this.factories = factories;
        this.deprecationReporter = deprecationReporter;
        this.issueReporter = issueReporter;
        VariantBuilder variantBuilder = this;
        variantBuilder._variants = list = (List)new ArrayList();
        IdentityHashMap identityHashMap = Maps.newIdentityHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)identityHashMap, (String)"Maps.newIdentityHashMap()");
        this._shims = identityHashMap;
    }
}

